/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.stack.config.preprocessor;

import java.util.ArrayList;
import scouter.client.stack.config.ParserConfig;
import scouter.client.stack.config.preprocessor.ParserPreProcessorReader;
import scouter.client.stack.config.preprocessor.Processor;
import scouter.client.stack.utils.StringUtils;

public class PreProcessor {
    public static void process(ParserConfig config, ArrayList<String> list) {
        ArrayList<Processor> processorList = config.getStackPreprocessorList();
        if (processorList == null || processorList.size() == 0) {
            return;
        }
        int i = 0;
        int ii = 0;
        int start = 0;
        int pSize = processorList.size();
        int sSize = list.size();
        Processor processor = null;
        String line = null;
        Processor.TARGET target = config.getStackPreprocessorTarget();
        if (target != Processor.TARGET.ALL) {
            if (target == Processor.TARGET.HEADER) {
                sSize = config.getStackStartLine();
            } else if (target == Processor.TARGET.STACK) {
                start = config.getStackStartLine();
            }
        }
        String filter = null;
        String newline = null;
        i = 0;
        while (i < pSize) {
            processor = processorList.get(i);
            if (processor != null) {
                filter = processor.getFilter();
                ii = start;
                while (ii < sSize) {
                    line = list.get(ii);
                    if (filter == null || line.indexOf(filter) >= 0) {
                        newline = processor.process(line);
                        if (newline == null) {
                            list.remove(ii);
                            --ii;
                            --sSize;
                        } else if (!line.equals(newline)) {
                            list.set(ii, newline);
                        }
                    }
                    ++ii;
                }
            }
            ++i;
        }
    }

    public static void readPreprocessor(ParserConfig config, String filename) {
        String fullPath = String.valueOf(StringUtils.getDiretory(config.getConfigFilename())) + "\\" + filename;
        ParserPreProcessorReader reader = new ParserPreProcessorReader(fullPath);
        try {
            config.setStackPreprocessorTarget(reader.readTarget());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        ArrayList<Processor> processorList = reader.readProcessors();
        if (processorList != null && processorList.size() > 0) {
            config.setStackPreprocessorList(processorList);
        }
    }
}

