/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.stack.config.preprocessor;

import org.w3c.dom.Node;
import scouter.client.stack.config.preprocessor.ParserPreProcessorReader;
import scouter.client.stack.config.preprocessor.Processor;

public class ProcessorRemoveCount
extends Processor {
    private int m_count = 0;
    private int m_position = 0;

    public ProcessorRemoveCount(String count) {
        this.setType(Processor.TYPE.REMOVE);
        try {
            this.m_count = Integer.parseInt(count);
        }
        catch (Exception ex) {
            throw new RuntimeException("processor count attribute is a integer greater than -1(" + count + ")");
        }
    }

    @Override
    public String process(String line) {
        if (line.length() <= this.m_position) {
            return line;
        }
        StringBuilder buffer = new StringBuilder(100);
        if (this.m_position == 0) {
            buffer.append(line.substring(this.m_count));
        } else {
            buffer.append(line.substring(0, this.m_position));
            if (line.length() >= this.m_position + this.m_count) {
                buffer.append(line.substring(this.m_position + this.m_count - 1));
            }
        }
        return buffer.toString();
    }

    @Override
    public void readConfig(ParserPreProcessorReader reader, Node node) {
        try {
            this.m_position = Integer.parseInt(reader.getAttribute(node, "position"));
        }
        catch (Exception ex) {
            throw new RuntimeException("processor position attribute is abnormal!");
        }
        if (this.m_position < 0) {
            throw new RuntimeException("processor position attribute is abnormal!");
        }
    }
}

