/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.stack.config.preprocessor;

import org.w3c.dom.Node;
import scouter.client.stack.config.preprocessor.ParserPreProcessorReader;
import scouter.client.stack.config.preprocessor.Processor;

public class ProcessorRemoveFrom
extends Processor {
    private String m_from = null;
    private int m_skipCount = 0;

    public ProcessorRemoveFrom(String from) {
        this.setType(Processor.TYPE.REMOVE);
        this.m_from = from;
    }

    @Override
    public String process(String line) {
        int currentCount = 0;
        int currentIndex = 0;
        while ((currentIndex = line.indexOf(this.m_from, currentIndex)) >= 0) {
            if (currentCount == this.m_skipCount) {
                return line.substring(0, currentIndex);
            }
            ++currentCount;
            ++currentIndex;
        }
        return line;
    }

    @Override
    public void readConfig(ParserPreProcessorReader reader, Node node) {
        String skipCount = null;
        try {
            skipCount = reader.getAttribute(node, "skipCount");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        try {
            this.m_skipCount = Integer.parseInt(skipCount);
        }
        catch (Exception ex) {
            throw new RuntimeException("processor skipCount attribute is a integer greater than -1(" + skipCount + ")");
        }
        if (this.m_skipCount < 0) {
            throw new RuntimeException("processor skipCount attribute is abnormal(" + skipCount + ")!");
        }
    }
}

