/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.stack.config.preprocessor;

import org.w3c.dom.Node;
import scouter.client.stack.config.preprocessor.ParserPreProcessorReader;
import scouter.client.stack.config.preprocessor.Processor;

public class ProcessorRemoveStart
extends Processor {
    private String m_start = null;
    private String m_end = null;
    private int m_skipCount = 0;

    public ProcessorRemoveStart(String start) {
        this.setType(Processor.TYPE.REMOVE);
        this.m_start = start;
    }

    @Override
    public String process(String line) {
        int currentCount = 0;
        int currentIndex = 0;
        int endSize = this.m_end.length();
        while ((currentIndex = line.indexOf(this.m_start, currentIndex)) >= 0) {
            if (currentCount == this.m_skipCount) {
                int endIndex = line.indexOf(this.m_end, currentIndex + 1);
                if (endIndex > 0) {
                    StringBuilder buffer = new StringBuilder(100);
                    if (currentIndex == 0) {
                        buffer.append(line.substring(endIndex + endSize));
                    } else if (endSize >= line.length()) {
                        buffer.append(line.substring(0, currentIndex));
                    } else {
                        buffer.append(line.substring(0, currentIndex));
                        buffer.append(line.substring(endSize));
                    }
                    return buffer.toString();
                }
                return line;
            }
            ++currentCount;
            ++currentIndex;
        }
        return line;
    }

    @Override
    public void readConfig(ParserPreProcessorReader reader, Node node) {
        String skipCount = null;
        try {
            this.m_end = reader.getAttribute(node, "end");
            skipCount = reader.getAttribute(node, "skipCount");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        try {
            this.m_skipCount = Integer.parseInt(skipCount);
        }
        catch (Exception ex) {
            throw new RuntimeException("processor skipCount attribute is a integer greater than -1(" + skipCount + ")");
        }
        if (this.m_skipCount < 0) {
            throw new RuntimeException("processor skipCount attribute is abnormal(" + skipCount + ")!");
        }
    }
}

