/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.stack.config.preprocessor;

import org.w3c.dom.Node;
import scouter.client.stack.config.preprocessor.ParserPreProcessorReader;
import scouter.client.stack.config.preprocessor.Processor;

public class ProcessorReplace
extends Processor {
    private String m_source = null;
    private String m_target = null;
    private boolean m_isAll = true;

    public ProcessorReplace() {
        this.setType(Processor.TYPE.REPLACE);
    }

    @Override
    public String process(String line) {
        if (this.m_isAll) {
            return line.replaceAll(this.m_source, this.m_target);
        }
        return line.replaceFirst(this.m_source, this.m_target);
    }

    @Override
    public void readConfig(ParserPreProcessorReader reader, Node node) {
        try {
            this.m_source = reader.getAttribute(node, "source");
            this.m_target = reader.getAttribute(node, "target");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        String isAll = null;
        try {
            isAll = reader.getAttribute(node, "all");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (isAll != null) {
            try {
                this.m_isAll = Boolean.parseBoolean(isAll);
            }
            catch (Exception ex) {
                throw new RuntimeException("all attribute(true/false) of replace type processor is abnormal!(" + isAll + ")");
            }
        }
    }
}

