/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.stack.config.preprocessor;

import org.w3c.dom.Node;
import scouter.client.stack.config.preprocessor.ParserPreProcessorReader;
import scouter.client.stack.config.preprocessor.Processor;

public class ProcessorReplaceStart
extends Processor {
    private String m_start = null;
    private String m_end = null;
    private String m_target = null;
    private int m_skipCount = 0;

    public ProcessorReplaceStart(String start) {
        this.setType(Processor.TYPE.REPLACE);
        this.m_start = start;
    }

    @Override
    public String process(String line) {
        int currentCount = 0;
        int currentIndex = 0;
        while ((currentIndex = line.indexOf(this.m_start, currentIndex)) >= 0) {
            if (currentCount == this.m_skipCount) {
                int endIndex = line.indexOf(this.m_end, currentIndex + 1);
                if (endIndex > 0) {
                    StringBuilder buffer = new StringBuilder(100);
                    if (currentIndex == 0) {
                        buffer.append(this.m_target).append(line.substring(endIndex + 1));
                    } else if (endIndex + 1 >= line.length()) {
                        buffer.append(line.substring(0, currentIndex)).append(this.m_target);
                    } else {
                        buffer.append(line.substring(0, currentIndex)).append(this.m_target);
                        buffer.append(line.substring(endIndex + 1));
                    }
                    return buffer.toString();
                }
                return line;
            }
            ++currentCount;
            ++currentIndex;
        }
        return line;
    }

    @Override
    public void readConfig(ParserPreProcessorReader reader, Node node) {
        String skipCount = null;
        try {
            this.m_end = reader.getAttribute(node, "end");
            this.m_target = reader.getAttribute(node, "target");
            skipCount = reader.getAttribute(node, "skipCount");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        try {
            this.m_skipCount = Integer.parseInt(skipCount);
        }
        catch (Exception ex) {
            throw new RuntimeException("processor skipCount attribute is a integer greater than -1(" + skipCount + ")");
        }
        if (this.m_skipCount < 0) {
            throw new RuntimeException("processor skipCount attribute is abnormal(" + skipCount + ")!");
        }
    }
}

