/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.stack.data;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.zip.ZipInputStream;
import scouter.client.stack.config.ParserConfig;
import scouter.client.stack.data.StackParser;
import scouter.client.stack.data.ThreadStatusInfo;
import scouter.client.stack.utils.ResourceUtils;
import scouter.client.stack.utils.StringUtils;

public class DevonFileStackParser
extends StackParser {
    public DevonFileStackParser() {
    }

    public DevonFileStackParser(ParserConfig config) {
        super(config);
    }

    @Override
    public void process() {
        BufferedReader reader = null;
        ZipInputStream zipInputStream = null;
        try {
            try {
                int tsIndex;
                if (this.getStackContents() != null) {
                    reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.getStackContents().getBytes())));
                } else if (ResourceUtils.isZipFile(this.getStackFileInfo().getFilename())) {
                    zipInputStream = new ZipInputStream(new FileInputStream(new File(this.getStackFileInfo().getFilename())));
                    zipInputStream.getNextEntry();
                    reader = new BufferedReader(new InputStreamReader(zipInputStream));
                } else {
                    reader = new BufferedReader(new FileReader(new File(this.getStackFileInfo().getFilename())));
                }
                StringBuilder timeBuffer = null;
                String line = null;
                boolean isWorking = false;
                ArrayList<String> workingList = new ArrayList<String>(300);
                ArrayList<String> workerThread = this.getWorkerThread();
                int lineCount = 0;
                int workerCount = 0;
                int workingCount = 0;
                int totalWorkerCount = 0;
                int dumpCount = 0;
                ThreadStatusInfo tsinfo = new ThreadStatusInfo();
                ParserConfig config = this.getConfig();
                String timeFilter = config.getTimeFilter();
                int timePosition = config.getTimePosition();
                int timeSize = config.getTimeSize();
                int stackStartLine = config.getStackStartLine();
                String timeMatchStr = null;
                if (timeFilter != null && timeSize > 0) {
                    timeMatchStr = new StringBuilder(50).append("*").append(timeFilter).append("*").toString();
                }
                while ((line = reader.readLine()) != null) {
                    int eIndex;
                    int sIndex;
                    this.progressBar();
                    if (line.trim().length() == 0) {
                        if (isWorking && lineCount > stackStartLine) {
                            this.processStack(workingList, tsinfo);
                        }
                        isWorking = false;
                        workingList = new ArrayList(300);
                        lineCount = 0;
                        continue;
                    }
                    if (lineCount == 0) {
                        if (timeMatchStr != null && line.matches(timeMatchStr) && line.length() >= timePosition + timeSize) {
                            if (timeBuffer != null && timeBuffer.length() > 10) {
                                timeBuffer.append('\t').append(workerCount).append('\t').append(workingCount);
                                tsIndex = 0;
                                while (tsIndex < tsinfo.geSize()) {
                                    timeBuffer.append('\t').append(tsinfo.getValue(tsIndex));
                                    ++tsIndex;
                                }
                                this.addTime(timeBuffer.toString());
                            }
                            timeBuffer = new StringBuilder(50);
                            timeBuffer.append(line.substring(timePosition, timePosition + timeSize));
                            tsinfo = new ThreadStatusInfo();
                            this.writeTime(line);
                            workerCount = 0;
                            workingCount = 0;
                            ++dumpCount;
                        } else if (StringUtils.checkExist(line, workerThread)) {
                            ++workerCount;
                            ++totalWorkerCount;
                        }
                    }
                    if (!isWorking && this.isWorkingThread(line)) {
                        isWorking = true;
                        ++workingCount;
                    }
                    if ((sIndex = line.indexOf("$$")) > 0 && (eIndex = line.indexOf(46, sIndex)) > 0) {
                        String newLine = line.substring(0, sIndex);
                        line = newLine = String.valueOf(newLine) + line.substring(eIndex);
                    }
                    workingList.add(line);
                    ++lineCount;
                }
                if (isWorking && lineCount > stackStartLine) {
                    this.processStack(workingList, tsinfo);
                }
                if (timeMatchStr != null && timeBuffer != null && timeBuffer.length() > 10) {
                    timeBuffer.append('\t').append(workerCount).append('\t').append(workingCount);
                    tsIndex = 0;
                    while (tsIndex < tsinfo.geSize()) {
                        timeBuffer.append('\t').append(tsinfo.getValue(tsIndex));
                        ++tsIndex;
                    }
                    this.addTime(timeBuffer.toString());
                }
                this.setTotalWorkerCount(totalWorkerCount);
                this.setDumpCount(dumpCount);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            if (zipInputStream != null) {
                try {
                    zipInputStream.closeEntry();
                }
                catch (Exception exception) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

