/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.stack.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import scouter.client.stack.config.ParserConfig;
import scouter.client.stack.data.StackParser;
import scouter.client.stack.data.ThreadStatusInfo;
import scouter.client.stack.utils.StringUtils;

public class FilterExcludeStackParser
extends StackParser {
    public FilterExcludeStackParser() {
    }

    public FilterExcludeStackParser(ParserConfig config) {
        super(config);
    }

    @Override
    public void process() {
        BufferedReader reader = null;
        try {
            try {
                int tsIndex;
                reader = new BufferedReader(new FileReader(new File(this.getStackFileInfo().getFilename())));
                StringBuilder timeBuffer = null;
                String line = null;
                boolean isWorking = true;
                ArrayList<String> workingList = new ArrayList<String>(300);
                ArrayList<String> workerThread = this.getWorkerThread();
                String filter = this.getFilter();
                ThreadStatusInfo tsinfo = new ThreadStatusInfo();
                int lineCount = 0;
                int workerCount = 0;
                int workingCount = 0;
                int totalWorkerCount = 0;
                int dumpCount = 0;
                ParserConfig config = this.getStackFileInfo().getParserConfig();
                int stackStartLine = config.getStackStartLine();
                int timeSize = config.getTimeSize();
                while ((line = reader.readLine()) != null) {
                    this.progressBar();
                    if (line.trim().length() == 0) {
                        if (isWorking && lineCount > stackStartLine) {
                            ++workingCount;
                            this.processStack(workingList, tsinfo);
                        }
                        isWorking = true;
                        workingList = new ArrayList(300);
                        lineCount = 0;
                        continue;
                    }
                    if (lineCount == 0) {
                        if (line.length() == timeSize) {
                            if (timeBuffer != null && timeBuffer.length() > 10) {
                                timeBuffer.append('\t').append(workerCount).append('\t').append(workingCount);
                                tsIndex = 0;
                                while (tsIndex < tsinfo.geSize()) {
                                    timeBuffer.append('\t').append(tsinfo.getValue(tsIndex));
                                    ++tsIndex;
                                }
                                this.addTime(timeBuffer.toString());
                            }
                            timeBuffer = new StringBuilder(50);
                            timeBuffer.append(line);
                            this.writeTime(line);
                            tsinfo = new ThreadStatusInfo();
                            workerCount = 0;
                            workingCount = 0;
                            ++dumpCount;
                        } else if (StringUtils.checkExist(line, workerThread)) {
                            ++workerCount;
                            ++totalWorkerCount;
                        }
                    }
                    if (isWorking && line.indexOf(filter) >= 0) {
                        isWorking = false;
                    }
                    workingList.add(line);
                    ++lineCount;
                }
                if (isWorking && lineCount > stackStartLine) {
                    ++workingCount;
                    this.processStack(workingList, tsinfo);
                }
                if (timeBuffer != null && timeBuffer.length() > 10) {
                    timeBuffer.append('\t').append(workerCount).append('\t').append(workingCount);
                    tsIndex = 0;
                    while (tsIndex < tsinfo.geSize()) {
                        timeBuffer.append('\t').append(tsinfo.getValue(tsIndex));
                        ++tsIndex;
                    }
                    this.addTime(timeBuffer.toString());
                }
                this.setTotalWorkerCount(totalWorkerCount);
                this.setDumpCount(dumpCount);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

