/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.stack.data;

import java.util.ArrayList;
import scouter.client.stack.data.AbstractInfo;
import scouter.client.stack.data.StackAnalyzedValue;
import scouter.client.stack.data.StackFileInfo;
import scouter.client.stack.utils.NumberUtils;

public class StackAnalyzedInfo
extends AbstractInfo {
    private String m_analyzedName = null;
    private int m_totalCount = 0;
    private ArrayList<StackAnalyzedValue> m_analyzedList = null;
    private StackFileInfo m_stackFileInfo = null;
    private String m_extension = null;

    public StackAnalyzedInfo(String value, StackFileInfo stackFileInfo, String extension) {
        this.m_analyzedName = value;
        this.m_stackFileInfo = stackFileInfo;
        this.setName("StackAnalyzed");
        this.m_extension = extension;
    }

    @Override
    public String getName() {
        return this.m_analyzedName;
    }

    public void setTotalCount(int value) {
        this.m_totalCount = value;
    }

    public int getTotalcount() {
        return this.m_totalCount;
    }

    public ArrayList<StackAnalyzedValue> getAnalyzedList() {
        return this.m_analyzedList;
    }

    public String getExtension() {
        return this.m_extension;
    }

    public void setAnaylizedList(ArrayList<StackAnalyzedValue> value) {
        this.m_analyzedList = value;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(100);
        if (this.m_stackFileInfo.getTotalWorkingCount() > 0) {
            buffer.append(this.m_analyzedName).append(" - ").append(this.m_totalCount).append(" (").append(NumberUtils.intToPercent(10000 * this.m_totalCount / this.m_stackFileInfo.getTotalWorkingCount())).append("%)");
        } else {
            buffer.append(this.m_analyzedName).append(" - ").append(this.m_totalCount).append(" (0%)");
        }
        return buffer.toString();
    }

    public String[] toTreeInfo() {
        String[] info = new String[]{this.m_analyzedName, "" + this.m_totalCount, this.m_stackFileInfo.getTotalWorkingCount() > 0 ? NumberUtils.intToPercent(10000 * this.m_totalCount / this.m_stackFileInfo.getTotalWorkingCount()) + '%' : "0%"};
        return info;
    }

    public StackFileInfo getStackFileInfo() {
        return this.m_stackFileInfo;
    }
}

