/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.stack.data;

import java.util.ArrayList;
import scouter.client.stack.config.ParserConfig;
import scouter.client.stack.data.AbstractInfo;
import scouter.client.stack.data.StackAnalyzedInfo;
import scouter.client.stack.data.StackParser;

public class StackFileInfo
extends AbstractInfo {
    private String m_filename;
    private StackParser m_usedParser;
    private ParserConfig m_parserConfig;
    private int m_dumpCount = 0;
    private int m_totalWorkerCount = 0;
    private int m_totalWorkingCount = 0;
    private int m_totalSecond = 0;
    private ArrayList<String> m_timeList = null;
    private ArrayList<StackAnalyzedInfo> m_stackAnalyzedInfoList = null;
    private ArrayList<String> m_threadStatusList = new ArrayList();

    public StackFileInfo(String value) {
        this.m_filename = value;
        this.setName("StackFile");
    }

    public String getFilename() {
        return this.m_filename;
    }

    public void setFilename(String filename) {
        this.m_filename = filename;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(200);
        buffer.append(this.m_filename).append(" - ").append(this.m_totalWorkingCount);
        if (this.m_totalWorkerCount > 0) {
            buffer.append(" (").append(this.m_totalWorkerCount).append(')');
        }
        if (this.m_dumpCount > 0) {
            buffer.append(" - ").append(this.m_dumpCount).append("dump");
        }
        return buffer.toString();
    }

    public String[] toTreeInfo() {
        String[] info = new String[3];
        info[0] = this.m_filename;
        StringBuilder buffer = new StringBuilder().append(this.m_totalWorkingCount);
        if (this.m_totalWorkerCount > 0) {
            buffer.append(" (").append(this.m_totalWorkerCount).append(')');
        }
        info[1] = buffer.toString();
        info[2] = new StringBuffer().append(this.m_dumpCount).append(" dump").toString();
        return info;
    }

    public StackParser getUsedParser() {
        return this.m_usedParser;
    }

    public void setUsedParser(StackParser parser) {
        if (this.m_usedParser == null) {
            this.m_usedParser = parser;
        }
    }

    public int getDumpCount() {
        return this.m_dumpCount;
    }

    public void setDumpCount(int value) {
        this.m_dumpCount = value;
    }

    public int getTotalWorkingCount() {
        return this.m_totalWorkingCount;
    }

    public void setTotalWorkingCount(int value) {
        this.m_totalWorkingCount = value;
    }

    public int getTotalWorkerCount() {
        return this.m_totalWorkerCount;
    }

    public void setTotalWorkerCount(int value) {
        this.m_totalWorkerCount = value;
    }

    public void setTotalSecond(int seconds) {
        this.m_totalSecond = seconds;
    }

    public int getTotalSecond() {
        return this.m_totalSecond;
    }

    public StackAnalyzedInfo getStackAnalyzedInfo(int i) {
        if (this.m_stackAnalyzedInfoList == null) {
            return null;
        }
        return this.m_stackAnalyzedInfoList.get(i);
    }

    public ArrayList<StackAnalyzedInfo> getStackAnalyzedInfoList() {
        return this.m_stackAnalyzedInfoList;
    }

    public void addStackAnalyzedInfo(StackAnalyzedInfo info) {
        if (this.m_stackAnalyzedInfoList == null) {
            this.m_stackAnalyzedInfoList = new ArrayList();
        }
        this.m_stackAnalyzedInfoList.add(info);
    }

    public void setParserConfig(ParserConfig config) {
        this.m_parserConfig = config;
    }

    public ParserConfig getParserConfig() {
        return this.m_parserConfig;
    }

    public void clearAll() {
        if (this.m_stackAnalyzedInfoList != null) {
            this.m_stackAnalyzedInfoList.clear();
        }
        this.m_dumpCount = 0;
        this.m_totalWorkerCount = 0;
        this.m_totalWorkingCount = 0;
        this.m_totalSecond = 0;
    }

    public void setTimeList(ArrayList<String> list) {
        this.m_timeList = list;
    }

    public ArrayList<String> getTimeList() {
        return this.m_timeList;
    }

    public void setThreadStatusList(ArrayList<String> list) {
        this.m_threadStatusList = list;
    }

    public ArrayList<String> getThreadStatusList() {
        return this.m_threadStatusList;
    }
}

