/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.stack.data;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import scouter.client.stack.base.MainProcessor;
import scouter.client.stack.base.ProgressBarWindow;
import scouter.client.stack.config.AnalyzerValue;
import scouter.client.stack.config.ParserConfig;
import scouter.client.stack.config.ParserConfigReader;
import scouter.client.stack.config.preprocessor.PreProcessor;
import scouter.client.stack.data.BasicFileStackParser;
import scouter.client.stack.data.FilterExcludeStackParser;
import scouter.client.stack.data.FilterStackParser;
import scouter.client.stack.data.StackAnalyzedInfo;
import scouter.client.stack.data.StackAnalyzedValue;
import scouter.client.stack.data.StackAnalyzedValueComp;
import scouter.client.stack.data.StackFileInfo;
import scouter.client.stack.data.ThreadStatusInfo;
import scouter.client.stack.data.UniqueStackValue;
import scouter.client.stack.utils.ResourceUtils;
import scouter.client.stack.utils.StringUtils;

public abstract class StackParser {
    public static final String EXTENSION = "scouter";
    public static final String INFO_EXTENSION = "info";
    public static final String INFO_EXT = "INFO";
    public static final String WORKINGTHREAD_EXT = "WS";
    public static final String TOP_EXT = "TOP";
    public static final String TOP_NAME = "Top Stack ";
    public static final String SQL_EXT = "SQL";
    public static final String SQL_NAME = "SQL Call";
    public static final String SERVICE_EXT = "SVC";
    public static final String SERVICE_NAME = "Service Call";
    public static final String LOG_EXT = "LOG";
    public static final String LOG_NAME = "Logging Call";
    public static final String UNIQUE_EXT = "UNQ";
    public static final String UNIQUE_NAME = "Unique Stack";
    private ParserConfig m_config = null;
    private StackFileInfo m_stackFile = null;
    private String m_stackContents = null;
    private BufferedWriter m_workingThread_writer = null;
    private ArrayList<String> m_workingThread = null;
    private ArrayList<String> m_sql = null;
    private ArrayList<String> m_service = null;
    private ArrayList<String> m_log = null;
    private ArrayList<String> m_workerThread = null;
    private ArrayList<String> m_topList = null;
    private ArrayList<String> m_sqlList = null;
    private ArrayList<String> m_serviceList = null;
    private ArrayList<String> m_logList = null;
    private ArrayList<String> m_timeList = null;
    private ArrayList<String> m_threadStatusList = null;
    protected int m_totalWorkingCount = 0;
    protected int m_totalWorkerCount = 0;
    protected int m_dumpCount = 0;
    protected int m_totalSecond = 0;
    private ArrayList<AnalyzerValue> m_analyzer = null;
    private ArrayList[] m_analyzerList = null;
    private int m_analyzerCount = 0;
    private String m_filter = null;
    private ProgressBarWindow m_progressBarWindow = null;
    private int m_totalLineCount = 0;
    private int m_processPercent = 0;
    private MainProcessor m_mainProcessor = null;
    HashMap<Integer, UniqueStackValue> m_uniqueStackMap = null;

    protected StackParser() {
    }

    protected StackParser(ParserConfig config) {
        if (config == null) {
            throw new RuntimeException("Configuration is not exist!");
        }
        this.m_config = config;
    }

    public void setConfig(ParserConfig config) {
        if (config == null) {
            throw new RuntimeException("Configuration is not exist!");
        }
        this.m_config = config;
    }

    public ParserConfig getConfig() {
        return this.m_config;
    }

    public void setFilter(String filter) {
        this.m_filter = filter;
    }

    public String getFilter() {
        return this.m_filter;
    }

    public ArrayList<String> getWorkerThread() {
        return this.m_workerThread;
    }

    public ArrayList<String> getWorkingThread() {
        return this.m_workingThread;
    }

    public StackFileInfo getStackFileInfo() {
        return this.m_stackFile;
    }

    public void setStackContents(String contents) {
        this.m_stackContents = contents;
    }

    public String getStackContents() {
        return this.m_stackContents;
    }

    private void init() {
        this.m_workingThread = this.m_config.getWorkingThread();
        if (this.m_workingThread == null || this.m_workingThread.size() == 0) {
            throw new RuntimeException("WorkingThread infomation must be exist!");
        }
        this.m_sql = this.m_config.getSql();
        this.m_service = this.m_config.getService();
        this.m_log = this.m_config.getLog();
        this.m_workerThread = this.m_config.getWorkerThread();
        this.m_analyzer = this.m_config.getAnalyzerList();
        this.m_topList = new ArrayList(2000);
        this.m_sqlList = new ArrayList(2000);
        this.m_serviceList = new ArrayList(2000);
        this.m_logList = new ArrayList(2000);
        this.m_timeList = new ArrayList(2000);
        this.m_threadStatusList = new ArrayList();
        this.m_uniqueStackMap = new HashMap(2000);
        if (this.m_analyzer != null) {
            this.m_analyzerCount = this.m_analyzer.size();
            this.m_analyzerList = new ArrayList[this.m_analyzerCount];
            int i = 0;
            while (i < this.m_analyzerCount) {
                this.m_analyzerList[i] = new ArrayList(2000);
                ++i;
            }
        }
        this.m_totalWorkingCount = 0;
        try {
            this.m_workingThread_writer = new BufferedWriter(new FileWriter(this.getWorkingThreadFilename()));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void analyze(StackFileInfo stackFile) {
        String stackFilename;
        this.m_stackFile = stackFile;
        this.m_stackFile.clearAll();
        this.m_stackFile.setUsedParser(this);
        this.m_stackFile.setParserConfig(this.m_config);
        this.m_mainProcessor = MainProcessor.instance();
        this.init();
        this.m_progressBarWindow = new ProgressBarWindow(this.m_mainProcessor.getParentComposite().getShell(), "Stack log file Analyzing");
        try {
            this.process();
            this.makeTotalSecond();
        }
        finally {
            if (this.m_workingThread_writer != null) {
                try {
                    this.m_workingThread_writer.close();
                }
                catch (Exception exception) {}
            }
            this.m_progressBarWindow.close();
        }
        if (this.m_filter != null && (stackFilename = this.getNewFilterFilename()) != null) {
            this.m_stackFile.setFilename(stackFilename);
        }
        this.saveAll();
        this.clearAll();
        this.m_stackFile = null;
    }

    private String getNewFilterFilename() {
        String ext;
        String stackFilename = this.m_stackFile.getFilename();
        int index = stackFilename.indexOf(ext = new StringBuilder(20).append('_').append(WORKINGTHREAD_EXT).append('.').append(EXTENSION).toString());
        if (index > 0) {
            stackFilename = this instanceof FilterExcludeStackParser ? new StringBuilder(200).append(stackFilename.substring(0, index)).append(".(E)").append(this.m_filter).toString() : new StringBuilder(200).append(stackFilename.substring(0, index)).append(".(I)").append(this.m_filter).toString();
            return stackFilename;
        }
        return null;
    }

    protected void clearAll() {
        this.m_topList = null;
        this.m_sqlList = null;
        this.m_serviceList = null;
        this.m_logList = null;
        this.m_timeList = null;
        this.m_threadStatusList = null;
        this.m_analyzerList = null;
        this.m_uniqueStackMap = null;
        this.m_totalWorkingCount = 0;
        this.m_totalWorkerCount = 0;
        this.m_totalSecond = 0;
        this.m_dumpCount = 0;
        this.m_totalLineCount = 0;
        this.m_processPercent = 0;
        this.m_analyzerCount = 0;
        this.m_workingThread = null;
        this.m_sql = null;
        this.m_service = null;
        this.m_log = null;
        this.m_workerThread = null;
        this.m_analyzer = null;
    }

    public abstract void process();

    private void saveAll() {
        this.m_stackFile.setDumpCount(this.m_dumpCount);
        this.m_stackFile.setTotalWorkerCount(this.m_totalWorkerCount);
        this.m_stackFile.setTotalWorkingCount(this.m_totalWorkingCount);
        this.m_stackFile.setTotalSecond(this.m_totalSecond);
        StackAnalyzedInfo info = this.saveStackAnalyzedInfo(this.m_topList, TOP_NAME, TOP_EXT);
        if (info != null) {
            this.m_stackFile.addStackAnalyzedInfo(info);
        }
        if ((info = this.saveStackAnalyzedInfo(this.m_sqlList, SQL_NAME, SQL_EXT)) != null) {
            this.m_stackFile.addStackAnalyzedInfo(info);
        }
        if ((info = this.saveStackAnalyzedInfo(this.m_serviceList, SERVICE_NAME, SERVICE_EXT)) != null) {
            this.m_stackFile.addStackAnalyzedInfo(info);
        }
        if ((info = this.saveStackAnalyzedInfo(this.m_logList, LOG_NAME, LOG_EXT)) != null) {
            this.m_stackFile.addStackAnalyzedInfo(info);
        }
        int i = 0;
        while (i < this.m_analyzerCount) {
            info = this.saveStackAnalyzedInfo(this.m_analyzerList[i], this.m_analyzer.get(i).getName(), this.m_analyzer.get(i).getExtension());
            if (info != null) {
                this.m_stackFile.addStackAnalyzedInfo(info);
            }
            ++i;
        }
        info = this.saveUniqueStackAnalyzedInfo(this.m_uniqueStackMap, UNIQUE_NAME, UNIQUE_EXT);
        if (info != null) {
            this.m_stackFile.addStackAnalyzedInfo(info);
        }
        if (this.m_timeList.size() > 0) {
            this.m_stackFile.setTimeList(this.m_timeList);
        }
        if (this.m_threadStatusList.size() > 0) {
            this.m_stackFile.setThreadStatusList(this.m_threadStatusList);
        }
        this.saveAnalyzedInfo();
    }

    public String getWorkingThreadFilename() {
        String filename = null;
        filename = this.m_filter != null ? this.getNewFilterFilename() : this.m_stackFile.getFilename();
        return StackParser.getWorkingThreadFilename(filename);
    }

    private StackAnalyzedInfo saveStackAnalyzedInfo(ArrayList<String> list, String analyzedName, String extension) {
        if (list == null || list.size() == 0) {
            return null;
        }
        BufferedWriter writer = null;
        StackAnalyzedInfo aynalyzedInfo = null;
        try {
            try {
                writer = new BufferedWriter(new FileWriter(StackParser.getAnaylzedFilename(this.m_stackFile.getFilename(), extension)));
                int i = 0;
                int size = list.size();
                HashMap<String, StackAnalyzedValue> searchMap = new HashMap<String, StackAnalyzedValue>(400);
                ArrayList<StackAnalyzedValue> sortList = new ArrayList<StackAnalyzedValue>(400);
                String key = null;
                StackAnalyzedValue value = null;
                i = 0;
                while (i < size) {
                    key = StringUtils.makeStackValue(list.get(i), true);
                    value = (StackAnalyzedValue)searchMap.get(key);
                    if (value == null) {
                        value = new StackAnalyzedValue(key, 1, 0, 0);
                        searchMap.put(key, value);
                        sortList.add(value);
                    } else {
                        value.addCount();
                    }
                    ++i;
                }
                searchMap = null;
                Collections.sort(sortList, new StackAnalyzedValueComp());
                aynalyzedInfo = new StackAnalyzedInfo(analyzedName, this.m_stackFile, extension);
                aynalyzedInfo.setTotalCount(size);
                aynalyzedInfo.setAnaylizedList(sortList);
                StringBuilder buffer = new StringBuilder(100);
                buffer.append(this.m_totalWorkingCount).append('\t').append(size).append('\t').append(10000 * size / this.m_totalWorkingCount).append('\n');
                writer.write(buffer.toString());
                i = 0;
                while (i < sortList.size()) {
                    value = sortList.get(i);
                    value.setExtPct(10000 * value.getCount() / this.m_totalWorkingCount);
                    value.setIntPct(10000 * value.getCount() / size);
                    buffer = new StringBuilder(100);
                    buffer.append(value.getCount()).append('\t').append(value.getExtPct()).append('\t').append(value.getIntPct()).append('\t').append(value.getValue()).append('\n');
                    writer.write(buffer.toString());
                    ++i;
                }
                writer.write("\n");
                i = 0;
                while (i < size) {
                    writer.write(list.get(i));
                    writer.write("\n");
                    ++i;
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
        return aynalyzedInfo;
    }

    private StackAnalyzedInfo saveUniqueStackAnalyzedInfo(HashMap<Integer, UniqueStackValue> map, String analyzedName, String extension) {
        if (map == null || map.size() == 0) {
            return null;
        }
        BufferedWriter writer = null;
        StackAnalyzedInfo aynalyzedInfo = null;
        try {
            try {
                writer = new BufferedWriter(new FileWriter(StackParser.getAnaylzedFilename(this.m_stackFile.getFilename(), extension)));
                int i = 0;
                ArrayList<StackAnalyzedValue> sortList = new ArrayList<StackAnalyzedValue>(400);
                UniqueStackValue value2 = null;
                int totalCount = 0;
                Iterator<UniqueStackValue> iter = map.values().iterator();
                while (iter.hasNext()) {
                    totalCount += iter.next().getCount();
                }
                for (UniqueStackValue value2 : map.values()) {
                    value2.setExtPct(10000 * value2.getCount() / this.m_totalWorkingCount);
                    value2.setIntPct(10000 * value2.getCount() / totalCount);
                    sortList.add(value2);
                }
                Collections.sort(sortList, new StackAnalyzedValueComp());
                aynalyzedInfo = new StackAnalyzedInfo(analyzedName, this.m_stackFile, extension);
                aynalyzedInfo.setTotalCount(totalCount);
                aynalyzedInfo.setAnaylizedList(sortList);
                StringBuilder buffer = new StringBuilder(100);
                buffer.append(this.m_totalWorkingCount).append('\t').append(totalCount).append('\t').append(10000 * totalCount / this.m_totalWorkingCount).append('\n');
                writer.write(buffer.toString());
                i = 0;
                while (i < sortList.size()) {
                    value2 = (UniqueStackValue)sortList.get(i);
                    buffer = new StringBuilder(100);
                    buffer.append(value2.getCount()).append('\t').append(value2.getExtPct()).append('\t').append(value2.getIntPct()).append('\t').append(value2.getValue()).append('\n');
                    writer.write(buffer.toString());
                    ++i;
                }
                writer.write("\n");
                i = 0;
                while (i < sortList.size()) {
                    writer.write("[[]]" + i + "\n");
                    value2 = (UniqueStackValue)sortList.get(i);
                    for (String stack : value2.getStack()) {
                        writer.write(stack);
                        writer.write("\n");
                    }
                    writer.write("\n");
                    ++i;
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
        return aynalyzedInfo;
    }

    protected void processStack(ArrayList<String> workingList, ThreadStatusInfo tsInfo) {
        PreProcessor.process(this.m_config, workingList);
        this.processStackBasic(workingList, tsInfo);
        if (this.m_analyzerCount > 0) {
            this.processStackAnalyzer(workingList);
        }
    }

    private void processStackAnalyzer(ArrayList<String> workingList) {
        AnalyzerValue analyzer = null;
        int i = 0;
        while (i < this.m_analyzerCount) {
            analyzer = this.m_analyzer.get(i);
            if (analyzer.getFilter() == 1) {
                this.processStackAnalyzerAll(analyzer, this.m_analyzerList[i], workingList);
            } else if (analyzer.getFilter() == 2) {
                this.processStackAnalyzerEach(analyzer, this.m_analyzerList[i], workingList);
            }
            ++i;
        }
    }

    private void processStackAnalyzerEach(AnalyzerValue analyzer, ArrayList<String> list, ArrayList<String> workingList) {
        int startStackLine;
        int workingSize = workingList.size();
        String line = null;
        ArrayList<String> searchList = analyzer.getList();
        int reader = analyzer.getReader();
        boolean isSearch = false;
        String searchLine = null;
        int i = startStackLine = this.m_config.getStackStartLine();
        while (i < workingSize) {
            block4: {
                block5: {
                    block6: {
                        line = workingList.get(i);
                        if (StringUtils.isLockStack(line)) break block4;
                        if (!StringUtils.checkExist(line, searchList)) break block5;
                        if (reader == 1) {
                            searchLine = line;
                            break;
                        }
                        if (reader != 2) break block6;
                        searchLine = line;
                        break block4;
                    }
                    if (reader != 3) break block4;
                    isSearch = true;
                    break block4;
                }
                if (isSearch) {
                    searchLine = line;
                    break;
                }
            }
            ++i;
        }
        if (searchLine != null) {
            list.add(searchLine);
        }
    }

    private void processStackAnalyzerAll(AnalyzerValue analyzer, ArrayList<String> list, ArrayList<String> workingList) {
        int stackStartLine;
        int workingSize = workingList.size();
        String line = null;
        ArrayList<String> searchList = analyzer.getList();
        ArrayList<String> searchListMain = analyzer.getListMain();
        int reader = analyzer.getReader();
        boolean isSearch = false;
        String searchLine = null;
        int i = stackStartLine = this.m_config.getStackStartLine();
        while (i < workingSize) {
            block3: {
                block4: {
                    block5: {
                        line = workingList.get(i);
                        if (StringUtils.isLockStack(line) || StringUtils.checkExist(line, searchList)) break block3;
                        if (!StringUtils.checkExist(line, searchListMain)) break block4;
                        if (reader == 1) {
                            searchLine = line;
                            break;
                        }
                        if (reader != 2) break block5;
                        searchLine = line;
                        break block3;
                    }
                    if (reader != 3) break block3;
                    isSearch = true;
                    break block3;
                }
                if (!isSearch) break;
                searchLine = line;
                break;
            }
            ++i;
        }
        if (searchLine != null) {
            list.add(searchLine);
        }
    }

    private void processStackBasic(ArrayList<String> workingList, ThreadStatusInfo tsInfo) {
        ++this.m_totalWorkingCount;
        boolean isSql = false;
        String line = null;
        String requestLine = null;
        String sqlLine = null;
        String logLine = null;
        boolean isServiceExclude = this.m_config.isServiceExclude();
        int stackStartLine = this.m_config.getStackStartLine();
        String threadStatus = this.m_config.getThreadStatus();
        int threadStatusLength = 0;
        if (threadStatus != null) {
            threadStatusLength = threadStatus.length();
        }
        try {
            ArrayList<String> simpleList;
            int hashCode;
            UniqueStackValue uniqueStack;
            int workingSize = workingList.size();
            int i = 0;
            while (i < workingSize) {
                line = workingList.get(i);
                this.m_workingThread_writer.write(line);
                this.m_workingThread_writer.write("\n");
                if (i < stackStartLine) {
                    int tIndex;
                    if (threadStatusLength > 0 && (tIndex = line.indexOf(threadStatus)) >= 0) {
                        tsInfo.checkStatusCount(this.m_threadStatusList, tIndex + threadStatusLength, line);
                    }
                } else {
                    if (i == stackStartLine) {
                        this.m_topList.add(line);
                    }
                    if (!StringUtils.isLockStack(line)) {
                        if (StringUtils.checkExist(line, this.m_sql)) {
                            isSql = true;
                        } else if (isSql) {
                            isSql = false;
                            sqlLine = line;
                        }
                        if (!isServiceExclude && StringUtils.checkExist(line, this.m_service)) {
                            requestLine = line;
                        }
                        if (StringUtils.checkExist(line, this.m_log)) {
                            logLine = line;
                        }
                    }
                }
                ++i;
            }
            this.m_workingThread_writer.write("\n");
            if (requestLine == null) {
                if (workingList.size() > stackStartLine && isServiceExclude) {
                    requestLine = this.getReqeustLineByAuto(workingList, stackStartLine);
                }
                if (requestLine == null) {
                    requestLine = workingList.get(stackStartLine);
                }
            }
            if (requestLine != null) {
                this.m_serviceList.add(requestLine);
            }
            if (logLine != null) {
                this.m_logList.add(logLine);
            }
            if (sqlLine != null) {
                this.m_sqlList.add(sqlLine);
            }
            if ((uniqueStack = this.m_uniqueStackMap.get(hashCode = StringUtils.hashCode(simpleList = StringUtils.makeStackToSimpe(workingList, stackStartLine, this.m_config.getSingleStack())))) == null) {
                uniqueStack = new UniqueStackValue(simpleList);
                this.m_uniqueStackMap.put(hashCode, uniqueStack);
            }
            uniqueStack.addCount();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private String getReqeustLineByAuto(ArrayList<String> workingList, int stackStartLine) {
        int size = workingList.size();
        int i = size - 1;
        while (i >= stackStartLine) {
            String line = workingList.get(i);
            if (!StringUtils.checkExist(line, this.m_service)) {
                return line;
            }
            --i;
        }
        return null;
    }

    protected void addTime(String time) {
        this.m_timeList.add(time);
    }

    protected void writeTime(String time) {
        try {
            this.m_workingThread_writer.write(time);
            this.m_workingThread_writer.write("\n\n");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected ArrayList<String> getThreadStatusList() {
        return this.m_threadStatusList;
    }

    protected void setTotalWorkerCount(int count) {
        this.m_totalWorkerCount = count;
    }

    protected void setDumpCount(int count) {
        this.m_dumpCount = count;
    }

    private void makeTotalSecond() {
        int size = this.m_timeList.size();
        if (size < 2) {
            this.m_totalSecond = 0;
            return;
        }
        SimpleDateFormat format = this.m_config.getSimpleDateFormat();
        if (format == null) {
            this.m_totalSecond = 0;
            return;
        }
        try {
            Date start = format.parse(this.m_timeList.get(0).substring(0, this.m_config.getTimeSize()));
            Date end = format.parse(this.m_timeList.get(this.m_timeList.size() - 1).substring(0, this.m_config.getTimeSize()));
            this.m_totalSecond = (int)((end.getTime() - start.getTime()) / 1000L);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.m_totalSecond = 0;
        }
    }

    private void saveAnalyzedInfo() {
        BufferedWriter writer = null;
        try {
            try {
                int i;
                writer = new BufferedWriter(new FileWriter(StackParser.getAnaylzedInfoFilename(this.m_stackFile.getFilename())));
                writer.write(this.m_config.getConfigFilename());
                writer.write(10);
                writer.write("" + this.m_dumpCount);
                writer.write(9);
                writer.write("" + this.m_totalWorkerCount);
                writer.write(9);
                writer.write("" + this.m_totalWorkingCount);
                writer.write(9);
                writer.write("" + this.m_totalSecond);
                if (this.m_threadStatusList.size() > 0) {
                    i = 0;
                    while (i < this.m_threadStatusList.size()) {
                        writer.write(9);
                        writer.write(this.m_threadStatusList.get(i));
                        ++i;
                    }
                }
                writer.write(10);
                int size = this.m_timeList.size();
                i = 0;
                while (i < size) {
                    writer.write(this.m_timeList.get(i));
                    writer.write(10);
                    ++i;
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected void progressBar() {
        ++this.m_totalLineCount;
        if (this.m_totalLineCount % 3000 == 0) {
            ++this.m_processPercent;
            if (this.m_processPercent == 100) {
                this.m_processPercent = 0;
            }
            this.m_progressBarWindow.setValue(this.m_processPercent);
        }
    }

    protected boolean isWorkingThread(String line) {
        if (this.m_mainProcessor.isAnalyzeAllThreads()) {
            return true;
        }
        return StringUtils.checkExist(line, this.m_workingThread);
    }

    public static StackFileInfo loadAnalyzedInfo(String filename) {
        String endString = new StringBuilder(20).append(INFO_EXT).append('.').append(INFO_EXTENSION).toString();
        if (!filename.endsWith(endString)) {
            throw new RuntimeException(String.valueOf(filename) + " is not a Scouter analyzed info file!");
        }
        String stackFilename = filename.substring(0, filename.indexOf(endString) - 1);
        StackFileInfo stackFileInfo = new StackFileInfo(stackFilename);
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new FileReader(new File(filename)));
                String line = null;
                int lineCount = 0;
                ArrayList<String> timeList = new ArrayList<String>();
                ArrayList<String> threadStatusList = new ArrayList<String>();
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).length() == 0) continue;
                    if (lineCount == 0) {
                        ParserConfigReader ConfigReader = new ParserConfigReader(line);
                        ParserConfig config = ConfigReader.read();
                        stackFileInfo.setParserConfig(config);
                        StackParser parser = StackParser.getParser(config, null, true);
                        stackFileInfo.setUsedParser(parser);
                    } else if (lineCount == 1) {
                        StringTokenizer token = new StringTokenizer(line, "\t");
                        String value = null;
                        int index = 0;
                        while (token.hasMoreElements()) {
                            value = token.nextToken();
                            if (index == 0) {
                                stackFileInfo.setDumpCount(Integer.parseInt(value));
                            } else if (index == 1) {
                                stackFileInfo.setTotalWorkerCount(Integer.parseInt(value));
                            } else if (index == 2) {
                                stackFileInfo.setTotalWorkingCount(Integer.parseInt(value));
                            } else if (index == 3) {
                                stackFileInfo.setTotalSecond(Integer.parseInt(value));
                            } else {
                                threadStatusList.add(value);
                            }
                            ++index;
                        }
                    } else {
                        timeList.add(line);
                    }
                    ++lineCount;
                }
                if (timeList.size() > 0) {
                    stackFileInfo.setTimeList(timeList);
                }
                if (threadStatusList.size() > 0) {
                    stackFileInfo.setThreadStatusList(threadStatusList);
                }
                StackParser.loadStackAnalyzedInfo(stackFileInfo);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {}
        }
        return stackFileInfo;
    }

    private static void loadStackAnalyzedInfo(StackFileInfo stackFileInfo) {
        File file = null;
        StackAnalyzedInfo analyzedInfo = null;
        try {
            ArrayList<AnalyzerValue> list;
            analyzedInfo = StackParser.readStackAnalyzedInfo(stackFileInfo, file, TOP_NAME, TOP_EXT);
            if (analyzedInfo != null) {
                stackFileInfo.addStackAnalyzedInfo(analyzedInfo);
            }
            if ((analyzedInfo = StackParser.readStackAnalyzedInfo(stackFileInfo, file, SQL_NAME, SQL_EXT)) != null) {
                stackFileInfo.addStackAnalyzedInfo(analyzedInfo);
            }
            if ((analyzedInfo = StackParser.readStackAnalyzedInfo(stackFileInfo, file, SERVICE_NAME, SERVICE_EXT)) != null) {
                stackFileInfo.addStackAnalyzedInfo(analyzedInfo);
            }
            if ((analyzedInfo = StackParser.readStackAnalyzedInfo(stackFileInfo, file, LOG_NAME, LOG_EXT)) != null) {
                stackFileInfo.addStackAnalyzedInfo(analyzedInfo);
            }
            if ((list = stackFileInfo.getParserConfig().getAnalyzerList()) != null) {
                int i = 0;
                while (i < list.size()) {
                    analyzedInfo = StackParser.readStackAnalyzedInfo(stackFileInfo, file, list.get(i).getName(), list.get(i).getExtension());
                    if (analyzedInfo != null) {
                        stackFileInfo.addStackAnalyzedInfo(analyzedInfo);
                    }
                    ++i;
                }
            }
            analyzedInfo = StackParser.readStackAnalyzedInfo(stackFileInfo, file, UNIQUE_NAME, UNIQUE_EXT);
            StackParser.readUniqueStackExtraInfo(analyzedInfo, stackFileInfo, file, UNIQUE_NAME, UNIQUE_EXT);
            if (analyzedInfo != null) {
                stackFileInfo.addStackAnalyzedInfo(analyzedInfo);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static StackAnalyzedInfo readStackAnalyzedInfo(StackFileInfo stackFileInfo, File file, String name, String extension) {
        String filename = stackFileInfo.getFilename();
        String analyzedFilename = StackParser.getAnaylzedFilename(filename, extension);
        file = new File(analyzedFilename);
        if (!file.isFile()) {
            return null;
        }
        BufferedReader reader = null;
        StackAnalyzedInfo analyzedInfo = new StackAnalyzedInfo(name, stackFileInfo, extension);
        ArrayList<StackAnalyzedValue> list = new ArrayList<StackAnalyzedValue>();
        try {
            try {
                reader = new BufferedReader(new FileReader(file));
                String line = null;
                int lineCount = 0;
                StringTokenizer token = null;
                boolean isUniqueStack = name.equals(UNIQUE_NAME);
                while ((line = reader.readLine()) != null) {
                    String value;
                    int index;
                    if ((line = line.trim()).length() == 0) continue;
                    if (lineCount == 0) {
                        token = new StringTokenizer(line, "\t");
                        index = 0;
                        while (token.hasMoreElements()) {
                            value = token.nextToken();
                            if (index != 0 && index == 1) {
                                analyzedInfo.setTotalCount(Integer.parseInt(value));
                            }
                            ++index;
                        }
                    } else {
                        char ch = line.charAt(0);
                        if (ch < '0' || ch > '9') break;
                        int count = 0;
                        int extPct = 0;
                        int intPct = 0;
                        String keyValue = null;
                        token = new StringTokenizer(line, "\t");
                        index = 0;
                        while (token.hasMoreElements()) {
                            value = token.nextToken();
                            if (index == 0) {
                                count = Integer.parseInt(value);
                            } else if (index == 1) {
                                extPct = Integer.parseInt(value);
                            } else if (index == 2) {
                                intPct = Integer.parseInt(value);
                            } else if (index == 3) {
                                keyValue = value;
                            }
                            ++index;
                        }
                        if (index == 4) {
                            StackAnalyzedValue analyzedValue = isUniqueStack ? new UniqueStackValue(keyValue, count, intPct, extPct) : new StackAnalyzedValue(keyValue, count, intPct, extPct);
                            list.add(analyzedValue);
                        }
                    }
                    ++lineCount;
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {}
        }
        analyzedInfo.setAnaylizedList(list);
        return analyzedInfo;
    }

    private static StackAnalyzedInfo readUniqueStackExtraInfo(StackAnalyzedInfo analyzedInfo, StackFileInfo stackFileInfo, File file, String name, String extension) {
        String filename = stackFileInfo.getFilename();
        String analyzedFilename = StackParser.getAnaylzedFilename(filename, extension);
        file = new File(analyzedFilename);
        if (!file.isFile()) {
            return null;
        }
        BufferedReader reader = null;
        ArrayList<StackAnalyzedValue> list = analyzedInfo.getAnalyzedList();
        try {
            try {
                String line;
                reader = new BufferedReader(new FileReader(file));
                int indexNum = 0;
                boolean isStack = false;
                ArrayList<String> stackList = null;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).length() == 0) continue;
                    if (!isStack && line.startsWith("[[]]")) {
                        isStack = true;
                    }
                    if (!isStack) continue;
                    if (line.startsWith("[[]]")) {
                        if (stackList != null && stackList.size() > 0) {
                            ((UniqueStackValue)list.get(indexNum)).setStack(stackList);
                        }
                        indexNum = Integer.parseInt(line.substring(4));
                        stackList = new ArrayList<String>();
                        continue;
                    }
                    stackList.add(line);
                }
                if (stackList != null && stackList.size() > 0) {
                    ((UniqueStackValue)list.get(indexNum)).setStack(stackList);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {}
        }
        return analyzedInfo;
    }

    public static StackParser getParser(ParserConfig config, String filter, boolean isInclude) {
        StackParser parser = null;
        if (filter != null) {
            parser = isInclude ? new FilterStackParser() : new FilterExcludeStackParser();
            parser.setFilter(filter);
        } else {
            String parserName = config.getParserName();
            if (parserName == null) {
                parser = new BasicFileStackParser();
            } else {
                if (parserName.indexOf(44) < 0) {
                    parserName = "scouter.client.stack.data." + parserName;
                }
                try {
                    Class<?> cl = Class.forName(parserName);
                    parser = (StackParser)cl.newInstance();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        parser.setConfig(config);
        return parser;
    }

    public static String getAnaylzedFilename(String filename, String extension) {
        return new StringBuffer(200).append(filename).append('_').append(extension).append('.').append(EXTENSION).toString();
    }

    public static String getWorkingThreadFilename(String filename) {
        return StackParser.getAnaylzedFilename(filename, WORKINGTHREAD_EXT);
    }

    public static String getAnaylzedInfoFilename(String filename) {
        return new StringBuilder(200).append(filename).append('_').append(INFO_EXT).append('.').append(INFO_EXTENSION).toString();
    }

    public static void removeAllAnalyzedFile(StackFileInfo stackFileInfo) {
        ArrayList<AnalyzerValue> list;
        ParserConfig config;
        String filename = stackFileInfo.getFilename();
        if (filename != null) {
            ResourceUtils.removeFile(StackParser.getAnaylzedInfoFilename(filename));
            ResourceUtils.removeFile(StackParser.getAnaylzedFilename(filename, WORKINGTHREAD_EXT));
            ResourceUtils.removeFile(StackParser.getAnaylzedFilename(filename, SERVICE_EXT));
            ResourceUtils.removeFile(StackParser.getAnaylzedFilename(filename, SQL_EXT));
            ResourceUtils.removeFile(StackParser.getAnaylzedFilename(filename, TOP_EXT));
            ResourceUtils.removeFile(StackParser.getAnaylzedFilename(filename, LOG_EXT));
            ResourceUtils.removeFile(StackParser.getAnaylzedFilename(filename, UNIQUE_EXT));
        }
        if ((config = stackFileInfo.getParserConfig()) != null && (list = config.getAnalyzerList()) != null) {
            int i = 0;
            while (i < list.size()) {
                ResourceUtils.removeFile(StackParser.getAnaylzedFilename(filename, list.get(i).getExtension()));
                ++i;
            }
        }
    }
}

