/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.stack.dialog;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.stack.actions.FetchSingleStackJob;
import scouter.client.stack.actions.FetchStackJob;
import scouter.client.util.ExUtil;
import scouter.io.DataInputX;
import scouter.lang.pack.MapPack;
import scouter.util.DateUtil;

public class StackListDialog
extends Dialog {
    int serverId;
    String objName;
    String date;
    Table table;
    Text rangeText;

    public StackListDialog(int serverId, String objName) {
        this(serverId, objName, DateUtil.yyyymmdd());
    }

    public StackListDialog(int serverId, String objName, String date) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.serverId = serverId;
        this.objName = objName;
        this.date = date;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Label label1 = new Label(container, 0);
        label1.setLayoutData((Object)new GridData(4, 4, true, false));
        label1.setAlignment(131072);
        label1.setFont(new Font(null, "Airal", 10, 1));
        label1.setText("Select range to analyze (using shift key) and click \"OK\".");
        Label label2 = new Label(container, 0);
        label2.setLayoutData((Object)new GridData(4, 4, true, false));
        label2.setAlignment(131072);
        label2.setFont(new Font(null, "Airal", 10, 0));
        label2.setText("Double click to view a single thread dump as raw text.");
        Composite tableComposite = new Composite(container, 0);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table = new Table(tableComposite, 68098);
        this.table.setLinesVisible(true);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = StackListDialog.this.table.getSelection();
                if (items != null && items.length > 0) {
                    TableItem first = items[0];
                    TableItem last = items[items.length - 1];
                    StackListDialog.this.rangeText.setText(String.valueOf(first.getText(1)) + " ~ " + last.getText(1));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.table.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                TableItem[] items = StackListDialog.this.table.getSelection();
                if (items == null) {
                    return;
                }
                long from = (Long)items[0].getData();
                new FetchSingleStackJob(StackListDialog.this.serverId, StackListDialog.this.objName, from, StackListDialog.this.getTableList(), null).schedule(500L);
                StackListDialog.this.cancelProessed();
            }

            public void mouseDown(MouseEvent arg0) {
            }

            public void mouseUp(MouseEvent arg0) {
            }
        });
        TableColumn indexColumn = new TableColumn(this.table, 0);
        TableColumn timeColumn = new TableColumn(this.table, 0);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableColumnLayout.setColumnData((Widget)indexColumn, (ColumnLayoutData)new ColumnWeightData(20));
        tableColumnLayout.setColumnData((Widget)timeColumn, (ColumnLayoutData)new ColumnWeightData(80));
        tableComposite.setLayout((Layout)tableColumnLayout);
        this.rangeText = new Text(container, 16779276);
        this.rangeText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.load();
        return container;
    }

    private void load() {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                ArrayList timeList;
                block5: {
                    TcpProxy tcp = TcpProxy.getTcpProxy(StackListDialog.this.serverId);
                    timeList = new ArrayList();
                    try {
                        try {
                            MapPack param = new MapPack();
                            param.put("objName", StackListDialog.this.objName);
                            long from = DateUtil.yyyymmdd((String)StackListDialog.this.date);
                            param.put("from", from);
                            param.put("to", from + 86400000L - 1L);
                            tcp.process("GET_STACK_INDEX", param, new INetReader(){

                                @Override
                                public void process(DataInputX in) throws IOException {
                                    long time = in.readLong();
                                    timeList.add(new Long(time));
                                }
                            });
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TcpProxy.putTcpProxy(tcp);
                            break block5;
                        }
                    }
                    catch (Throwable throwable) {
                        TcpProxy.putTcpProxy(tcp);
                        throw throwable;
                    }
                    TcpProxy.putTcpProxy(tcp);
                }
                Collections.sort(timeList);
                ExUtil.exec((Composite)StackListDialog.this.table, new Runnable(){

                    @Override
                    public void run() {
                        int i = 0;
                        while (i < timeList.size()) {
                            TableItem item = new TableItem((this).StackListDialog.this.table, 0);
                            item.setText(0, String.valueOf(i + 1));
                            long time = (Long)timeList.get(i);
                            item.setText(1, DateUtil.format((long)time, (String)"yyyy-MM-dd HH:mm:ss"));
                            item.setData((Object)time);
                            ++i;
                        }
                    }
                });
            }
        });
    }

    protected Point getInitialSize() {
        return new Point(500, 500);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.objName);
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        TableItem[] items = this.table.getSelection();
        if (items != null && items.length > 0) {
            TableItem first = items[0];
            TableItem last = items[items.length - 1];
            long from = (Long)first.getData();
            long to = (Long)last.getData() + 1L;
            new FetchStackJob(this.serverId, this.objName, from, to, items.length).schedule(500L);
        }
        super.okPressed();
    }

    protected void cancelProessed() {
        super.cancelPressed();
    }

    private List<Long> getTableList() {
        TableItem[] items = this.table.getItems();
        if (items == null) {
            return null;
        }
        ArrayList<Long> list = new ArrayList<Long>();
        TableItem[] tableItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            list.add((Long)item.getData());
            ++n2;
        }
        return list;
    }
}

