/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.stack.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import scouter.client.stack.base.MainProcessor;
import scouter.client.stack.base.PreferenceManager;
import scouter.client.stack.data.StackFileInfo;
import scouter.client.stack.utils.NumberUtils;
import scouter.client.stack.utils.StringUtils;
import scouter.client.stack.utils.ValueObject;
import scouter.client.stack.utils.ValueObjectComp;

public class HtmlUtils {
    public static final int HTML_MAX_LINES = 20000;

    public static String getAsTable(String prefix, String[] elements) {
        int from;
        StringBuffer result = new StringBuffer();
        int i = from = 0;
        while (i < elements.length) {
            if (elements[i].trim().length() > 0) {
                String elem = elements[i].replaceAll("\\\\", "/");
                result.append("<tr><td width=\"20px\"></td><td><a href=\"");
                result.append(prefix);
                result.append(elem);
                result.append("\">");
                result.append(HtmlUtils.cutLink(elem, 80));
                result.append("</a></td></tr>\n");
            }
            ++i;
        }
        return result.toString();
    }

    public static String cutLink(String link, int len) {
        if (link.length() > len) {
            String cut = String.valueOf(link.substring(0, len / 2)) + "..." + link.substring(link.length() - len / 2);
            return cut;
        }
        return link;
    }

    public static String getMainBodyStart() {
        return "<TABLE width='1500'><TR><TD width='50'></TD><TD>";
    }

    public static String getMainBodyEnd() {
        return "</TD></TR></TABLE>";
    }

    public static String getStackFileInfo(StackFileInfo stackFileInfo) {
        StringBuffer buffer;
        block26: {
            int size;
            ArrayList<String> list;
            block23: {
                buffer = new StringBuffer(1024000);
                buffer.append(HtmlUtils.getMainBodyStart());
                buffer.append(HtmlUtils.getCurrentConfigurationBody()).append("<br><br>");
                buffer.append("<b>[ ").append(stackFileInfo.getFilename()).append(" ]</b><BR>");
                buffer.append("Parser configuration filename : ").append(stackFileInfo.getParserConfig().getConfigFilename()).append("<br>");
                buffer.append("Dump count : ").append(NumberUtils.intToString(stackFileInfo.getDumpCount())).append("<BR>");
                buffer.append("Worker count : ").append(NumberUtils.intToString(stackFileInfo.getTotalWorkerCount())).append("<BR>");
                buffer.append("Working count : ").append(NumberUtils.intToString(stackFileInfo.getTotalWorkingCount())).append("<BR>");
                list = stackFileInfo.getTimeList();
                if (list == null || list.size() == 0) {
                    return buffer.toString();
                }
                size = list.size();
                if (stackFileInfo.getTotalSecond() > 0) {
                    buffer.append("Monitoring seconds : ").append(NumberUtils.secsToTime(stackFileInfo.getTotalSecond())).append(" -> ");
                    buffer.append(NumberUtils.intToString(stackFileInfo.getTotalSecond())).append(" secs ");
                }
                if (list != null && size > 1) {
                    buffer.append('(').append(list.get(0).substring(0, stackFileInfo.getParserConfig().getTimeSize())).append(" - ").append(list.get(size - 1).substring(0, stackFileInfo.getParserConfig().getTimeSize())).append(')');
                }
                boolean isSimpleDumpList = MainProcessor.instance().isSimpleDumpTimeList();
                buffer.append("<BR><BR>");
                if (isSimpleDumpList) {
                    buffer.append("<b>[ Simple dump time list ]</b><BR>");
                } else {
                    buffer.append("<b>[ Dump time list ]</b><BR>");
                }
                buffer.append("<TABLE border='1'>");
                buffer.append("<TR><TH align='center'>Time</TH><TH align='center'>Worker</TH><TH align='center'>Working</TH>");
                ArrayList<String> statusList = stackFileInfo.getThreadStatusList();
                int statusCnt = 0;
                if (statusList != null) {
                    statusCnt = statusList.size();
                    int i = 0;
                    while (i < statusCnt) {
                        buffer.append("<TH align='center'>").append(statusList.get(i)).append("</TH>");
                        ++i;
                    }
                }
                buffer.append("</TR>");
                if (!isSimpleDumpList) break block23;
                int workerCnt = 0;
                int workingCnt = 0;
                int[] threadStatusList = null;
                if (statusCnt > 0) {
                    threadStatusList = new int[statusCnt];
                    int i = 0;
                    while (i < statusCnt) {
                        threadStatusList[i] = 0;
                        ++i;
                    }
                }
                StringTokenizer token = null;
                int i = 0;
                while (i < size) {
                    token = new StringTokenizer(list.get(i), "\t");
                    int index = 0;
                    while (token.hasMoreElements()) {
                        block25: {
                            block24: {
                                int value;
                                if (index <= 0) break block24;
                                try {
                                    value = Integer.parseInt((String)token.nextElement());
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    value = 0;
                                }
                                switch (index) {
                                    case 1: {
                                        workerCnt += value;
                                        break;
                                    }
                                    case 2: {
                                        workingCnt += value;
                                        break;
                                    }
                                    default: {
                                        if (index > 2) {
                                            int n = index - 3;
                                            threadStatusList[n] = threadStatusList[n] + value;
                                            break;
                                        } else {
                                            break;
                                        }
                                    }
                                }
                                break block25;
                            }
                            token.nextElement();
                        }
                        ++index;
                    }
                    ++i;
                }
                buffer.append("<TR>");
                buffer.append("<TD  align='center'>").append(size).append(" Average (Sum)</TD>");
                buffer.append("<TD  align='right'>").append(workerCnt / size).append("  (").append(NumberUtils.intToString(workerCnt)).append(")</TD>");
                buffer.append("<TD  align='right'>").append(workingCnt / size).append("  (").append(NumberUtils.intToString(workingCnt)).append(")</TD>");
                i = 0;
                while (i < statusCnt) {
                    buffer.append("<TD  align='right'>").append(threadStatusList[i] / size).append("  (").append(NumberUtils.intToString(threadStatusList[i])).append(")</TD>");
                    ++i;
                }
                buffer.append("</TR>");
                break block26;
            }
            StringTokenizer token = null;
            int i = 0;
            while (i < size) {
                token = new StringTokenizer(list.get(i), "\t");
                buffer.append("<TR>");
                int index = 0;
                while (token.hasMoreElements()) {
                    if (index == 0) {
                        buffer.append("<TD  align='center'>");
                    } else {
                        buffer.append("<TD  align='right'>");
                    }
                    buffer.append(token.nextElement());
                    buffer.append("</TD>");
                    ++index;
                }
                buffer.append("</TR>");
                ++i;
            }
        }
        buffer.append("</TABLE>");
        buffer.append(HtmlUtils.getMainBodyEnd());
        return buffer.toString();
    }

    public static String getDefaultBody() {
        StringBuilder buffer = new StringBuilder(102400);
        buffer.append(HtmlUtils.getMainBodyStart());
        buffer.append(HtmlUtils.getCurrentConfigurationBody());
        buffer.append(HtmlUtils.getMainBodyEnd());
        return buffer.toString();
    }

    public static String getCurrentConfigurationBody() {
        String fileName = PreferenceManager.get().getCurrentParserConfig();
        StringBuilder buffer = new StringBuilder(100);
        buffer.append("Current parser configuration filename : ");
        if (fileName != null) {
            buffer.append(fileName);
        }
        return buffer.toString();
    }

    public static String filterThreadStack(String filename, String filter, ArrayList<String> excludeStackList, int stackStartLine) {
        if (filename == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(1024000);
        buffer.append(HtmlUtils.getMainBodyStart());
        buffer.append("<b>[ View thread stack ]</b><BR>");
        buffer.append("Filter : ").append(filter).append("<BR>");
        buffer.append("<pre><font size=3>");
        BufferedReader reader = null;
        int totalLineCount = 0;
        try {
            try {
                File file = new File(filename);
                reader = new BufferedReader(new FileReader(file));
                String line = null;
                boolean isFiltered = false;
                ArrayList<String> list = new ArrayList<String>(300);
                while ((line = reader.readLine()) != null) {
                    if (line.length() == 0) {
                        if (isFiltered && list.size() > stackStartLine) {
                            totalLineCount += HtmlUtils.printStack(list, buffer, excludeStackList);
                        }
                        list = new ArrayList(300);
                        isFiltered = false;
                        if (totalLineCount < 20000) continue;
                        break;
                    }
                    if (!isFiltered) {
                        if (filter == null) {
                            isFiltered = true;
                        } else if (line.indexOf(filter) >= 0) {
                            isFiltered = true;
                        }
                    }
                    list.add(line);
                }
                if (isFiltered && list.size() > stackStartLine) {
                    totalLineCount += HtmlUtils.printStack(list, buffer, excludeStackList);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        buffer.append("</font></pre>");
        buffer.append("Total : ").append(NumberUtils.intToString(totalLineCount)).append(" lines <BR>");
        buffer.append(HtmlUtils.getMainBodyEnd());
        return buffer.toString();
    }

    private static int printStack(ArrayList<String> list, StringBuilder buffer, ArrayList<String> excludeStackList) {
        int size = list.size();
        if (excludeStackList == null) {
            int i = 0;
            while (i < size) {
                buffer.append(list.get(i)).append('\n');
                ++i;
            }
            buffer.append('\n');
            return size + 1;
        }
        int lines = 0;
        int i = 0;
        while (i < size) {
            String line = list.get(i);
            if (!StringUtils.checkExist(line, excludeStackList)) {
                buffer.append(line).append('\n');
                ++lines;
            }
            ++i;
        }
        buffer.append('\n');
        return lines + 1;
    }

    public static String filterServiceCall(String filename, String filter, ArrayList<String> serviceList, int stackStartLine) {
        if (filename == null) {
            return "";
        }
        BufferedReader reader = null;
        String serviceCall = null;
        int totalServiceCount = 0;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        try {
            try {
                File file = new File(filename);
                reader = new BufferedReader(new FileReader(file));
                String line = null;
                boolean isFiltered = false;
                int lineCount = 0;
                while ((line = reader.readLine()) != null) {
                    if (line.length() == 0) {
                        if (isFiltered && lineCount > stackStartLine) {
                            ++totalServiceCount;
                            HtmlUtils.caculCounter(serviceCall, map);
                        }
                        isFiltered = false;
                        serviceCall = null;
                        lineCount = 0;
                        continue;
                    }
                    if (!isFiltered) {
                        if (filter == null) {
                            isFiltered = true;
                        } else if (line.indexOf(filter) >= 0) {
                            isFiltered = true;
                        }
                    }
                    if (lineCount == stackStartLine || StringUtils.checkExist(line, serviceList)) {
                        serviceCall = line;
                    }
                    ++lineCount;
                }
                if (isFiltered && lineCount > stackStartLine) {
                    ++totalServiceCount;
                    HtmlUtils.caculCounter(serviceCall, map);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        StringBuilder buffer = new StringBuilder(10240);
        buffer.append(HtmlUtils.getMainBodyStart());
        buffer.append("<b>[ View service call ]</b><BR>");
        buffer.append("Filter : ").append(filter).append("<BR>");
        buffer.append("Total count : ").append(NumberUtils.intToString(totalServiceCount)).append("<BR><BR>");
        if (totalServiceCount == 0) {
            buffer.append(HtmlUtils.getMainBodyEnd());
            return buffer.toString();
        }
        buffer.append("<TABLE border='1'>");
        buffer.append("<TR><TH align='center'>Count</TH><TH align='center'>Percent</TH><TH align='center'>Service name</TH></TR>");
        ArrayList<ValueObject> list = HtmlUtils.sortCounter(map);
        ValueObject object = null;
        int value = 0;
        int i = 0;
        while (i < list.size()) {
            object = list.get(i);
            value = object.getValue();
            buffer.append("<TR>");
            buffer.append("<TD align='right'>").append(NumberUtils.intToString(value)).append("</TD>");
            buffer.append("<TD align='right'>").append(NumberUtils.intToPercent(10000 * value / totalServiceCount)).append("%</TD>");
            buffer.append("<TD align='left'>").append(object.getKey()).append("</TD>");
            buffer.append("</TR>");
            ++i;
        }
        buffer.append("</TABLE>");
        buffer.append(HtmlUtils.getMainBodyEnd());
        return buffer.toString();
    }

    public static void caculCounter(String name, HashMap<String, Integer> map) {
        String key = StringUtils.makeSimpleLine(name, false);
        Integer value = map.get(key);
        value = value == null ? new Integer(1) : new Integer(value + 1);
        map.put(key, value);
    }

    public static ArrayList<ValueObject> sortCounter(HashMap<String, Integer> map) {
        String key = null;
        Integer value = null;
        Iterator<String> itor = map.keySet().iterator();
        ArrayList<ValueObject> list = new ArrayList<ValueObject>();
        ValueObject object = null;
        while (itor.hasNext()) {
            key = itor.next();
            value = map.get(key);
            object = new ValueObject(key, value);
            list.add(object);
        }
        Collections.sort(list, new ValueObjectComp());
        return list;
    }

    public static String getUniqueStack(ArrayList<String> list) {
        if (list == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(1024000);
        buffer.append(HtmlUtils.getMainBodyStart());
        buffer.append("<b>[ Unique Stack ]</b><BR>");
        buffer.append("<pre><font size=3>");
        for (String stack : list) {
            buffer.append(stack).append("\n");
        }
        buffer.append("</font></pre>");
        buffer.append(HtmlUtils.getMainBodyEnd());
        return buffer.toString();
    }
}

