/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.stack.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import scouter.client.stack.base.PreferenceManager;
import scouter.client.util.RCPUtil;

public class ResourceUtils {
    public static InputStream getDefaultXMLConfig() {
        return ResourceUtils.class.getClassLoader().getResourceAsStream("/scouter/client/stack/doc/config_default.xml");
    }

    public static String openFileSaveDialog(String[] names, String[] extensions, String path, String defaultName) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setOverwrite(true);
        dialog.setFilterNames(names);
        dialog.setFilterExtensions(extensions);
        dialog.setFilterPath(path);
        if (defaultName != null) {
            dialog.setFileName(defaultName);
        }
        return dialog.open();
    }

    public static void saveFile(String fileName, String contents) {
        block13: {
            if (contents == null) {
                return;
            }
            contents = contents.trim();
            FileOutputStream out = null;
            try {
                try {
                    out = new FileOutputStream(new File(fileName), false);
                    out.write(contents.getBytes());
                    out.flush();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (out == null) break block13;
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public static String selectFileDialog(Composite parent, String title, String[] names, String[] extensions) {
        PreferenceManager prefManager = PreferenceManager.get();
        FileDialog dialog = new FileDialog(parent.getShell(), 4096);
        dialog.setText(title);
        dialog.setFilterNames(names);
        dialog.setFilterExtensions(extensions);
        dialog.setFilterPath(prefManager.getPreference(title, RCPUtil.getWorkingDirectory().getAbsolutePath()));
        String fileName = dialog.open();
        if (fileName != null) {
            File file = new File(fileName);
            prefManager.setPreference(title, file.getParentFile().getPath());
        }
        return fileName;
    }

    /*
     * Loose catch block
     */
    public static boolean isZipFile(String fileName) {
        FileInputStream in;
        block17: {
            block18: {
                if (fileName == null) {
                    return false;
                }
                File file = new File(fileName);
                if (!file.exists() || !file.isFile()) {
                    return false;
                }
                in = null;
                in = new FileInputStream(file);
                byte[] data = new byte[2];
                ((InputStream)in).read(data);
                if (data[0] != 80 || data[1] != 75) break block17;
                if (in == null) break block18;
                try {
                    ((InputStream)in).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
            catch (Exception ex) {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return false;
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }
        if (in != null) {
            try {
                ((InputStream)in).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static void setVisiable(ViewPart viewPart, String ID, boolean enable) {
        IContributionItem[] items;
        IToolBarManager manager = viewPart.getViewSite().getActionBars().getToolBarManager();
        IContributionItem[] iContributionItemArray = items = manager.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            if (item.getId() != null && item.getId().equals(ID)) {
                item.setVisible(enable);
            }
            ++n2;
        }
        manager.update(true);
    }

    public static void removeFile(String filename) {
        File file = null;
        file = new File(filename);
        if (file.exists() && file.isFile() && !file.delete()) {
            System.out.println("fail to delete - " + filename);
        }
    }

    public static void confirmMessage(Shell shell, String message) {
        MessageBox messageBox = new MessageBox(shell, 65602);
        messageBox.setText("Confirm");
        messageBox.setMessage(message);
        messageBox.open();
    }
}

