/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.stack.utils;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;

public class StringUtils {
    private static final String STARTSTACK = "at ";

    public static boolean checkExist(String line, ArrayList<String> list) {
        if (line == null || list == null) {
            return false;
        }
        int size = list.size();
        int i = 0;
        while (i < size) {
            if (line.indexOf(list.get(i)) >= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isLockStack(String line) {
        return line.indexOf(" waiting ") >= 0 || line.indexOf(" locked ") >= 0 || line.indexOf(" parking ") >= 0;
    }

    public static String makeSimpleLine(String input, boolean isRemoveLine) {
        int index = input.indexOf(STARTSTACK);
        if (index >= 0) {
            if (isRemoveLine) {
                int end = input.indexOf(40);
                if (index + 2 < end) {
                    return input.substring(index + 2, end);
                }
                return input.substring(index + 2);
            }
            return input.substring(index + 2);
        }
        return input;
    }

    public static ArrayList<String> makeStackToSimpe(ArrayList<String> list, int stackStartLine, ArrayList<String> singleList) {
        ArrayList<String> simpleList = new ArrayList<String>();
        if (list == null || list.size() < stackStartLine) {
            return simpleList;
        }
        if (singleList == null || singleList.size() == 0) {
            return list;
        }
        int size = list.size();
        int singleSize = singleList.size();
        int startInx = 0;
        int i = stackStartLine;
        while (i < size) {
            String line = list.get(i);
            int ii = 0;
            while (ii < singleSize) {
                if (line.indexOf(singleList.get(ii)) >= 0) {
                    startInx = line.indexOf(STARTSTACK);
                    line = startInx >= 0 ? new StringBuilder(50).append(line.subSequence(0, startInx + 5)).append(singleList.get(ii)).append("(modified stack)").toString() : ((startInx = line.indexOf(45)) >= 0 ? new StringBuilder(50).append(line.subSequence(0, startInx)).append(singleList.get(ii)).append("(modified stack)").toString() : new StringBuilder(50).append(singleList.get(ii)).append("(modified stack)").toString());
                }
                ++ii;
            }
            simpleList.add(line);
            ++i;
        }
        return simpleList;
    }

    public static String getFilename(String fullPath) {
        if (fullPath == null) {
            return null;
        }
        int index = fullPath.length() - 1;
        while (index >= 0) {
            char ch = fullPath.charAt(index);
            if (ch == '\\' || ch == '/') break;
            --index;
        }
        if (index < 0) {
            return fullPath;
        }
        return fullPath.substring(index + 1);
    }

    public static String getDiretory(String fullPath) {
        if (fullPath == null) {
            return null;
        }
        int index = fullPath.length() - 1;
        while (index >= 0) {
            char ch = fullPath.charAt(index);
            if (ch == '\\' || ch == '/') break;
            --index;
        }
        if (index < 0) {
            return null;
        }
        return fullPath.substring(0, index);
    }

    public static void setClipboard(String contents) {
        StringSelection ss = new StringSelection(contents);
        Clipboard clboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clboard.setContents(ss, null);
    }

    public static int hashCode(ArrayList<String> list) {
        int hashCode = 0;
        int i = 0;
        while (i < list.size()) {
            hashCode += list.get(i).hashCode();
            ++i;
        }
        return hashCode;
    }

    public static String makeStackValue(String value, boolean isRemoveLine) {
        int sIndex = StringUtils.getStartIindex(value);
        if (sIndex < 0) {
            throw new RuntimeException(String.valueOf(value) + " is not stack!");
        }
        int eIndex = 0;
        if (isRemoveLine) {
            eIndex = value.indexOf(40);
        }
        if (eIndex > 0) {
            return value.substring(sIndex, eIndex);
        }
        return value.substring(sIndex);
    }

    static int getStartIindex(String line) {
        int sIndex = line.indexOf(STARTSTACK);
        if (sIndex >= 0) {
            return sIndex + 3;
        }
        int length = line.length();
        int i = 0;
        while (i < length) {
            char ch = line.charAt(i);
            if (ch != ' ' && ch != '\t') {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

