/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.stack.views;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.stack.actions.MainProcessorAction;
import scouter.client.stack.actions.OpenXMLEditorAction;
import scouter.client.stack.base.MainProcessor;
import scouter.client.stack.base.PopupMenuListener;
import scouter.client.stack.data.StackAnalyzedInfo;
import scouter.client.stack.data.StackFileInfo;
import scouter.client.stack.utils.HtmlUtils;
import scouter.client.util.ImageUtil;

public class StackAnalyzerView
extends ViewPart {
    public static final String ID = StackAnalyzerView.class.getName();
    private Tree m_mainTree = null;
    private Table m_table = null;
    private Browser m_browser = null;

    public void createPartControl(Composite parent) {
        this.setPartName("SFA");
        MainProcessor mainProcessor = MainProcessor.instance();
        mainProcessor.setStackAnalyzerView(this);
        mainProcessor.setParentComposite(parent);
        this.initializeToobar();
        SashForm sashVertForm = new SashForm(parent, 512);
        sashVertForm.SASH_WIDTH = 3;
        SashForm sashHoriForm = new SashForm((Composite)sashVertForm, 256);
        sashHoriForm.SASH_WIDTH = 3;
        this.initializeTree((Composite)sashHoriForm);
        this.initializeTable((Composite)sashHoriForm);
        this.initializeBrowser((Composite)sashVertForm);
        sashVertForm.setWeights(new int[]{55, 45});
        sashHoriForm.setWeights(new int[]{45, 55});
        this.createMainTreePopupMenu();
        this.createTablePopupMenu();
        parent.setVisible(true);
    }

    private void initializeTree(Composite parent) {
        this.m_mainTree = new Tree(parent, 67584);
        this.m_mainTree.setLinesVisible(true);
        TreeColumn treeColumn = new TreeColumn(this.m_mainTree, 16384);
        treeColumn.setAlignment(16384);
        treeColumn.setText("Division");
        treeColumn.setWidth(300);
        treeColumn = new TreeColumn(this.m_mainTree, 131072);
        treeColumn.setAlignment(131072);
        treeColumn.setText("Count");
        treeColumn.setWidth(120);
        treeColumn = new TreeColumn(this.m_mainTree, 16384);
        treeColumn.setAlignment(131072);
        treeColumn.setText("Percent %");
        treeColumn.setWidth(100);
        this.m_mainTree.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                TreeItem item = (TreeItem)event.item;
                if (item == null) {
                    return;
                }
                Object object = item.getData();
                MainProcessor mainProcessor = MainProcessor.instance();
                if (object instanceof StackAnalyzedInfo) {
                    mainProcessor.setTable((StackAnalyzedInfo)object);
                } else if (object instanceof StackFileInfo) {
                    mainProcessor.displayContent(HtmlUtils.getStackFileInfo((StackFileInfo)object));
                }
            }
        });
        this.m_mainTree.setHeaderVisible(true);
        this.m_mainTree.setLinesVisible(true);
    }

    private void initializeTable(Composite parent) {
        this.m_table = new Table(parent, 67584);
        TableColumn tableColumn = new TableColumn(this.m_table, 131072);
        tableColumn.setText("Count");
        tableColumn.setWidth(80);
        tableColumn = new TableColumn(this.m_table, 131072);
        tableColumn.setText("Internl %");
        tableColumn.setWidth(100);
        tableColumn = new TableColumn(this.m_table, 131072);
        tableColumn.setText("External %");
        tableColumn.setWidth(100);
        tableColumn = new TableColumn(this.m_table, 16384);
        tableColumn.setText("Class.Method");
        tableColumn.setWidth(600);
        this.m_table.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                TableItem item = (TableItem)event.item;
                if (item == null) {
                    return;
                }
                Object object = item.getData();
                if (object == null) {
                    return;
                }
                MainProcessor.instance().displayContent(HtmlUtils.getUniqueStack((ArrayList)object));
            }
        });
        this.m_table.setHeaderVisible(true);
        this.m_table.setVisible(true);
    }

    private void initializeBrowser(Composite parent) {
        this.m_browser = new Browser(parent, 2048);
        GridData browserGrid = new GridData();
        browserGrid.horizontalSpan = 2;
        this.m_browser.setLayoutData((Object)browserGrid);
        this.m_browser.setSize(800, 400);
        MainProcessor.instance().displayContent(null);
    }

    private void initializeToobar() {
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        man.add((IAction)new Action("open local stack log", ImageUtil.getImageDescriptor(Images.folder)){

            public void run() {
                new MainProcessorAction("Open Stack Log").run();
            }
        });
        man.add((IAction)new Action("open analyzed stack log", ImageUtil.getImageDescriptor(Images.folder_star)){

            public void run() {
                new MainProcessorAction("Open Analyzed Stack Log").run();
            }
        });
        man.add((IAction)new Action("close all stack log", ImageUtil.getImageDescriptor(Images.close_folder)){

            public void run() {
                new MainProcessorAction("Close All").run();
            }
        });
        man.add((IContributionItem)new Separator());
        man.add((IAction)new Action("select local parser configuration", ImageUtil.getImageDescriptor(Images.config)){

            public void run() {
                new MainProcessorAction("Select Parser Configuration").run();
            }
        });
        man.add((IAction)new OpenXMLEditorAction(win, "Edit parser configuration", ImageUtil.getImageDescriptor(Images.config_edit)));
    }

    private void createMainTreePopupMenu() {
        Menu popupMenu = new Menu((Control)this.m_mainTree);
        PopupMenuListener listener = new PopupMenuListener();
        MenuItem menuItem = new MenuItem(popupMenu, 0);
        menuItem.setText("Performance Tree");
        menuItem.addListener(13, (Listener)listener);
        menuItem = new MenuItem(popupMenu, 0);
        menuItem.setText("Reanalyze");
        menuItem.addListener(13, (Listener)listener);
        menuItem = new MenuItem(popupMenu, 0);
        menuItem.setText("Close");
        menuItem.addListener(13, (Listener)listener);
        menuItem = new MenuItem(popupMenu, 2);
        menuItem = new MenuItem(popupMenu, 0);
        menuItem.setText("View Raw Index File");
        menuItem.addListener(13, (Listener)listener);
        menuItem = new MenuItem(popupMenu, 2);
        menuItem = new MenuItem(popupMenu, 64);
        menuItem.setText("Manual Analysis");
        Menu subMenu = new Menu(popupMenu);
        menuItem.setMenu(subMenu);
        menuItem = new MenuItem(subMenu, 0);
        menuItem.setText("Manual Performance Tree(Ascending)");
        menuItem.addListener(13, (Listener)listener);
        menuItem = new MenuItem(subMenu, 0);
        menuItem.setText("Manual Performance Tree(Descending)");
        menuItem.addListener(13, (Listener)listener);
        menuItem = new MenuItem(subMenu, 0);
        menuItem.setText("Manual Service Call");
        menuItem.addListener(13, (Listener)listener);
        menuItem = new MenuItem(subMenu, 0);
        menuItem.setText("Manual Stack Analyze(Include)");
        menuItem.addListener(13, (Listener)listener);
        menuItem = new MenuItem(subMenu, 0);
        menuItem.setText("Manual Stack Analyze(Exclude)");
        menuItem.addListener(13, (Listener)listener);
        menuItem = new MenuItem(subMenu, 0);
        menuItem.setText("Manual Thread Stack (max 20000 lines)");
        menuItem.addListener(13, (Listener)listener);
        menuItem = new MenuItem(popupMenu, 64);
        menuItem.setText("View Option");
        subMenu = new Menu(popupMenu);
        menuItem.setMenu(subMenu);
        MainProcessor mainProcessor = MainProcessor.instance();
        menuItem = new MenuItem(subMenu, 32);
        menuItem.setText("Exclude Stack");
        menuItem.setSelection(mainProcessor.isExcludeStack());
        menuItem.addListener(13, (Listener)listener);
        menuItem = new MenuItem(subMenu, 32);
        menuItem.setText("Remove Line(Performance Tree)");
        menuItem.setSelection(mainProcessor.isRemoveLine());
        menuItem.addListener(13, (Listener)listener);
        menuItem = new MenuItem(subMenu, 2);
        menuItem = new MenuItem(subMenu, 32);
        menuItem.setText("Sort by Function");
        menuItem.setSelection(mainProcessor.isSortByFunction());
        menuItem.addListener(13, (Listener)listener);
        menuItem = new MenuItem(subMenu, 2);
        menuItem = new MenuItem(subMenu, 32);
        menuItem.setText("Simple Dump Time List");
        menuItem.setSelection(mainProcessor.isSimpleDumpTimeList());
        menuItem.addListener(13, (Listener)listener);
        menuItem = new MenuItem(popupMenu, 2);
        menuItem = new MenuItem(popupMenu, 32);
        menuItem.setText("Use Default Parser Configuration");
        menuItem.setSelection(mainProcessor.isDefaultConfiguration());
        menuItem.addListener(13, (Listener)listener);
        menuItem = new MenuItem(popupMenu, 32);
        menuItem.setText("Analyze All Threads In Stack(No Filter)");
        menuItem.setSelection(mainProcessor.isAnalyzeAllThreads());
        menuItem.addListener(13, (Listener)listener);
        this.m_mainTree.setMenu(popupMenu);
    }

    private void createTablePopupMenu() {
        Menu popupMenu = new Menu((Control)this.m_table);
        PopupMenuListener listener = new PopupMenuListener();
        MenuItem menuItem = new MenuItem(popupMenu, 0);
        menuItem.setText("Performance Tree(Ascending)");
        menuItem.addListener(13, (Listener)listener);
        menuItem = new MenuItem(popupMenu, 0);
        menuItem.setText("Performance Tree(Descending)");
        menuItem.addListener(13, (Listener)listener);
        menuItem = new MenuItem(popupMenu, 2);
        menuItem = new MenuItem(popupMenu, 0);
        menuItem.setText("View Thread Stack (max 20000 lines)");
        menuItem.addListener(13, (Listener)listener);
        menuItem = new MenuItem(popupMenu, 0);
        menuItem.setText("View Service Call");
        menuItem.addListener(13, (Listener)listener);
        menuItem = new MenuItem(popupMenu, 2);
        menuItem = new MenuItem(popupMenu, 0);
        menuItem.setText("Filter Stack Analyze");
        menuItem.addListener(13, (Listener)listener);
        menuItem = new MenuItem(popupMenu, 0);
        menuItem.setText("Copy Function");
        menuItem.addListener(13, (Listener)listener);
        this.m_table.setMenu(popupMenu);
    }

    public void setFocus() {
    }

    public Tree getMainTree() {
        return this.m_mainTree;
    }

    public Table getTable() {
        return this.m_table;
    }

    public Browser getBrowser() {
        return this.m_browser;
    }
}

