/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.stack.views;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.stack.actions.SaveXMLEditorAction;
import scouter.client.stack.base.MainProcessor;
import scouter.client.stack.base.PreferenceManager;
import scouter.client.stack.data.StackFileInfo;
import scouter.client.stack.utils.ResourceUtils;
import scouter.client.util.ColoringWord;
import scouter.client.util.CustomLineStyleListener;
import scouter.client.util.ImageUtil;

public class XMLEditorView
extends ViewPart {
    public static final String ID = XMLEditorView.class.getName();
    private ArrayList<ColoringWord> m_defaultHighlightings;
    private StyledText m_text;
    private String m_fileName;
    private SaveXMLEditorAction m_saveAction;
    private CustomLineStyleListener m_listener;

    public void createPartControl(Composite parent) {
        this.m_text = new StyledText(parent, 2818);
        this.initDefaultHighlightings();
        this.m_listener = new CustomLineStyleListener(true, this.m_defaultHighlightings, false);
        this.m_text.addLineStyleListener((LineStyleListener)this.m_listener);
        this.m_text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 262144) {
                    if (e.keyCode == 115) {
                        XMLEditorView.this.saveConfigurations();
                    } else if (e.keyCode == 97) {
                        XMLEditorView.this.m_text.selectAll();
                    }
                }
            }
        });
        String fileName = null;
        MainProcessor mainProcessor = MainProcessor.instance();
        if (!mainProcessor.isDefaultConfiguration()) {
            fileName = this.checkFile(PreferenceManager.get().getCurrentParserConfig());
        }
        if (fileName == null) {
            StackFileInfo stackFileInfo = mainProcessor.getSelectedStackFileInfo();
            fileName = stackFileInfo == null ? "Default" : this.checkFile(stackFileInfo.getParserConfig().getConfigFilename());
        }
        this.setFileName(fileName);
        this.initialToolBar();
        this.loadConfig();
    }

    private String checkFile(String fileName) {
        if (fileName == null) {
            return null;
        }
        File file = new File(fileName);
        if (!file.exists() || !file.isFile()) {
            String message = new StringBuilder(100).append(fileName).append(" file is not exist. then editor use a default xml configuration.").toString();
            ResourceUtils.confirmMessage(this.getSite().getShell(), message);
            return "Default";
        }
        return fileName;
    }

    private void setFileName(String fileName) {
        this.m_fileName = fileName;
        this.setPartName("ConfigStackAnalyzer-" + this.m_fileName);
    }

    private void loadConfig() {
        block15: {
            BufferedInputStream in = null;
            int fileSize = 0;
            byte[] data = null;
            try {
                try {
                    if ("Default".equals(this.m_fileName)) {
                        int ch;
                        in = new BufferedInputStream(ResourceUtils.getDefaultXMLConfig());
                        data = new byte[102400];
                        while ((ch = in.read()) >= 0) {
                            data[fileSize] = (byte)ch;
                            ++fileSize;
                        }
                    } else {
                        File file = new File(this.m_fileName);
                        fileSize = (int)file.length();
                        in = new BufferedInputStream(new FileInputStream(file));
                        data = new byte[fileSize];
                        in.read(data);
                    }
                    this.m_text.setText(new String(data, 0, fileSize, "UTF-8"));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (in == null) break block15;
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private void saveAsConfigurations() {
        String newFileName = ResourceUtils.openFileSaveDialog(new String[]{"XML Parser Configuration"}, new String[]{"*.xml"}, ".", "scouter_stackanalyzer");
        if (newFileName == null) {
            return;
        }
        ResourceUtils.saveFile(newFileName, this.m_text.getText());
        if ("Default".equals(this.m_fileName)) {
            ResourceUtils.setVisiable(this, this.m_saveAction.getId(), true);
        }
        this.setFileName(newFileName);
        PreferenceManager.get().setCurrentParserConfig(newFileName);
        MainProcessor.instance().displayContent(null);
    }

    public void saveConfigurations() {
        ResourceUtils.saveFile(this.m_fileName, this.m_text.getText());
    }

    private void initialToolBar() {
        IToolBarManager man = this.getViewSite().getActionBars().getToolBarManager();
        this.m_saveAction = new SaveXMLEditorAction(this, "Save", ImageUtil.getImageDescriptor(Images.save));
        man.add((IAction)this.m_saveAction);
        if ("Default".equals(this.m_fileName)) {
            ResourceUtils.setVisiable(this, this.m_saveAction.getId(), false);
        }
        man.add((IAction)new Action("SaveAs", ImageUtil.getImageDescriptor(Images.saveas)){

            public void run() {
                XMLEditorView.this.saveAsConfigurations();
            }
        });
    }

    public void setFocus() {
        IStatusLineManager slManager = this.getViewSite().getActionBars().getStatusLineManager();
        slManager.setMessage("CTRL + S : save configurations, CTRL + A : select all text");
    }

    private void initDefaultHighlightings() {
        this.m_defaultHighlightings = new ArrayList(20);
        this.m_defaultHighlightings.add(new ColoringWord("<scouter>", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("</scouter>", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("<parser", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("</parser>", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("<time", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("</time>", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("<workerThread>", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("</workerThread>", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("<workingThread", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("</workingThread>", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("<log>", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("</log>", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("<sql>", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("</sql>", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("<service", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("</service>", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("<singleStack>", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("</singleStack>", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("<excludeStack>", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("</excludeStack>", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("<analyze>", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("</analyze>", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("<analyzeStack", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("</analyzeStack", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("<list>", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("</list>", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("<listMain>", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("</listMain>", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("<jmx>", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("</jmx>", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("<count>", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("</count>", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("<interval>", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("</interval>", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("<path>", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("</path>", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("<server>", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("</server>", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("<ip>", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("</ip>", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("<port>", 9, true));
        this.m_defaultHighlightings.add(new ColoringWord("</port>", 9, true));
    }
}

