/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.summary.modules;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import scouter.client.Images;
import scouter.client.model.AgentModelThread;
import scouter.client.model.AgentObject;
import scouter.client.popup.CalendarDialog;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.sorter.ColumnLabelSorter;
import scouter.client.util.TimeUtil;
import scouter.lang.pack.MapPack;
import scouter.util.DateUtil;

public abstract class AbstractSummaryComposite
extends Composite {
    public static final String[] HOURLY_TIMES = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24"};
    public static final String[] FIVE_MIN_TIMES = new String[]{"00", "05", "10", "15", "20", "25", "30", "35", "40", "45", "50", "55", "60"};
    Composite parent;
    int serverId;
    MapPack param;
    Label startDateLbl;
    Combo startHHCmb;
    Combo startMMCmb;
    Label endDateLbl;
    Combo endHHCmb;
    Combo endMMCmb;
    protected TableViewer viewer;
    private TableColumnLayout tableColumnLayout;
    private Clipboard clipboard;
    String date = DateUtil.yyyymmdd();
    String endDate = DateUtil.yyyymmdd();

    public AbstractSummaryComposite(Composite parent, int style) {
        super(parent, style);
        this.parent = parent;
    }

    public void setData(int serverId, MapPack param) {
        this.serverId = serverId;
        this.param = param;
        this.initLayout();
        this.clipboard = new Clipboard(null);
    }

    private void initLayout() {
        this.setLayout((Layout)new GridLayout(1, true));
        Composite upperComp = new Composite((Composite)this, 0);
        upperComp.setLayoutData((Object)new GridData(4, 4, true, false));
        upperComp.setLayout((Layout)new GridLayout(8, false));
        long now = TimeUtil.getCurrentTime(this.serverId);
        this.startDateLbl = new Label(upperComp, 0x1000800);
        this.startDateLbl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.startDateLbl.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                CalendarDialog dialog = new CalendarDialog(AbstractSummaryComposite.this.parent.getDisplay(), new CalendarDialog.ILoadCalendarDialog(){

                    @Override
                    public void onPressedOk(long startTime, long endTime) {
                    }

                    @Override
                    public void onPressedCancel() {
                    }

                    @Override
                    public void onPressedOk(String date) {
                        AbstractSummaryComposite.this.setDate(date);
                        (this).AbstractSummaryComposite.this.startDateLbl.setText(DateUtil.format((long)DateUtil.yyyymmdd((String)date), (String)"yyyy-MM-dd"));
                    }
                });
                dialog.show(-1, -1, DateUtil.yyyymmdd((String)AbstractSummaryComposite.this.date));
            }
        });
        this.startDateLbl.setText(DateUtil.format((long)now, (String)"yyyy-MM-dd"));
        Composite startCmbComp = new Composite(upperComp, 0);
        startCmbComp.setLayoutData((Object)new GridData(0x1000000, 4, true, false));
        startCmbComp.setLayout((Layout)new RowLayout());
        long start = now - 300000L;
        this.startHHCmb = new Combo(startCmbComp, 2568);
        this.startHHCmb.setLayoutData((Object)new RowData(50, -1));
        this.startHHCmb.setItems(HOURLY_TIMES);
        this.startHHCmb.setText(DateUtil.format((long)start, (String)"HH"));
        this.startMMCmb = new Combo(startCmbComp, 2568);
        this.startMMCmb.setLayoutData((Object)new RowData(50, -1));
        this.startMMCmb.setItems(FIVE_MIN_TIMES);
        this.startMMCmb.setText(DateUtil.format((long)(start / 300000L * 300000L), (String)"mm"));
        Label label = new Label(upperComp, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label.setAlignment(0x1000000);
        label.setText("to");
        this.endDateLbl = new Label(upperComp, 0x1000800);
        this.endDateLbl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.endDateLbl.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                CalendarDialog dialog = new CalendarDialog(AbstractSummaryComposite.this.parent.getDisplay(), new CalendarDialog.ILoadCalendarDialog(){

                    @Override
                    public void onPressedOk(long startTime, long endTime) {
                    }

                    @Override
                    public void onPressedCancel() {
                    }

                    @Override
                    public void onPressedOk(String date) {
                        AbstractSummaryComposite.this.setEndDate(date);
                        (this).AbstractSummaryComposite.this.endDateLbl.setText(DateUtil.format((long)DateUtil.yyyymmdd((String)date), (String)"yyyy-MM-dd"));
                    }
                });
                dialog.show(-1, -1, DateUtil.yyyymmdd((String)AbstractSummaryComposite.this.endDate));
            }
        });
        this.endDateLbl.setText(DateUtil.format((long)now, (String)"yyyy-MM-dd"));
        Composite endCmbComp = new Composite(upperComp, 0);
        endCmbComp.setLayoutData((Object)new GridData(0x1000000, 4, true, false));
        endCmbComp.setLayout((Layout)new RowLayout());
        this.endHHCmb = new Combo(endCmbComp, 2568);
        this.endHHCmb.setLayoutData((Object)new RowData(50, -1));
        this.endHHCmb.setItems(HOURLY_TIMES);
        this.endHHCmb.setText(DateUtil.format((long)now, (String)"HH"));
        this.endMMCmb = new Combo(endCmbComp, 2568);
        this.endMMCmb.setLayoutData((Object)new RowData(50, -1));
        this.endMMCmb.setItems(FIVE_MIN_TIMES);
        this.endMMCmb.setText(DateUtil.format((long)(now / 300000L * 300000L), (String)"mm"));
        Button getBtn = new Button(upperComp, 8);
        GridData gd = new GridData(4, 0x1000000, true, false);
        getBtn.setLayoutData((Object)gd);
        getBtn.setText("&GET");
        getBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                long etime;
                long stime = DateUtil.getTime((String)(String.valueOf(AbstractSummaryComposite.this.date) + AbstractSummaryComposite.this.startHHCmb.getText() + AbstractSummaryComposite.this.startMMCmb.getText()), (String)"yyyyMMddHHmm");
                if (stime >= (etime = DateUtil.getTime((String)(String.valueOf(AbstractSummaryComposite.this.endDate) + AbstractSummaryComposite.this.endHHCmb.getText() + AbstractSummaryComposite.this.endMMCmb.getText()), (String)"yyyyMMddHHmm") - 1L)) {
                    MessageDialog.openWarning((Shell)AbstractSummaryComposite.this.parent.getShell(), (String)"Warning", (String)"Wrong range");
                    return;
                }
                AbstractSummaryComposite.this.param.put("date", AbstractSummaryComposite.this.date);
                AbstractSummaryComposite.this.param.put("stime", stime);
                AbstractSummaryComposite.this.param.put("etime", etime);
                AbstractSummaryComposite.this.getSummaryData();
            }
        });
        Button clearBtn = new Button(upperComp, 8);
        gd = new GridData(4, 0x1000000, true, false);
        clearBtn.setLayoutData((Object)gd);
        clearBtn.setText("&CLEAR");
        clearBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractSummaryComposite.this.viewer.getTable().removeAll();
            }
        });
        Button csvBtn = new Button(upperComp, 8);
        gd = new GridData(4, 0x1000000, true, false);
        csvBtn.setLayoutData((Object)gd);
        csvBtn.setText("&CSV");
        csvBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(AbstractSummaryComposite.this.parent.getShell(), 8192);
                dialog.setOverwrite(true);
                String filename = "[" + AbstractSummaryComposite.this.getTarget() + "][" + AbstractSummaryComposite.this.date + AbstractSummaryComposite.this.startHHCmb.getText() + AbstractSummaryComposite.this.startMMCmb.getText() + "-" + AbstractSummaryComposite.this.endDate + AbstractSummaryComposite.this.endHHCmb.getText() + AbstractSummaryComposite.this.endMMCmb.getText() + "]" + AbstractSummaryComposite.this.getTitle() + ".csv";
                dialog.setFileName(filename);
                dialog.setFilterExtensions(new String[]{"*.csv", "*.*"});
                dialog.setFilterNames(new String[]{"CSV File(*.csv)", "All Files"});
                String fileSelected = dialog.open();
                if (fileSelected != null) {
                    CSVWriter cw = null;
                    try {
                        try {
                            cw = new CSVWriter((Writer)new FileWriter(fileSelected));
                            int colCnt = AbstractSummaryComposite.this.viewer.getTable().getColumnCount();
                            ArrayList<String> list = new ArrayList<String>();
                            int i = 0;
                            while (i < colCnt) {
                                TableColumn column = AbstractSummaryComposite.this.viewer.getTable().getColumn(i);
                                list.add(column.getText());
                                ++i;
                            }
                            cw.writeNext(list.toArray(new String[list.size()]));
                            cw.flush();
                            TableItem[] items = AbstractSummaryComposite.this.viewer.getTable().getItems();
                            if (items != null && items.length > 0) {
                                TableItem[] tableItemArray = items;
                                int n = items.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    TableItem item = tableItemArray[n2];
                                    list.clear();
                                    int i2 = 0;
                                    while (i2 < colCnt) {
                                        list.add(item.getText(i2));
                                        ++i2;
                                    }
                                    cw.writeNext(list.toArray(new String[list.size()]));
                                    cw.flush();
                                    ++n2;
                                }
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            try {
                                if (cw != null) {
                                    cw.close();
                                }
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    finally {
                        try {
                            if (cw != null) {
                                cw.close();
                            }
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
        });
        Composite tableComp = new Composite((Composite)this, 0);
        gd = new GridData(4, 4, true, true);
        gd.widthHint = 800;
        gd.heightHint = 400;
        tableComp.setLayoutData((Object)gd);
        this.createTableViewer(tableComp);
    }

    private void setDate(String date) {
        this.date = date;
    }

    private void setEndDate(String date) {
        this.endDate = date;
    }

    protected abstract void getSummaryData();

    protected abstract String getTitle();

    private void createTableViewer(Composite composite) {
        this.viewer = new TableViewer(composite, 68354);
        this.tableColumnLayout = new TableColumnLayout();
        composite.setLayout((Layout)this.tableColumnLayout);
        this.createColumns();
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.createTableContextMenu();
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new ColumnLabelSorter(this.viewer));
        GridData gridData = new GridData(4, 4, true, true);
        this.viewer.getControl().setLayoutData((Object)gridData);
    }

    private void createTableContextMenu() {
        MenuManager manager = new MenuManager();
        this.viewer.getControl().setMenu(manager.createContextMenu(this.viewer.getControl()));
        manager.add((IAction)new Action("&Copy", ImageDescriptor.createFromImage((Image)Images.copy)){

            public void run() {
                AbstractSummaryComposite.this.copyToClipboard(AbstractSummaryComposite.this.viewer.getTable().getSelection());
            }
        });
        this.viewer.getTable().addListener(1, new Listener(){

            public void handleEvent(Event e) {
                if (e.stateMask == 262144 || e.stateMask == 0x400000) {
                    switch (e.keyCode) {
                        case 67: 
                        case 99: {
                            TableItem[] items = AbstractSummaryComposite.this.viewer.getTable().getSelection();
                            if (items == null || items.length < 1) {
                                return;
                            }
                            AbstractSummaryComposite.this.copyToClipboard(items);
                            break;
                        }
                        case 65: 
                        case 97: {
                            AbstractSummaryComposite.this.viewer.getTable().selectAll();
                        }
                    }
                }
            }
        });
    }

    private void copyToClipboard(TableItem[] items) {
        if (this.viewer != null) {
            int colCnt = this.viewer.getTable().getColumnCount();
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < colCnt) {
                TableColumn column = this.viewer.getTable().getColumn(i);
                sb.append(column.getText());
                if (i == colCnt - 1) {
                    sb.append("\n");
                } else {
                    sb.append("\t");
                }
                ++i;
            }
            if (items != null && items.length > 0) {
                TableItem[] tableItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    int i2 = 0;
                    while (i2 < colCnt) {
                        sb.append(item.getText(i2));
                        if (i2 == colCnt - 1) {
                            sb.append("\n");
                        } else {
                            sb.append("\t");
                        }
                        ++i2;
                    }
                    ++n2;
                }
                this.clipboard.setContents(new Object[]{sb.toString()}, new Transfer[]{TextTransfer.getInstance()});
            }
        }
    }

    protected abstract void createColumns();

    protected TableViewerColumn createTableViewerColumn(String title, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setAlignment(alignment);
        column.setMoveable(moveable);
        this.tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(30, width, resizable));
        column.setData("isNumber", (Object)isNumber);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnLabelSorter sorter = (ColumnLabelSorter)AbstractSummaryComposite.this.viewer.getComparator();
                TableColumn selectedColumn = (TableColumn)e.widget;
                sorter.setColumn(selectedColumn);
            }
        });
        return viewerColumn;
    }

    private String getTarget() {
        Server server = ServerManager.getInstance().getServer(this.serverId);
        int objHash = this.param.getInt("objHash");
        if (objHash != 0) {
            AgentObject ao = AgentModelThread.getInstance().getAgentObject(objHash);
            return ao.getDisplayName();
        }
        String objType = this.param.getText("objType");
        if (objType != null) {
            return objType;
        }
        return server.getName();
    }
}

