/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.summary.modules;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.widgets.Composite;
import scouter.client.net.TcpProxy;
import scouter.client.summary.modules.AbstractSummaryComposite;
import scouter.client.util.ExUtil;
import scouter.lang.AlertLevel;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.util.DateUtil;
import scouter.util.FormatUtil;

public class AlertSummaryComposite
extends AbstractSummaryComposite {
    public AlertSummaryComposite(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected void createColumns() {
        AlertColumnEnum[] alertColumnEnumArray = AlertColumnEnum.values();
        int n = alertColumnEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            AlertColumnEnum column = alertColumnEnumArray[n2];
            TableViewerColumn c = this.createTableViewerColumn(column.getTitle(), column.getWidth(), column.getAlignment(), column.isResizable(), column.isMoveable(), column.isNumber());
            ColumnLabelProvider labelProvider = null;
            switch (column) {
                case TITLE: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof AlertData) {
                                return ((AlertData)element).title;
                            }
                            return null;
                        }
                    };
                    break;
                }
                case LEVEL: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof AlertData) {
                                return AlertLevel.getName((byte)((AlertData)element).level);
                            }
                            return null;
                        }
                    };
                    break;
                }
                case COUNT: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof AlertData) {
                                return FormatUtil.print((Object)((AlertData)element).count, (String)"#,##0");
                            }
                            return null;
                        }
                    };
                }
            }
            if (labelProvider != null) {
                c.setLabelProvider((CellLabelProvider)labelProvider);
            }
            ++n2;
        }
    }

    @Override
    protected void getSummaryData() {
        new LoadLongdayAlertSummaryJob(this.param, this.param.getLong("stime"), this.param.getLong("etime")).schedule();
    }

    @Override
    protected String getTitle() {
        return "ALERT";
    }

    static enum AlertColumnEnum {
        TITLE("TITLE", 150, 16384, true, true, false),
        LEVEL("LEVEL", 100, 16384, true, true, false),
        COUNT("Count", 70, 131072, true, true, true);

        private final String title;
        private final int width;
        private final int alignment;
        private final boolean resizable;
        private final boolean moveable;
        private final boolean isNumber;

        private AlertColumnEnum(String text, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
            this.title = text;
            this.width = width;
            this.alignment = alignment;
            this.resizable = resizable;
            this.moveable = moveable;
            this.isNumber = isNumber;
        }

        public String getTitle() {
            return this.title;
        }

        public int getAlignment() {
            return this.alignment;
        }

        public boolean isResizable() {
            return this.resizable;
        }

        public boolean isMoveable() {
            return this.moveable;
        }

        public int getWidth() {
            return this.width;
        }

        public boolean isNumber() {
            return this.isNumber;
        }
    }

    private static class AlertData {
        public String title;
        public byte level;
        public int count;

        private AlertData() {
        }

        public void addData(AlertData another) {
            this.count += another.count;
        }
    }

    class LoadAlertSummaryJob
    extends Job {
        MapPack param;

        public LoadAlertSummaryJob(MapPack param) {
            super("Loading...");
            this.param = param;
        }

        protected IStatus run(IProgressMonitor monitor) {
            TcpProxy tcp = TcpProxy.getTcpProxy(AlertSummaryComposite.this.serverId);
            Pack p = null;
            try {
                try {
                    p = tcp.getSingle("LOAD_ALERT_SUMMARY", (Pack)this.param);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    IStatus iStatus = Status.CANCEL_STATUS;
                    TcpProxy.putTcpProxy(tcp);
                    return iStatus;
                }
            }
            finally {
                TcpProxy.putTcpProxy(tcp);
            }
            if (p != null) {
                final ArrayList<AlertData> list = new ArrayList<AlertData>();
                MapPack m = (MapPack)p;
                ListValue titleLv = m.getList("title");
                ListValue levelLv = m.getList("level");
                ListValue countLv = m.getList("count");
                int i = 0;
                while (i < titleLv.size()) {
                    AlertData data = new AlertData();
                    data.title = titleLv.getString(i);
                    data.level = (byte)levelLv.getInt(i);
                    data.count = countLv.getInt(i);
                    list.add(data);
                    ++i;
                }
                ExUtil.exec((Composite)AlertSummaryComposite.this.viewer.getTable(), new Runnable(){

                    @Override
                    public void run() {
                        ((LoadAlertSummaryJob)LoadAlertSummaryJob.this).AlertSummaryComposite.this.viewer.setInput((Object)list);
                    }
                });
            }
            return Status.OK_STATUS;
        }
    }

    class LoadLongdayAlertSummaryJob
    extends Job {
        MapPack param;
        long stime;
        long etime;

        public LoadLongdayAlertSummaryJob(MapPack param, long stime, long etime) {
            super("Loading...");
            this.param = param;
            this.stime = stime;
            this.etime = etime;
        }

        protected IStatus run(IProgressMonitor monitor) {
            TcpProxy tcp = TcpProxy.getTcpProxy(AlertSummaryComposite.this.serverId);
            ArrayList<Pack> packList = new ArrayList<Pack>();
            try {
                try {
                    while (this.stime <= this.etime) {
                        String date = DateUtil.yyyymmdd((long)this.stime);
                        long lastTimestampOfDay = DateUtil.getTime((String)date, (String)"yyyyMMdd") + 86400000L - 1L;
                        this.param.put("date", date);
                        this.param.put("stime", this.stime);
                        this.param.put("etime", lastTimestampOfDay <= this.etime ? lastTimestampOfDay : this.etime);
                        packList.add(tcp.getSingle("LOAD_ALERT_SUMMARY", (Pack)this.param));
                        this.stime += 86400000L;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    IStatus iStatus = Status.CANCEL_STATUS;
                    TcpProxy.putTcpProxy(tcp);
                    return iStatus;
                }
            }
            finally {
                TcpProxy.putTcpProxy(tcp);
            }
            if (packList.size() > 0) {
                final HashMap<String, AlertData> alertDataMap = new HashMap<String, AlertData>();
                for (Pack p : packList) {
                    MapPack m = (MapPack)p;
                    ListValue titleLv = m.getList("title");
                    ListValue levelLv = m.getList("level");
                    ListValue countLv = m.getList("count");
                    int i = 0;
                    while (i < titleLv.size()) {
                        AlertData data = new AlertData();
                        data.title = titleLv.getString(i);
                        data.level = (byte)levelLv.getInt(i);
                        data.count = countLv.getInt(i);
                        if (alertDataMap.containsKey(data.title)) {
                            ((AlertData)alertDataMap.get(data.title)).addData(data);
                        } else {
                            alertDataMap.put(data.title, data);
                        }
                        ++i;
                    }
                }
                ExUtil.exec((Composite)AlertSummaryComposite.this.viewer.getTable(), new Runnable(){

                    @Override
                    public void run() {
                        ((LoadLongdayAlertSummaryJob)LoadLongdayAlertSummaryJob.this).AlertSummaryComposite.this.viewer.setInput(alertDataMap.values());
                    }
                });
            }
            return Status.OK_STATUS;
        }
    }
}

