/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.summary.modules;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.widgets.Composite;
import scouter.client.model.TextProxy;
import scouter.client.net.TcpProxy;
import scouter.client.summary.modules.AbstractSummaryComposite;
import scouter.client.summary.modules.SummaryData;
import scouter.client.util.ExUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.util.DateUtil;
import scouter.util.FormatUtil;

public class ApicallSummaryComposite
extends AbstractSummaryComposite {
    public ApicallSummaryComposite(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected void createColumns() {
        ApicallColumnEnum[] apicallColumnEnumArray = ApicallColumnEnum.values();
        int n = apicallColumnEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            ApicallColumnEnum column = apicallColumnEnumArray[n2];
            TableViewerColumn c = this.createTableViewerColumn(column.getTitle(), column.getWidth(), column.getAlignment(), column.isResizable(), column.isMoveable(), column.isNumber());
            ColumnLabelProvider labelProvider = null;
            switch (column) {
                case URL: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof SummaryData) {
                                return TextProxy.apicall.getText(((SummaryData)element).hash);
                            }
                            return null;
                        }
                    };
                    break;
                }
                case COUNT: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof SummaryData) {
                                return FormatUtil.print((Object)((SummaryData)element).count, (String)"#,##0");
                            }
                            return null;
                        }
                    };
                    break;
                }
                case ERROR_COUNT: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof SummaryData) {
                                return FormatUtil.print((Object)((SummaryData)element).errorCount, (String)"#,##0");
                            }
                            return null;
                        }
                    };
                    break;
                }
                case ELAPSED_SUM: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof SummaryData) {
                                return FormatUtil.print((Object)((SummaryData)element).elapsedSum, (String)"#,##0");
                            }
                            return null;
                        }
                    };
                    break;
                }
                case ELAPSED_AVG: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof SummaryData) {
                                SummaryData data = (SummaryData)element;
                                return FormatUtil.print((Object)((double)data.elapsedSum / (double)data.count), (String)"#,##0");
                            }
                            return null;
                        }
                    };
                }
            }
            if (labelProvider != null) {
                c.setLabelProvider((CellLabelProvider)labelProvider);
            }
            ++n2;
        }
    }

    @Override
    protected void getSummaryData() {
        new LoadLongdayApicallSummaryJob(this.param, this.param.getLong("stime"), this.param.getLong("etime")).schedule();
    }

    @Override
    protected String getTitle() {
        return "APICALL";
    }

    static enum ApicallColumnEnum {
        URL("URL", 150, 0x1000000, true, true, false),
        COUNT("Count", 70, 131072, true, true, true),
        ERROR_COUNT("Error", 70, 131072, true, true, true),
        ELAPSED_SUM("Total Elapsed(ms)", 150, 131072, true, true, true),
        ELAPSED_AVG("Avg Elapsed(ms)", 150, 131072, true, true, true);

        private final String title;
        private final int width;
        private final int alignment;
        private final boolean resizable;
        private final boolean moveable;
        private final boolean isNumber;

        private ApicallColumnEnum(String text, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
            this.title = text;
            this.width = width;
            this.alignment = alignment;
            this.resizable = resizable;
            this.moveable = moveable;
            this.isNumber = isNumber;
        }

        public String getTitle() {
            return this.title;
        }

        public int getAlignment() {
            return this.alignment;
        }

        public boolean isResizable() {
            return this.resizable;
        }

        public boolean isMoveable() {
            return this.moveable;
        }

        public int getWidth() {
            return this.width;
        }

        public boolean isNumber() {
            return this.isNumber;
        }
    }

    class LoadApicallSummaryJob
    extends Job {
        MapPack param;

        public LoadApicallSummaryJob(MapPack param) {
            super("Loading...");
            this.param = param;
        }

        protected IStatus run(IProgressMonitor monitor) {
            TcpProxy tcp = TcpProxy.getTcpProxy(ApicallSummaryComposite.this.serverId);
            Pack p = null;
            try {
                try {
                    p = tcp.getSingle("LOAD_APICALL_SUMMARY", (Pack)this.param);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    IStatus iStatus = Status.CANCEL_STATUS;
                    TcpProxy.putTcpProxy(tcp);
                    return iStatus;
                }
            }
            finally {
                TcpProxy.putTcpProxy(tcp);
            }
            if (p != null) {
                final ArrayList<SummaryData> list = new ArrayList<SummaryData>();
                MapPack m = (MapPack)p;
                ListValue idLv = m.getList("id");
                ListValue countLv = m.getList("count");
                ListValue errorLv = m.getList("error");
                ListValue elapsedLv = m.getList("elapsed");
                int i = 0;
                while (i < idLv.size()) {
                    SummaryData data = new SummaryData();
                    data.hash = idLv.getInt(i);
                    data.count = countLv.getInt(i);
                    data.errorCount = errorLv.getInt(i);
                    data.elapsedSum = elapsedLv.getLong(i);
                    list.add(data);
                    ++i;
                }
                TextProxy.apicall.load(ApicallSummaryComposite.this.date, idLv, ApicallSummaryComposite.this.serverId);
                ExUtil.exec((Composite)ApicallSummaryComposite.this.viewer.getTable(), new Runnable(){

                    @Override
                    public void run() {
                        ((LoadApicallSummaryJob)LoadApicallSummaryJob.this).ApicallSummaryComposite.this.viewer.setInput((Object)list);
                    }
                });
            }
            return Status.OK_STATUS;
        }
    }

    class LoadLongdayApicallSummaryJob
    extends Job {
        MapPack param;
        long stime;
        long etime;

        public LoadLongdayApicallSummaryJob(MapPack param, long stime, long etime) {
            super("Loading...");
            this.param = param;
            this.stime = stime;
            this.etime = etime;
        }

        protected IStatus run(IProgressMonitor monitor) {
            TcpProxy tcp = TcpProxy.getTcpProxy(ApicallSummaryComposite.this.serverId);
            ArrayList<Pack> packList = new ArrayList<Pack>();
            try {
                try {
                    while (this.stime <= this.etime) {
                        String date = DateUtil.yyyymmdd((long)this.stime);
                        long lastTimestampOfDay = DateUtil.getTime((String)date, (String)"yyyyMMdd") + 86400000L - 1L;
                        this.param.put("date", date);
                        this.param.put("stime", this.stime);
                        this.param.put("etime", lastTimestampOfDay <= this.etime ? lastTimestampOfDay : this.etime);
                        packList.add(tcp.getSingle("LOAD_APICALL_SUMMARY", (Pack)this.param));
                        this.stime += 86400000L;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    IStatus iStatus = Status.CANCEL_STATUS;
                    TcpProxy.putTcpProxy(tcp);
                    return iStatus;
                }
            }
            finally {
                TcpProxy.putTcpProxy(tcp);
            }
            if (packList.size() > 0) {
                final HashMap<Integer, SummaryData> summaryDataMap = new HashMap<Integer, SummaryData>();
                for (Pack p : packList) {
                    MapPack m = (MapPack)p;
                    ListValue idLv = m.getList("id");
                    ListValue countLv = m.getList("count");
                    ListValue errorLv = m.getList("error");
                    ListValue elapsedLv = m.getList("elapsed");
                    int i = 0;
                    while (i < idLv.size()) {
                        SummaryData data = new SummaryData();
                        data.hash = idLv.getInt(i);
                        data.count = countLv.getInt(i);
                        data.errorCount = errorLv.getInt(i);
                        data.elapsedSum = elapsedLv.getLong(i);
                        if (summaryDataMap.containsKey(data.hash)) {
                            ((SummaryData)summaryDataMap.get(data.hash)).addData(data);
                        } else {
                            summaryDataMap.put(data.hash, data);
                        }
                        ++i;
                    }
                    TextProxy.apicall.load(ApicallSummaryComposite.this.date, idLv, ApicallSummaryComposite.this.serverId);
                }
                ExUtil.exec((Composite)ApicallSummaryComposite.this.viewer.getTable(), new Runnable(){

                    @Override
                    public void run() {
                        ((LoadLongdayApicallSummaryJob)LoadLongdayApicallSummaryJob.this).ApicallSummaryComposite.this.viewer.setInput(summaryDataMap.values());
                    }
                });
            }
            return Status.OK_STATUS;
        }
    }
}

