/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.summary.modules;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.widgets.Composite;
import scouter.client.model.TextProxy;
import scouter.client.net.TcpProxy;
import scouter.client.summary.modules.AbstractSummaryComposite;
import scouter.client.util.ExUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.util.BitUtil;
import scouter.util.DateUtil;
import scouter.util.FormatUtil;
import scouter.util.Hexa32;

public class ErrorSummaryComposite
extends AbstractSummaryComposite {
    public ErrorSummaryComposite(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected void createColumns() {
        ErrorColumnEnum[] errorColumnEnumArray = ErrorColumnEnum.values();
        int n = errorColumnEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            ErrorColumnEnum column = errorColumnEnumArray[n2];
            TableViewerColumn c = this.createTableViewerColumn(column.getTitle(), column.getWidth(), column.getAlignment(), column.isResizable(), column.isMoveable(), column.isNumber());
            ColumnLabelProvider labelProvider = null;
            switch (column) {
                case ERROR: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof ErrorData) {
                                return TextProxy.error.getText(((ErrorData)element).error);
                            }
                            return null;
                        }
                    };
                    break;
                }
                case SERVICE: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof ErrorData) {
                                return TextProxy.service.getText(((ErrorData)element).service);
                            }
                            return null;
                        }
                    };
                    break;
                }
                case MESSAGE: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof ErrorData) {
                                return TextProxy.error.getText(((ErrorData)element).message);
                            }
                            return null;
                        }
                    };
                    break;
                }
                case COUNT: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof ErrorData) {
                                return FormatUtil.print((Object)((ErrorData)element).count, (String)"#,##0");
                            }
                            return null;
                        }
                    };
                    break;
                }
                case TXID: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof ErrorData) {
                                return Hexa32.toString32((long)((ErrorData)element).txid);
                            }
                            return null;
                        }
                    };
                    break;
                }
                case SQL: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof ErrorData) {
                                return TextProxy.sql.getText(((ErrorData)element).sql);
                            }
                            return null;
                        }
                    };
                    break;
                }
                case APICALL: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof ErrorData) {
                                return TextProxy.apicall.getText(((ErrorData)element).apicall);
                            }
                            return null;
                        }
                    };
                    break;
                }
                case FULLSTACK: {
                    labelProvider = new ColumnLabelProvider(){

                        public String getText(Object element) {
                            if (element instanceof ErrorData) {
                                return TextProxy.error.getText(((ErrorData)element).fullstack);
                            }
                            return null;
                        }
                    };
                }
            }
            if (labelProvider != null) {
                c.setLabelProvider((CellLabelProvider)labelProvider);
            }
            ++n2;
        }
    }

    @Override
    protected void getSummaryData() {
        new LoadLongdayErrorSummaryJob(this.param, this.param.getLong("stime"), this.param.getLong("etime")).schedule();
    }

    @Override
    protected String getTitle() {
        return "EXCEPTION";
    }

    static enum ErrorColumnEnum {
        ERROR("Exception", 150, 16384, true, true, false),
        SERVICE("Service", 150, 16384, true, true, false),
        MESSAGE("Message", 200, 16384, true, true, false),
        COUNT("Count", 70, 131072, true, true, true),
        TXID("TxId", 100, 0x1000000, true, true, false),
        SQL("SQL", 150, 16384, true, true, false),
        APICALL("ApiCall", 150, 16384, true, true, false),
        FULLSTACK("Full Stack", 200, 16384, true, true, false);

        private final String title;
        private final int width;
        private final int alignment;
        private final boolean resizable;
        private final boolean moveable;
        private final boolean isNumber;

        private ErrorColumnEnum(String text, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
            this.title = text;
            this.width = width;
            this.alignment = alignment;
            this.resizable = resizable;
            this.moveable = moveable;
            this.isNumber = isNumber;
        }

        public String getTitle() {
            return this.title;
        }

        public int getAlignment() {
            return this.alignment;
        }

        public boolean isResizable() {
            return this.resizable;
        }

        public boolean isMoveable() {
            return this.moveable;
        }

        public int getWidth() {
            return this.width;
        }

        public boolean isNumber() {
            return this.isNumber;
        }
    }

    private static class ErrorData {
        public int error;
        public int service;
        public int message;
        public int count;
        public long txid;
        public int sql;
        public int apicall;
        public int fullstack;

        private ErrorData() {
        }

        public void addData(ErrorData another) {
            this.count += another.count;
        }
    }

    class LoadErrorSummaryJob
    extends Job {
        MapPack param;

        public LoadErrorSummaryJob(MapPack param) {
            super("Loading...");
            this.param = param;
        }

        protected IStatus run(IProgressMonitor monitor) {
            TcpProxy tcp = TcpProxy.getTcpProxy(ErrorSummaryComposite.this.serverId);
            Pack p = null;
            try {
                try {
                    p = tcp.getSingle("LOAD_SERVICE_ERROR_SUMMARY", (Pack)this.param);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    IStatus iStatus = Status.CANCEL_STATUS;
                    TcpProxy.putTcpProxy(tcp);
                    return iStatus;
                }
            }
            finally {
                TcpProxy.putTcpProxy(tcp);
            }
            if (p != null) {
                final ArrayList<ErrorData> list = new ArrayList<ErrorData>();
                MapPack m = (MapPack)p;
                ListValue errorLv = m.getList("error");
                ListValue serviceLv = m.getList("service");
                ListValue messageLv = m.getList("message");
                ListValue countLv = m.getList("count");
                ListValue txidLv = m.getList("txid");
                ListValue sqlLv = m.getList("sql");
                ListValue apiLv = m.getList("apicall");
                ListValue stackLv = m.getList("fullstack");
                int i = 0;
                while (i < errorLv.size()) {
                    ErrorData data = new ErrorData();
                    data.error = errorLv.getInt(i);
                    data.service = serviceLv.getInt(i);
                    data.message = messageLv.getInt(i);
                    data.count = countLv.getInt(i);
                    data.txid = txidLv.getLong(i);
                    data.sql = sqlLv.getInt(i);
                    data.apicall = apiLv.getInt(i);
                    data.fullstack = stackLv.getInt(i);
                    list.add(data);
                    ++i;
                }
                TextProxy.error.load(ErrorSummaryComposite.this.date, errorLv, ErrorSummaryComposite.this.serverId);
                TextProxy.service.load(ErrorSummaryComposite.this.date, serviceLv, ErrorSummaryComposite.this.serverId);
                TextProxy.error.load(ErrorSummaryComposite.this.date, messageLv, ErrorSummaryComposite.this.serverId);
                TextProxy.sql.load(ErrorSummaryComposite.this.date, sqlLv, ErrorSummaryComposite.this.serverId);
                TextProxy.apicall.load(ErrorSummaryComposite.this.date, apiLv, ErrorSummaryComposite.this.serverId);
                TextProxy.error.load(ErrorSummaryComposite.this.date, stackLv, ErrorSummaryComposite.this.serverId);
                ExUtil.exec((Composite)ErrorSummaryComposite.this.viewer.getTable(), new Runnable(){

                    @Override
                    public void run() {
                        ((LoadErrorSummaryJob)LoadErrorSummaryJob.this).ErrorSummaryComposite.this.viewer.setInput((Object)list);
                    }
                });
            }
            return Status.OK_STATUS;
        }
    }

    class LoadLongdayErrorSummaryJob
    extends Job {
        MapPack param;
        long stime;
        long etime;

        public LoadLongdayErrorSummaryJob(MapPack param, long stime, long etime) {
            super("Loading...");
            this.param = param;
            this.stime = stime;
            this.etime = etime;
        }

        protected IStatus run(IProgressMonitor monitor) {
            TcpProxy tcp = TcpProxy.getTcpProxy(ErrorSummaryComposite.this.serverId);
            ArrayList<Pack> packList = new ArrayList<Pack>();
            try {
                try {
                    while (this.stime <= this.etime) {
                        String date = DateUtil.yyyymmdd((long)this.stime);
                        long lastTimestampOfDay = DateUtil.getTime((String)date, (String)"yyyyMMdd") + 86400000L - 1L;
                        this.param.put("date", date);
                        this.param.put("stime", this.stime);
                        this.param.put("etime", lastTimestampOfDay <= this.etime ? lastTimestampOfDay : this.etime);
                        packList.add(tcp.getSingle("LOAD_SERVICE_ERROR_SUMMARY", (Pack)this.param));
                        this.stime += 86400000L;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    IStatus iStatus = Status.CANCEL_STATUS;
                    TcpProxy.putTcpProxy(tcp);
                    return iStatus;
                }
            }
            finally {
                TcpProxy.putTcpProxy(tcp);
            }
            if (packList.size() > 0) {
                final HashMap<Long, ErrorData> errorDataMap = new HashMap<Long, ErrorData>();
                for (Pack p : packList) {
                    MapPack m = (MapPack)p;
                    ListValue errorLv = m.getList("error");
                    ListValue serviceLv = m.getList("service");
                    ListValue messageLv = m.getList("message");
                    ListValue countLv = m.getList("count");
                    ListValue txidLv = m.getList("txid");
                    ListValue sqlLv = m.getList("sql");
                    ListValue apiLv = m.getList("apicall");
                    ListValue stackLv = m.getList("fullstack");
                    int i = 0;
                    while (i < errorLv.size()) {
                        ErrorData data = new ErrorData();
                        data.error = errorLv.getInt(i);
                        data.service = serviceLv.getInt(i);
                        data.message = messageLv.getInt(i);
                        data.count = countLv.getInt(i);
                        data.txid = txidLv.getLong(i);
                        data.sql = sqlLv.getInt(i);
                        data.apicall = apiLv.getInt(i);
                        data.fullstack = stackLv.getInt(i);
                        long key = BitUtil.composite((int)data.error, (int)data.service);
                        if (errorDataMap.containsKey(key)) {
                            ((ErrorData)errorDataMap.get(key)).addData(data);
                        } else {
                            errorDataMap.put(key, data);
                        }
                        ++i;
                    }
                    TextProxy.error.load(ErrorSummaryComposite.this.date, errorLv, ErrorSummaryComposite.this.serverId);
                    TextProxy.service.load(ErrorSummaryComposite.this.date, serviceLv, ErrorSummaryComposite.this.serverId);
                    TextProxy.error.load(ErrorSummaryComposite.this.date, messageLv, ErrorSummaryComposite.this.serverId);
                    TextProxy.sql.load(ErrorSummaryComposite.this.date, sqlLv, ErrorSummaryComposite.this.serverId);
                    TextProxy.apicall.load(ErrorSummaryComposite.this.date, apiLv, ErrorSummaryComposite.this.serverId);
                    TextProxy.error.load(ErrorSummaryComposite.this.date, stackLv, ErrorSummaryComposite.this.serverId);
                }
                ExUtil.exec((Composite)ErrorSummaryComposite.this.viewer.getTable(), new Runnable(){

                    @Override
                    public void run() {
                        ((LoadLongdayErrorSummaryJob)LoadLongdayErrorSummaryJob.this).ErrorSummaryComposite.this.viewer.setInput(errorDataMap.values());
                    }
                });
            }
            return Status.OK_STATUS;
        }
    }
}

