/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.tags;

import java.util.ArrayList;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import scouter.client.model.TextProxy;
import scouter.client.popup.AlertNotifierDialog;
import scouter.client.sorter.TableLabelSorter;
import scouter.lang.AlertLevel;
import scouter.lang.pack.AlertPack;
import scouter.lang.pack.Pack;
import scouter.util.DateUtil;

public class AlertTableComposite
extends Composite {
    Composite parent;
    private TableViewer viewer;
    private TableColumnLayout tableColumnLayout;
    int serverId;
    String yyyymmdd;
    ArrayList<AlertColumnEnum> columnList = new ArrayList();

    public AlertTableComposite(Composite parent, int style) {
        super(parent, style);
        this.parent = this;
        this.initLayout();
    }

    private void initLayout() {
        this.parent.setLayout((Layout)new FillLayout());
        Composite comp = new Composite(this.parent, 0);
        this.tableColumnLayout = new TableColumnLayout();
        comp.setLayout((Layout)this.tableColumnLayout);
        this.viewer = new TableViewer(comp, 68352);
        this.createColumns();
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new TableLabelSorter(this.viewer));
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                StructuredSelection sel = (StructuredSelection)AlertTableComposite.this.viewer.getSelection();
                Object o = sel.getFirstElement();
                if (o instanceof AlertPack) {
                    String objName = TextProxy.object.getLoadText(AlertTableComposite.this.yyyymmdd, ((AlertPack)o).objHash, AlertTableComposite.this.serverId);
                    AlertNotifierDialog alertDialog = new AlertNotifierDialog(AlertTableComposite.this.parent.getDisplay(), AlertTableComposite.this.serverId);
                    alertDialog.setObjName(objName);
                    alertDialog.setPack((AlertPack)o);
                    alertDialog.show(AlertTableComposite.this.parent.getBounds());
                } else {
                    System.out.println(o);
                }
            }
        });
    }

    public void setInput(ArrayList<Pack> packList, int serverId, String date) {
        this.serverId = serverId;
        this.yyyymmdd = date;
        this.viewer.setInput(packList);
    }

    private void createColumns() {
        AlertColumnEnum[] alertColumnEnumArray = AlertColumnEnum.values();
        int n = alertColumnEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            AlertColumnEnum column = alertColumnEnumArray[n2];
            this.createTableViewerColumn(column.getTitle(), column.getWidth(), column.getAlignment(), column.isResizable(), column.isMoveable(), column.isNumber());
            this.columnList.add(column);
            ++n2;
        }
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableItemProvider());
    }

    private TableViewerColumn createTableViewerColumn(String title, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setAlignment(alignment);
        column.setMoveable(moveable);
        this.tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnPixelData(width, resizable));
        column.setData("isNumber", (Object)isNumber);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableLabelSorter sorter = (TableLabelSorter)AlertTableComposite.this.viewer.getComparator();
                TableColumn selectedColumn = (TableColumn)e.widget;
                sorter.setColumn(selectedColumn);
            }
        });
        return viewerColumn;
    }

    static enum AlertColumnEnum {
        TIME("TIME", 100, 131072, true, true, true),
        LEVEL("LEVEL", 70, 0x1000000, true, true, false),
        OBJECT("OBJECT", 100, 16384, true, true, false),
        TITLE("TITLE", 150, 16384, true, true, false),
        MESSAGE("MESSAGE", 250, 16384, true, true, false),
        TAGS("TAGs", 200, 16384, true, true, false);

        private final String title;
        private final int weight;
        private final int alignment;
        private final boolean resizable;
        private final boolean moveable;
        private final boolean isNumber;

        private AlertColumnEnum(String text, int weight, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
            this.title = text;
            this.weight = weight;
            this.alignment = alignment;
            this.resizable = resizable;
            this.moveable = moveable;
            this.isNumber = isNumber;
        }

        public String getTitle() {
            return this.title;
        }

        public int getAlignment() {
            return this.alignment;
        }

        public boolean isResizable() {
            return this.resizable;
        }

        public boolean isMoveable() {
            return this.moveable;
        }

        public int getWidth() {
            return this.weight;
        }

        public boolean isNumber() {
            return this.isNumber;
        }
    }

    class TableItemProvider
    implements ITableLabelProvider {
        TableItemProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof AlertPack)) {
                return null;
            }
            AlertPack p = (AlertPack)element;
            AlertColumnEnum column = AlertTableComposite.this.columnList.get(columnIndex);
            switch (column) {
                case TIME: {
                    return DateUtil.format((long)p.time, (String)"HH:mm:ss.SSS");
                }
                case LEVEL: {
                    return AlertLevel.getName((byte)p.level);
                }
                case OBJECT: {
                    return TextProxy.object.getLoadText(AlertTableComposite.this.yyyymmdd, p.objHash, AlertTableComposite.this.serverId);
                }
                case TITLE: {
                    return p.title;
                }
                case MESSAGE: {
                    return p.message;
                }
                case TAGS: {
                    return p.tags.toString();
                }
            }
            return null;
        }
    }
}

