/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.tags;

import java.util.ArrayList;
import java.util.Date;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import scouter.client.model.TextProxy;
import scouter.client.model.XLogData;
import scouter.client.sorter.TableLabelSorter;
import scouter.client.util.ColorUtil;
import scouter.client.xlog.actions.OpenXLogProfileJob;
import scouter.lang.pack.Pack;
import scouter.lang.pack.XLogPack;
import scouter.util.FormatUtil;
import scouter.util.Hexa32;
import scouter.util.IPUtil;

public class ServiceTableComposite
extends Composite {
    Composite parent;
    private TableViewer viewer;
    private TableColumnLayout tableColumnLayout;
    int serverId;
    String yyyymmdd;
    ArrayList<XLogColumnEnum> columnList = new ArrayList();

    public ServiceTableComposite(Composite parent, int style) {
        super(parent, style);
        this.parent = this;
        this.initLayout();
    }

    private void initLayout() {
        this.parent.setLayout((Layout)new FillLayout());
        Composite comp = new Composite(this.parent, 0);
        this.tableColumnLayout = new TableColumnLayout();
        comp.setLayout((Layout)this.tableColumnLayout);
        this.viewer = new TableViewer(comp, 68352);
        this.createColumns();
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new TableLabelSorter(this.viewer));
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                StructuredSelection sel = (StructuredSelection)ServiceTableComposite.this.viewer.getSelection();
                Object o = sel.getFirstElement();
                if (o instanceof XLogPack) {
                    XLogPack data = (XLogPack)o;
                    XLogData d = new XLogData(data, ServiceTableComposite.this.serverId);
                    d.objName = TextProxy.object.getLoadText(ServiceTableComposite.this.yyyymmdd, data.objHash, ServiceTableComposite.this.serverId);
                    d.serviceName = TextProxy.service.getLoadText(ServiceTableComposite.this.yyyymmdd, data.service, ServiceTableComposite.this.serverId);
                    new OpenXLogProfileJob(ServiceTableComposite.this.getDisplay(), d, ServiceTableComposite.this.serverId).schedule();
                } else {
                    System.out.println(o);
                }
            }
        });
    }

    public void setInput(ArrayList<Pack> packList, int serverId, String date) {
        this.serverId = serverId;
        this.yyyymmdd = date;
        ArrayList<Integer> serverHashes = new ArrayList<Integer>(packList.size());
        for (Pack p : packList) {
            XLogPack xp = (XLogPack)p;
            serverHashes.add(xp.service);
        }
        TextProxy.service.load(this.yyyymmdd, serverHashes, serverId);
        this.viewer.setInput(packList);
    }

    private void createColumns() {
        XLogColumnEnum[] xLogColumnEnumArray = XLogColumnEnum.values();
        int n = xLogColumnEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            XLogColumnEnum column = xLogColumnEnumArray[n2];
            this.createTableViewerColumn(column.getTitle(), column.getWidth(), column.getAlignment(), column.isResizable(), column.isMoveable(), column.isNumber());
            this.columnList.add(column);
            ++n2;
        }
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableItemProvider());
    }

    private TableViewerColumn createTableViewerColumn(String title, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setAlignment(alignment);
        column.setMoveable(moveable);
        this.tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnPixelData(width, resizable));
        column.setData("isNumber", (Object)isNumber);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableLabelSorter sorter = (TableLabelSorter)ServiceTableComposite.this.viewer.getComparator();
                TableColumn selectedColumn = (TableColumn)e.widget;
                sorter.setColumn(selectedColumn);
            }
        });
        return viewerColumn;
    }

    class TableItemProvider
    implements ITableLabelProvider,
    IColorProvider {
        TableItemProvider() {
        }

        public Color getForeground(Object element) {
            if (element instanceof XLogPack) {
                XLogPack d = (XLogPack)element;
                if (d.error != 0) {
                    return ColorUtil.getInstance().getColor("red");
                }
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof XLogPack)) {
                return null;
            }
            XLogPack p = (XLogPack)element;
            XLogColumnEnum column = ServiceTableComposite.this.columnList.get(columnIndex);
            switch (column) {
                case OBJECT: {
                    return TextProxy.object.getLoadText(ServiceTableComposite.this.yyyymmdd, p.objHash, ServiceTableComposite.this.serverId);
                }
                case ELAPSED: {
                    return FormatUtil.print((Object)p.elapsed, (String)"#,##0");
                }
                case SERVICE: {
                    return TextProxy.service.getLoadText(ServiceTableComposite.this.yyyymmdd, p.service, ServiceTableComposite.this.serverId);
                }
                case START_TIME: {
                    return FormatUtil.print((Object)new Date(p.endTime - (long)p.elapsed), (String)"HH:mm:ss.SSS");
                }
                case END_TIME: {
                    return FormatUtil.print((Object)new Date(p.endTime), (String)"HH:mm:ss.SSS");
                }
                case TX_ID: {
                    return Hexa32.toString32((long)p.txid);
                }
                case CPU: {
                    return FormatUtil.print((Object)p.cpu, (String)"#,##0");
                }
                case SQL_COUNT: {
                    return FormatUtil.print((Object)p.sqlCount, (String)"#,##0");
                }
                case SQL_TIME: {
                    return FormatUtil.print((Object)p.sqlTime, (String)"#,##0");
                }
                case KBYTES: {
                    return FormatUtil.print((Object)p.kbytes, (String)"#,##0");
                }
                case IP: {
                    return IPUtil.toString((byte[])p.ipaddr);
                }
                case ERROR: {
                    return p.error == 0 ? "" : TextProxy.error.getLoadText(ServiceTableComposite.this.yyyymmdd, p.error, ServiceTableComposite.this.serverId);
                }
                case GX_ID: {
                    return Hexa32.toString32((long)p.gxid);
                }
            }
            return null;
        }
    }

    static enum XLogColumnEnum {
        OBJECT("Object", 150, 16384, true, true, false),
        ELAPSED("Elapsed", 50, 131072, true, true, true),
        SERVICE("Service", 150, 16384, true, true, false),
        START_TIME("StartTime", 100, 0x1000000, true, true, true),
        END_TIME("EndTime", 100, 0x1000000, true, true, true),
        TX_ID("Txid", 30, 16384, true, true, false),
        CPU("Cpu", 50, 131072, true, true, true),
        SQL_COUNT("SQL Count", 50, 131072, true, true, true),
        SQL_TIME("SQL Time", 50, 131072, true, true, true),
        KBYTES("KBytes", 50, 131072, true, true, true),
        IP("IP", 100, 16384, true, true, false),
        ERROR("Error", 50, 16384, true, true, false),
        GX_ID("Gxid", 30, 16384, true, true, false);

        private final String title;
        private final int weight;
        private final int alignment;
        private final boolean resizable;
        private final boolean moveable;
        private final boolean isNumber;

        private XLogColumnEnum(String text, int width, int alignment, boolean resizable, boolean moveable, boolean isNumber) {
            this.title = text;
            this.weight = width;
            this.alignment = alignment;
            this.resizable = resizable;
            this.moveable = moveable;
            this.isNumber = isNumber;
        }

        public String getTitle() {
            return this.title;
        }

        public int getAlignment() {
            return this.alignment;
        }

        public boolean isResizable() {
            return this.resizable;
        }

        public boolean isMoveable() {
            return this.moveable;
        }

        public int getWidth() {
            return this.weight;
        }

        public boolean isNumber() {
            return this.isNumber;
        }
    }
}

