/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.tags;

import java.util.ArrayList;
import java.util.List;
import scouter.client.model.TextProxy;
import scouter.lang.AlertLevel;
import scouter.lang.constants.TagConstants;
import scouter.lang.value.DecimalValue;
import scouter.lang.value.ListValue;
import scouter.lang.value.TextHashValue;
import scouter.lang.value.TextValue;
import scouter.lang.value.Value;
import scouter.util.CastUtil;
import scouter.util.HashUtil;

public class TagCountUtil {
    public static List<String> loadTagString(int serverId, String date, List<Value> vList, String tagName) {
        ArrayList<String> resultList = new ArrayList<String>();
        if (vList.size() == 0) {
            return resultList;
        }
        Value sample = vList.get(0);
        switch (sample.getValueType()) {
            case 51: {
                ListValue lv = new ListValue();
                for (Value v : vList) {
                    lv.add((long)CastUtil.cint((Object)v.toJavaObject()));
                }
                if (tagName.equals("object")) {
                    TextProxy.object.load(date, lv, serverId);
                    int i = 0;
                    while (i < lv.size()) {
                        resultList.add(TextProxy.object.getText(lv.getInt(i)));
                        ++i;
                    }
                } else if (TagConstants.serviceHashGroup.hasKey(tagName)) {
                    TextProxy.service.load(date, lv, serverId);
                    int i = 0;
                    while (i < lv.size()) {
                        resultList.add(TextProxy.service.getText(lv.getInt(i)));
                        ++i;
                    }
                } else if (tagName.equals("user-agent")) {
                    TextProxy.userAgent.load(date, lv, serverId);
                    int i = 0;
                    while (i < lv.size()) {
                        resultList.add(TextProxy.userAgent.getText(lv.getInt(i)));
                        ++i;
                    }
                } else if (tagName.equals("group")) {
                    TextProxy.group.load(date, lv, serverId);
                    int i = 0;
                    while (i < lv.size()) {
                        resultList.add(TextProxy.group.getText(lv.getInt(i)));
                        ++i;
                    }
                } else if (tagName.equals("city")) {
                    TextProxy.city.load(date, lv, serverId);
                    int i = 0;
                    while (i < lv.size()) {
                        resultList.add(TextProxy.city.getText(lv.getInt(i)));
                        ++i;
                    }
                } else if (tagName.equals("referer")) {
                    TextProxy.referer.load(date, lv, serverId);
                    int i = 0;
                    while (i < lv.size()) {
                        resultList.add(TextProxy.referer.getText(lv.getInt(i)));
                        ++i;
                    }
                } else if (tagName.equals("error")) {
                    TextProxy.error.load(date, lv, serverId);
                    int i = 0;
                    while (i < lv.size()) {
                        resultList.add(TextProxy.error.getText(lv.getInt(i)));
                        ++i;
                    }
                } else if (tagName.equals("login")) {
                    TextProxy.login.load(date, lv, serverId);
                    int i = 0;
                    while (i < lv.size()) {
                        resultList.add(TextProxy.login.getText(lv.getInt(i)));
                        ++i;
                    }
                } else {
                    if (!tagName.equals("desc")) break;
                    TextProxy.desc.load(date, lv, serverId);
                    int i = 0;
                    while (i < lv.size()) {
                        resultList.add(TextProxy.desc.getText(lv.getInt(i)));
                        ++i;
                    }
                }
                break;
            }
            case 20: {
                ListValue lvDecimal = new ListValue();
                for (Value v : vList) {
                    lvDecimal.add((long)CastUtil.cint((Object)v.toJavaObject()));
                }
                if (tagName.equals("level")) {
                    for (Value v : vList) {
                        resultList.add(AlertLevel.getName((byte)((byte)((DecimalValue)v).value)));
                    }
                } else if (tagName.equals("login")) {
                    TextProxy.login.load(date, lvDecimal, serverId);
                    int i = 0;
                    while (i < lvDecimal.size()) {
                        resultList.add(TextProxy.login.getText(lvDecimal.getInt(i)));
                        ++i;
                    }
                } else if (tagName.equals("desc")) {
                    TextProxy.login.load(date, lvDecimal, serverId);
                    int i = 0;
                    while (i < lvDecimal.size()) {
                        resultList.add(TextProxy.login.getText(lvDecimal.getInt(i)));
                        ++i;
                    }
                } else {
                    for (Value v : vList) {
                        resultList.add(CastUtil.cString((Object)v.toJavaObject()));
                    }
                }
                break;
            }
            case 61: {
                for (Value v : vList) {
                    resultList.add(v.toString());
                }
                break;
            }
            case 50: {
                for (Value v : vList) {
                    resultList.add(v.toString());
                }
                break;
            }
            default: {
                for (Value v : vList) {
                    resultList.add(v.toString());
                }
            }
        }
        return resultList;
    }

    public static Value convertTagToValue(String tagName, String tagValue) {
        if (tagName.equals("object") || tagName.equals("service") || tagName.equals("service-time-sum") || tagName.equals("service-kbyte-sum") || tagName.equals("service-error-sum") || tagName.equals("group") || tagName.equals("user-agent") || tagName.equals("referer") || tagName.equals("city") || tagName.equals("error") || TagConstants.serviceHashGroup.hasKey(tagName)) {
            return new TextHashValue(tagValue);
        }
        if (tagName.equals("level")) {
            return new DecimalValue((long)AlertLevel.getValue((String)tagValue));
        }
        if (tagName.equals("login") || tagName.equals("desc")) {
            return new DecimalValue((long)HashUtil.hash((String)tagValue));
        }
        return new TextValue(tagValue);
    }
}

