/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.tags;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.csstudio.swt.xygraph.linearscale.Range;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.model.CounterColorManager;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.popup.CalendarDialog;
import scouter.client.tags.AlertTableComposite;
import scouter.client.tags.ServiceTableComposite;
import scouter.client.tags.TagCount;
import scouter.client.tags.TagCountUtil;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.ExUtil;
import scouter.client.util.ScouterUtil;
import scouter.io.DataInputX;
import scouter.lang.pack.AlertPack;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.pack.XLogPack;
import scouter.lang.value.BooleanValue;
import scouter.lang.value.ListValue;
import scouter.lang.value.MapValue;
import scouter.lang.value.NullValue;
import scouter.lang.value.Value;
import scouter.util.DateUtil;
import scouter.util.FormatUtil;
import scouter.util.LinkedMap;
import scouter.util.StringUtil;

public class TagCountView
extends ViewPart {
    public static final String ID = TagCountView.class.getName();
    private static final String DEFAULT_TAG_GROUP = "service";
    private static final int LIMIT_PER_PAGE = 100;
    int serverId;
    Composite parent;
    Combo tagGroupCombo;
    Label dateLbl;
    SashForm graphSash;
    FigureCanvas totalCanvas;
    XYGraph totalGraph;
    Trace totalTrace;
    Label rangeLbl;
    Label dataRangeLbl;
    Button leftBtn;
    Button rightBtn;
    FigureCanvas cntCanvas;
    XYGraph cntGraph;
    HashMap<String, Trace> cntTraceMap = new HashMap();
    LinkedMap<String, float[]> valueMap = new LinkedMap();
    private String objType;
    private String date;
    TreeMap<String, TagCount> nameTree = new TreeMap();
    Tree tagNameTree;
    CheckboxTreeViewer treeViewer;
    Table tagValueTable;
    SashForm dataTableSash;
    ServiceTableComposite serviceTable;
    AlertTableComposite alertTable;
    int lastWidth = 1;
    double rangeX1;
    double rangeX2;
    boolean zoomMode = false;
    int lastIndex;
    int lastSize;
    long firstTime;
    long lastTime;
    long firstTxid;
    long lastTxid;

    public void createPartControl(Composite parent) {
        this.parent = parent;
        parent.setLayout((Layout)new GridLayout(1, true));
        Composite menuComp = new Composite(parent, 2048);
        menuComp.setLayoutData((Object)new GridData(4, 4, true, false));
        menuComp.setLayout((Layout)new GridLayout(4, false));
        this.tagGroupCombo = new Combo(menuComp, 2056);
        GridData gd = new GridData(131072, 4, true, true);
        gd.widthHint = 100;
        this.tagGroupCombo.setLayoutData((Object)gd);
        this.tagGroupCombo.setBackground(ColorUtil.getInstance().getColor(1));
        this.tagGroupCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TagCountView.this.removeTagCountAll();
                TagCountView.this.loadTagNames(TagCountView.this.tagGroupCombo.getText());
                TagCountView.this.loadTotalCount(TagCountView.this.tagGroupCombo.getText());
                TagCountView.this.openDataTable();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite dateComp = new Composite(menuComp, 2048);
        dateComp.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        dateComp.setLayout((Layout)new RowLayout());
        dateComp.setBackground(ColorUtil.getInstance().getColor(1));
        dateComp.setBackgroundMode(2);
        this.dateLbl = new Label(dateComp, 0x1000000);
        this.dateLbl.setLayoutData((Object)new RowData(160, -1));
        this.dateLbl.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                CalendarDialog dialog = new CalendarDialog(TagCountView.this.getViewSite().getShell().getDisplay(), new CalendarDialog.ILoadCalendarDialog(){

                    @Override
                    public void onPressedOk(long startTime, long endTime) {
                    }

                    @Override
                    public void onPressedCancel() {
                    }

                    @Override
                    public void onPressedOk(String date) {
                        TagCountView.this.setInput(date, (this).TagCountView.this.objType);
                    }
                });
                dialog.show(-1, -1, DateUtil.yyyymmdd((String)TagCountView.this.date));
            }
        });
        Button dayBtn = new Button(menuComp, 8);
        gd = new GridData(4, 4, false, true);
        gd.widthHint = 70;
        dayBtn.setLayoutData((Object)gd);
        dayBtn.setText("&24H");
        dayBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TagCountView.this.rangeX1 = DateUtil.yyyymmdd((String)TagCountView.this.date);
                TagCountView.this.rangeX2 = TagCountView.this.rangeX1 + 8.64E7 - 1.0;
                TagCountView.this.totalGraph.primaryXAxis.setRange(TagCountView.this.rangeX1, TagCountView.this.rangeX2);
                TagCountView.this.cntGraph.primaryXAxis.setRange(TagCountView.this.rangeX1, TagCountView.this.rangeX2);
                TagCountView.this.totalCanvas.notifyListeners(11, new Event());
                TagCountView.this.cntCanvas.notifyListeners(11, new Event());
                TagCountView.this.adjustYAxisRange(TagCountView.this.totalGraph, (CircularBufferDataProvider)TagCountView.this.totalTrace.getDataProvider());
                TagCountView.this.adjustYAxisRange(TagCountView.this.cntGraph, TagCountView.this.cntTraceMap.values());
                TagCountView.this.updateTextDate();
            }
        });
        Button resetBtn = new Button(menuComp, 8);
        gd = new GridData(4, 4, false, true);
        gd.widthHint = 70;
        resetBtn.setLayoutData((Object)gd);
        resetBtn.setText("&Reset");
        resetBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TagCountView.this.removeTagCountAll();
                TagCountView.this.setInput(TagCountView.this.date, TagCountView.this.objType);
            }
        });
        SashForm sashForm = new SashForm(parent, 512);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.graphSash = new SashForm((Composite)sashForm, 256);
        Composite totalComp = new Composite((Composite)this.graphSash, 2048);
        totalComp.setBackground(ColorUtil.getInstance().getColor(1));
        totalComp.setBackgroundMode(2);
        totalComp.setLayout((Layout)new FillLayout());
        this.totalCanvas = new FigureCanvas(totalComp);
        this.totalCanvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.totalCanvas.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent arg0) {
            }

            public void controlResized(ControlEvent arg0) {
                Rectangle r = TagCountView.this.totalCanvas.getClientArea();
                TagCountView.this.totalGraph.setSize(r.width, r.height);
                if (TagCountView.this.zoomMode) {
                    double gap = TagCountView.this.rangeX2 - TagCountView.this.rangeX1;
                    double noOfMin = gap / 60000.0;
                    double lineWidth = ((double)r.width - gap / 60000.0) / noOfMin * 0.9;
                    TagCountView.this.lastWidth = lineWidth < 1.0 ? 1 : (int)lineWidth;
                    TagCountView.this.totalTrace.setLineWidth(TagCountView.this.lastWidth);
                }
            }
        });
        this.totalCanvas.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                long stime = (long)TagCountView.this.totalGraph.primaryXAxis.getPositionValue(e.x, false);
                if ((double)stime < TagCountView.this.rangeX1 || (double)stime > TagCountView.this.rangeX2) {
                    return;
                }
                stime = stime / 60000L * 60000L;
                long etime = stime + 60000L - 1L;
                TagCountView.this.loadInitData(TagCountView.this.tagGroupCombo.getText(), stime, etime, null);
            }
        });
        this.totalGraph = new XYGraph();
        this.totalGraph.setShowLegend(true);
        this.totalGraph.setShowTitle(false);
        this.totalCanvas.setContents((IFigure)this.totalGraph);
        this.totalGraph.primaryXAxis.setDateEnabled(true);
        this.totalGraph.primaryXAxis.setShowMajorGrid(true);
        this.totalGraph.primaryYAxis.setAutoScale(true);
        this.totalGraph.primaryYAxis.setShowMajorGrid(true);
        this.totalGraph.primaryXAxis.setFormatPattern("HH:mm");
        this.totalGraph.primaryYAxis.setFormatPattern("#,##0");
        this.totalGraph.primaryXAxis.setTitle("");
        this.totalGraph.primaryYAxis.setTitle("");
        CircularBufferDataProvider totalProvider = new CircularBufferDataProvider(true);
        totalProvider.setBufferSize(1440);
        totalProvider.setCurrentXDataArray(new double[0]);
        totalProvider.setCurrentYDataArray(new double[0]);
        this.totalTrace = new Trace("Total", this.totalGraph.primaryXAxis, this.totalGraph.primaryYAxis, totalProvider);
        this.totalTrace.setPointStyle(Trace.PointStyle.NONE);
        this.totalTrace.setTraceType(Trace.TraceType.BAR);
        this.totalTrace.setAreaAlpha(255);
        this.totalTrace.setLineWidth(this.lastWidth);
        this.totalTrace.setTraceColor(ColorUtil.getInstance().getColor(10));
        this.totalGraph.addTrace(this.totalTrace);
        ScouterUtil.addHorizontalRangeListener(this.totalGraph.getPlotArea(), new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object o = evt.getNewValue();
                if (o != null && o instanceof Range) {
                    double x2;
                    double x1 = ((Range)o).getLower();
                    if (Math.abs(x1 - (x2 = ((Range)o).getUpper())) < 300000.0) {
                        return;
                    }
                    if (x1 < x2) {
                        TagCountView.this.rangeX1 = x1;
                        TagCountView.this.rangeX2 = x2;
                    } else {
                        TagCountView.this.rangeX1 = x2;
                        TagCountView.this.rangeX2 = x1;
                    }
                    TagCountView.this.totalGraph.primaryXAxis.setRange(TagCountView.this.rangeX1, TagCountView.this.rangeX2);
                    TagCountView.this.zoomMode = true;
                    TagCountView.this.totalCanvas.notifyListeners(11, new Event());
                    TagCountView.this.adjustYAxisRange(TagCountView.this.totalGraph, (CircularBufferDataProvider)TagCountView.this.totalTrace.getDataProvider());
                    TagCountView.this.updateTextDate();
                }
            }
        }, false);
        Composite cntGraphComp = new Composite((Composite)this.graphSash, 2048);
        cntGraphComp.setBackground(ColorUtil.getInstance().getColor(1));
        cntGraphComp.setBackgroundMode(2);
        cntGraphComp.setLayout((Layout)new FillLayout());
        this.cntCanvas = new FigureCanvas(cntGraphComp);
        this.cntCanvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.cntCanvas.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent arg0) {
            }

            public void controlResized(ControlEvent arg0) {
                Rectangle r = TagCountView.this.cntCanvas.getClientArea();
                TagCountView.this.cntGraph.setSize(r.width, r.height);
                if (TagCountView.this.zoomMode) {
                    double gap = TagCountView.this.rangeX2 - TagCountView.this.rangeX1;
                    double noOfMin = gap / 60000.0;
                    double lineWidth = ((double)r.width - gap / 60000.0) / noOfMin * 0.9;
                    TagCountView.this.lastWidth = lineWidth < 1.0 ? 1 : (int)lineWidth;
                    for (Trace t : TagCountView.this.cntTraceMap.values()) {
                        t.setLineWidth(TagCountView.this.lastWidth);
                    }
                }
            }
        });
        this.cntCanvas.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                long stime = (long)TagCountView.this.cntGraph.primaryXAxis.getPositionValue(e.x, false);
                if ((double)stime < TagCountView.this.rangeX1 || (double)stime > TagCountView.this.rangeX2) {
                    return;
                }
                stime = stime / 60000L * 60000L;
                long etime = stime + 60000L - 1L;
                TagCountView.this.loadInitData(TagCountView.this.tagGroupCombo.getText(), stime, etime, TagCountView.this.makeFilterMv());
            }
        });
        this.cntGraph = new XYGraph();
        this.cntGraph.setShowLegend(true);
        this.cntGraph.setShowTitle(false);
        this.cntCanvas.setContents((IFigure)this.cntGraph);
        this.cntGraph.primaryXAxis.setDateEnabled(true);
        this.cntGraph.primaryXAxis.setShowMajorGrid(true);
        this.cntGraph.primaryYAxis.setAutoScale(true);
        this.cntGraph.primaryYAxis.setShowMajorGrid(true);
        this.cntGraph.primaryXAxis.setFormatPattern("HH:mm");
        this.cntGraph.primaryYAxis.setFormatPattern("#,##0");
        this.cntGraph.primaryXAxis.setTitle("");
        this.cntGraph.primaryYAxis.setTitle("");
        ScouterUtil.addHorizontalRangeListener(this.cntGraph.getPlotArea(), new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object o = evt.getNewValue();
                if (o != null && o instanceof Range) {
                    double x2;
                    double x1 = ((Range)o).getLower();
                    if (Math.abs(x1 - (x2 = ((Range)o).getUpper())) < 300000.0) {
                        return;
                    }
                    if (x1 < x2) {
                        TagCountView.this.rangeX1 = x1;
                        TagCountView.this.rangeX2 = x2;
                    } else {
                        TagCountView.this.rangeX1 = x2;
                        TagCountView.this.rangeX2 = x1;
                    }
                    TagCountView.this.cntGraph.primaryXAxis.setRange(TagCountView.this.rangeX1, TagCountView.this.rangeX2);
                    TagCountView.this.zoomMode = true;
                    TagCountView.this.cntCanvas.notifyListeners(11, new Event());
                    TagCountView.this.adjustYAxisRange(TagCountView.this.cntGraph, TagCountView.this.cntTraceMap.values());
                    TagCountView.this.updateTextDate();
                }
            }
        }, false);
        this.graphSash.setWeights(new int[]{1, 1});
        this.graphSash.setMaximizedControl((Control)totalComp);
        Composite downSash = new Composite((Composite)sashForm, 0);
        downSash.setLayout((Layout)new GridLayout(2, true));
        Composite treeComp = new Composite(downSash, 2048);
        treeComp.setBackground(ColorUtil.getInstance().getColor(1));
        gd = new GridData(4, 4, true, true);
        treeComp.setLayoutData((Object)gd);
        treeComp.setLayout((Layout)new GridLayout(1, true));
        Composite innerTreeComp = new Composite(treeComp, 0);
        innerTreeComp.setBackground(ColorUtil.getInstance().getColor(1));
        innerTreeComp.setLayoutData((Object)new GridData(4, 4, true, true));
        TreeColumnLayout treeColumnLayout = new TreeColumnLayout();
        innerTreeComp.setLayout((Layout)treeColumnLayout);
        this.treeViewer = new CheckboxTreeViewer(innerTreeComp, 0x10000B00);
        this.tagNameTree = this.treeViewer.getTree();
        this.tagNameTree.setHeaderVisible(true);
        this.tagNameTree.setLinesVisible(true);
        this.treeViewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getElement() instanceof TagCount) {
                    TagCount tc = (TagCount)event.getElement();
                    if (StringUtil.isNotEmpty((String)tc.tagName)) {
                        if (event.getChecked()) {
                            TagCountView.this.loadTagCount(TagCountView.this.tagGroupCombo.getText(), tc.tagName, tc.value);
                            TagCountView.this.treeViewer.setGrayChecked((Object)TagCountView.this.nameTree.get(tc.tagName), true);
                        } else {
                            Object[] objects;
                            TagCountView.this.removeTagCount(tc.value);
                            Object[] objectArray = objects = TagCountView.this.treeViewer.getCheckedElements();
                            int n = objects.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object o = objectArray[n2];
                                TagCount checked = (TagCount)o;
                                if (tc.tagName.equals(checked.tagName)) {
                                    return;
                                }
                                ++n2;
                            }
                            TagCountView.this.treeViewer.setGrayChecked((Object)TagCountView.this.nameTree.get(tc.tagName), false);
                        }
                    }
                }
            }
        });
        TreeColumn nameColumn = new TreeColumn(this.tagNameTree, 16384);
        nameColumn.setText("Name");
        TreeColumn cntColumn = new TreeColumn(this.tagNameTree, 16384);
        cntColumn.setText("Count");
        treeColumnLayout.setColumnData((Widget)nameColumn, (ColumnLayoutData)new ColumnWeightData(68));
        treeColumnLayout.setColumnData((Widget)cntColumn, (ColumnLayoutData)new ColumnWeightData(22));
        this.treeViewer.setInput(this.nameTree);
        Composite rightTablecomp = new Composite(downSash, 2048);
        rightTablecomp.setBackground(ColorUtil.getInstance().getColor(1));
        rightTablecomp.setBackgroundMode(2);
        rightTablecomp.setLayoutData((Object)new GridData(4, 4, true, true));
        rightTablecomp.setLayout((Layout)new GridLayout(1, true));
        this.rangeLbl = new Label(rightTablecomp, 0x1000000);
        gd = new GridData(0x1000000, 0x1000000, true, false);
        this.rangeLbl.setLayoutData((Object)gd);
        FontData fontData = this.rangeLbl.getFont().getFontData()[0];
        Font font = new Font((Device)this.getViewSite().getShell().getDisplay(), new FontData(fontData.getName(), fontData.getHeight(), 1));
        this.rangeLbl.setFont(font);
        this.rangeLbl.setAlignment(0x1000000);
        this.rangeLbl.setText("00:00 ~ 00:00");
        this.dataTableSash = new SashForm(rightTablecomp, 256);
        this.dataTableSash.setLayoutData((Object)new GridData(4, 4, true, true));
        this.serviceTable = new ServiceTableComposite((Composite)this.dataTableSash, 0);
        this.alertTable = new AlertTableComposite((Composite)this.dataTableSash, 0);
        Composite tableInfoComp = new Composite(rightTablecomp, 0);
        gd = new GridData(4, 4, true, false);
        tableInfoComp.setLayoutData((Object)gd);
        tableInfoComp.setLayout((Layout)new GridLayout(3, false));
        this.leftBtn = new Button(tableInfoComp, 8);
        gd = new GridData(131072, 0x1000000, true, false);
        this.leftBtn.setLayoutData((Object)gd);
        this.leftBtn.setText("<");
        this.leftBtn.setEnabled(false);
        this.leftBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TagCountView.this.graphSash.getMaximizedControl() == TagCountView.this.cntCanvas.getParent()) {
                    TagCountView.this.loadLeftData(TagCountView.this.tagGroupCombo.getText(), TagCountView.this.makeFilterMv());
                } else {
                    TagCountView.this.loadLeftData(TagCountView.this.tagGroupCombo.getText(), null);
                }
            }
        });
        this.dataRangeLbl = new Label(tableInfoComp, 131072);
        gd = new GridData(0x1000000, 0x1000000, false, false);
        gd.widthHint = 100;
        this.dataRangeLbl.setLayoutData((Object)gd);
        this.dataRangeLbl.setAlignment(0x1000000);
        this.rightBtn = new Button(tableInfoComp, 8);
        gd = new GridData(16384, 0x1000000, true, false);
        this.rightBtn.setLayoutData((Object)gd);
        this.rightBtn.setText(">");
        this.rightBtn.setEnabled(false);
        this.rightBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TagCountView.this.graphSash.getMaximizedControl() == TagCountView.this.cntCanvas.getParent()) {
                    TagCountView.this.loadRightData(TagCountView.this.tagGroupCombo.getText(), TagCountView.this.makeFilterMv());
                } else {
                    TagCountView.this.loadRightData(TagCountView.this.tagGroupCombo.getText(), null);
                }
            }
        });
        sashForm.setWeights(new int[]{1, 2});
        sashForm.setMaximizedControl(null);
    }

    public void setFocus() {
    }

    public void setInput(String date, String objType, int serverId) {
        this.setPartName("TagCount-" + objType);
        this.serverId = serverId;
        this.setInput(date, objType);
    }

    public void setInput(String date, String objType) {
        this.date = date;
        this.objType = objType;
        this.setTitleImage(Images.getObjectIcon(objType, true, this.serverId));
        this.openTotalGraph();
        this.rangeX1 = DateUtil.yyyymmdd((String)date);
        this.rangeX2 = this.rangeX1 + 8.64E7 - 1.0;
        this.updateTextDate();
        this.loadTagGroup();
        this.serviceTable.setInput(new ArrayList<Pack>(), this.serverId, date);
        this.alertTable.setInput(new ArrayList<Pack>(), this.serverId, date);
        this.totalCanvas.notifyListeners(11, new Event());
        this.zoomMode = false;
    }

    private void updateTextDate() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.date.substring(0, 4));
        sb.append("-");
        sb.append(this.date.substring(4, 6));
        sb.append("-");
        sb.append(this.date.substring(6, 8));
        sb.append("   ");
        sb.append(DateUtil.format((long)((long)this.rangeX1), (String)"HH:mm"));
        sb.append("~");
        sb.append(DateUtil.format((long)((long)this.rangeX2), (String)"HH:mm"));
        this.dateLbl.setText(sb.toString());
    }

    private void adjustYAxisRange(XYGraph graph, CircularBufferDataProvider provider) {
        double max = 0.0;
        int i = 0;
        while (i < provider.getSize()) {
            double y;
            Sample sample = (Sample)provider.getSample(i);
            double x = sample.getXValue();
            if (!(x < this.rangeX1) && !(x > this.rangeX2) && (y = sample.getYValue()) > max) {
                max = y;
            }
            ++i;
        }
        graph.primaryYAxis.setRange(0.0, ChartUtil.getMaxValue(max));
    }

    private void adjustYAxisRange(XYGraph graph, Collection<Trace> traceList) {
        double max = 0.0;
        for (Trace t : traceList) {
            CircularBufferDataProvider provider = (CircularBufferDataProvider)t.getDataProvider();
            int i = 0;
            while (i < provider.getSize()) {
                double y;
                Sample sample = (Sample)provider.getSample(i);
                double x = sample.getXValue();
                if (!(x < this.rangeX1) && !(x > this.rangeX2) && (y = sample.getYValue()) > max) {
                    max = y;
                }
                ++i;
            }
        }
        graph.primaryYAxis.setRange(0.0, ChartUtil.getMaxValue(max));
    }

    private void openTotalGraph() {
        if (this.graphSash.getMaximizedControl() != this.totalCanvas.getParent()) {
            this.graphSash.setMaximizedControl((Control)this.totalCanvas.getParent());
        }
    }

    private void openCountGraph() {
        if (this.graphSash.getMaximizedControl() != this.cntCanvas.getParent()) {
            this.graphSash.setMaximizedControl((Control)this.cntCanvas.getParent());
        }
    }

    private void openDataTable() {
        String tagGroup = this.tagGroupCombo.getText();
        if (DEFAULT_TAG_GROUP.equals(tagGroup)) {
            this.dataTableSash.setMaximizedControl((Control)this.serviceTable);
        } else if ("alert".equals(tagGroup)) {
            this.dataTableSash.setMaximizedControl((Control)this.alertTable);
        }
    }

    private void drawStackCountGraph() {
        for (Trace t : this.cntTraceMap.values()) {
            this.cntGraph.removeTrace(t);
        }
        this.cntTraceMap.clear();
        float[] stackedValue = new float[1440];
        LinkedMap tempMap = new LinkedMap();
        Enumeration entries = this.valueMap.entries();
        while (entries.hasMoreElements()) {
            LinkedMap.LinkedEntry entry = (LinkedMap.LinkedEntry)entries.nextElement();
            String key = (String)entry.getKey();
            float[] values = (float[])entry.getValue();
            int i = 0;
            while (i < values.length) {
                int n = i;
                stackedValue[n] = stackedValue[n] + values[i];
                ++i;
            }
            float[] copiedArray = new float[stackedValue.length];
            System.arraycopy(stackedValue, 0, copiedArray, 0, stackedValue.length);
            tempMap.putFirst((Object)key, (Object)copiedArray);
        }
        long stime = DateUtil.yyyymmdd((String)this.date);
        Enumeration entries2 = tempMap.entries();
        while (entries2.hasMoreElements()) {
            LinkedMap.LinkedEntry entry = (LinkedMap.LinkedEntry)entries2.nextElement();
            String key = (String)entry.getKey();
            float[] values = (float[])entry.getValue();
            Trace trace = this.getCountTrace(key);
            CircularBufferDataProvider provider = (CircularBufferDataProvider)trace.getDataProvider();
            provider.clearTrace();
            int i = 0;
            while (i < values.length) {
                double x = stime + (60000L * (long)i + 30000L);
                provider.addSample(new Sample(x, values[i]));
                ++i;
            }
        }
    }

    private void loadTagGroup() {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                List<Value> list;
                block7: {
                    TcpProxy tcp = TcpProxy.getTcpProxy(TagCountView.this.serverId);
                    list = null;
                    try {
                        try {
                            MapPack param = new MapPack();
                            param.put("objType", TagCountView.this.objType);
                            list = tcp.processValues("TAGCNT_DIV_NAMES", (Pack)param);
                        }
                        catch (Exception param) {
                            TcpProxy.putTcpProxy(tcp);
                            break block7;
                        }
                    }
                    catch (Throwable throwable) {
                        TcpProxy.putTcpProxy(tcp);
                        throw throwable;
                    }
                    TcpProxy.putTcpProxy(tcp);
                }
                if (list != null) {
                    final ArrayList<String> resultList = new ArrayList<String>();
                    for (Value v : list) {
                        resultList.add(v.toString());
                    }
                    ExUtil.exec((Composite)TagCountView.this.tagGroupCombo, new Runnable(){

                        @Override
                        public void run() {
                            (this).TagCountView.this.tagGroupCombo.removeAll();
                            int defaultIndex = -1;
                            int i = 0;
                            while (i < resultList.size()) {
                                String s = (String)resultList.get(i);
                                (this).TagCountView.this.tagGroupCombo.add(s);
                                if (TagCountView.DEFAULT_TAG_GROUP.equals(s)) {
                                    defaultIndex = i;
                                }
                                ++i;
                            }
                            if (defaultIndex > -1) {
                                (this).TagCountView.this.tagGroupCombo.select(defaultIndex);
                                (this).TagCountView.this.tagGroupCombo.notifyListeners(13, new Event());
                            }
                        }
                    });
                }
            }
        });
    }

    private void loadTagNames(final String tagGroup) {
        this.tagNameTree.removeAll();
        this.nameTree.clear();
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                List<Value> names;
                block8: {
                    TcpProxy tcp = TcpProxy.getTcpProxy(TagCountView.this.serverId);
                    names = null;
                    try {
                        try {
                            MapPack param = new MapPack();
                            param.put("objType", TagCountView.this.objType);
                            param.put("tagGroup", tagGroup);
                            names = tcp.processValues("TAGCNT_TAG_NAMES", (Pack)param);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TcpProxy.putTcpProxy(tcp);
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        TcpProxy.putTcpProxy(tcp);
                        throw throwable;
                    }
                    TcpProxy.putTcpProxy(tcp);
                }
                if (names != null) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (Value v : names) {
                        if ("@total".equals(v.toString())) continue;
                        list.add(v.toString());
                    }
                    int i = 0;
                    while (i < list.size()) {
                        TagCount tag = new TagCount();
                        tag.tagName = "";
                        tag.value = (String)list.get(i);
                        TagCountView.this.nameTree.put((String)list.get(i), tag);
                        ++i;
                    }
                    this.loadTagValues(tagGroup, list);
                    ExUtil.exec((Composite)TagCountView.this.tagNameTree, new Runnable(){

                        @Override
                        public void run() {
                            (this).TagCountView.this.treeViewer.refresh();
                            (this).TagCountView.this.treeViewer.setGrayedElements((this).TagCountView.this.nameTree.values().toArray());
                        }
                    });
                }
            }

            private void loadTagValues(String tagGroup2, List<String> tagNameList) {
                ArrayList dataList;
                block9: {
                    dataList = new ArrayList();
                    TcpProxy tcp = TcpProxy.getTcpProxy(TagCountView.this.serverId);
                    try {
                        try {
                            MapPack param = new MapPack();
                            param.put("objType", TagCountView.this.objType);
                            param.put("tagGroup", tagGroup2);
                            ListValue tagNameLv = param.newList("tagName");
                            for (String tagName : tagNameList) {
                                tagNameLv.add(tagName);
                            }
                            param.put("date", TagCountView.this.date);
                            tcp.process("TAGCNT_TAG_VALUES", param, new INetReader(){

                                @Override
                                public void process(DataInputX in) throws IOException {
                                    TagData data = new TagData();
                                    dataList.add(data);
                                    data.tagName = in.readText();
                                    data.totalSize = in.readInt();
                                    data.totalCnt = in.readFloat();
                                    int size = in.readInt();
                                    int i = 0;
                                    while (i < size) {
                                        Value v = in.readValue();
                                        float cnt = in.readFloat();
                                        data.addValue(v, cnt);
                                        ++i;
                                    }
                                }
                            });
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            TcpProxy.putTcpProxy(tcp);
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        TcpProxy.putTcpProxy(tcp);
                        throw throwable;
                    }
                    TcpProxy.putTcpProxy(tcp);
                }
                for (TagData data : dataList) {
                    String tagName;
                    data.strValueList = TagCountUtil.loadTagString(TagCountView.this.serverId, TagCountView.this.date, data.valueList, data.tagName);
                    tagName = data.tagName;
                    TagCount parentTag = TagCountView.this.nameTree.get(tagName);
                    if (parentTag == null) {
                        return;
                    }
                    int i = 0;
                    while (i < data.strValueList.size()) {
                        TagCount child = new TagCount();
                        child.tagName = parentTag.value;
                        child.value = data.strValueList.get(i);
                        child.count = data.cntList.get(i).floatValue();
                        parentTag.addChild(child);
                        ++i;
                    }
                    parentTag.count = data.totalCnt;
                    parentTag.value = String.valueOf(parentTag.value) + " (" + data.totalSize + ")";
                }
            }
        });
    }

    private void removeTagCountAll() {
        for (Trace t : this.cntTraceMap.values()) {
            this.cntGraph.removeTrace(t);
        }
        this.cntTraceMap.clear();
        this.valueMap.clear();
        this.cntGraph.repaint();
    }

    private void removeTagCount(String tagValue) {
        Trace t = this.cntTraceMap.get(tagValue);
        if (t == null) {
            return;
        }
        this.cntGraph.removeTrace(t);
        this.cntGraph.repaint();
        this.cntTraceMap.remove(tagValue);
        this.valueMap.remove((Object)tagValue);
        this.adjustYAxisRange(this.cntGraph, this.cntTraceMap.values());
    }

    private void loadTagCount(final String tagGroup, final String tagName, final String tagValue) {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                float[] valueArray;
                block5: {
                    TcpProxy tcp = TcpProxy.getTcpProxy(TagCountView.this.serverId);
                    valueArray = new float[1440];
                    try {
                        try {
                            MapPack param = new MapPack();
                            param.put("objType", TagCountView.this.objType);
                            param.put("tagGroup", tagGroup);
                            param.put("tagName", tagName);
                            param.put("tagValue", TagCountUtil.convertTagToValue(tagName, tagValue));
                            param.put("date", TagCountView.this.date);
                            tcp.process("TAGCNT_TAG_VALUE_DATA", param, new INetReader(){

                                @Override
                                public void process(DataInputX in) throws IOException {
                                    float[] values = in.readArray(new float[0]);
                                    int i = 0;
                                    while (i < values.length) {
                                        valueArray[i] = values[i];
                                        ++i;
                                    }
                                }
                            });
                        }
                        catch (Exception exception) {
                            TcpProxy.putTcpProxy(tcp);
                            break block5;
                        }
                    }
                    catch (Throwable throwable) {
                        TcpProxy.putTcpProxy(tcp);
                        throw throwable;
                    }
                    TcpProxy.putTcpProxy(tcp);
                }
                TagCountView.this.valueMap.put((Object)tagValue, (Object)valueArray);
                ExUtil.exec((Composite)TagCountView.this.cntCanvas, new Runnable(){

                    @Override
                    public void run() {
                        (this).TagCountView.this.cntGraph.primaryXAxis.setRange((this).TagCountView.this.rangeX1, (this).TagCountView.this.rangeX2);
                        TagCountView.this.drawStackCountGraph();
                        TagCountView.this.adjustYAxisRange((this).TagCountView.this.cntGraph, (this).TagCountView.this.cntTraceMap.values());
                        (this).TagCountView.this.cntGraph.repaint();
                        TagCountView.this.openCountGraph();
                    }
                });
            }
        });
    }

    private void loadTotalCount(final String tagGroup) {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                ArrayList valueList;
                block5: {
                    TcpProxy tcp = TcpProxy.getTcpProxy(TagCountView.this.serverId);
                    valueList = new ArrayList();
                    try {
                        try {
                            MapPack param = new MapPack();
                            param.put("tagGroup", tagGroup);
                            param.put("objType", TagCountView.this.objType);
                            param.put("tagName", "@total");
                            param.put("tagValue", (Value)NullValue.value);
                            param.put("date", TagCountView.this.date);
                            tcp.process("TAGCNT_TAG_VALUE_DATA", param, new INetReader(){

                                @Override
                                public void process(DataInputX in) throws IOException {
                                    float[] values = in.readArray(new float[0]);
                                    int i = 0;
                                    while (i < values.length) {
                                        valueList.add(Float.valueOf(values[i]));
                                        ++i;
                                    }
                                }
                            });
                        }
                        catch (Exception exception) {
                            TcpProxy.putTcpProxy(tcp);
                            break block5;
                        }
                    }
                    catch (Throwable throwable) {
                        TcpProxy.putTcpProxy(tcp);
                        throw throwable;
                    }
                    TcpProxy.putTcpProxy(tcp);
                }
                ExUtil.exec((Composite)TagCountView.this.totalCanvas, new Runnable(){

                    @Override
                    public void run() {
                        long stime = DateUtil.yyyymmdd((String)(this).TagCountView.this.date);
                        (this).TagCountView.this.totalGraph.primaryXAxis.setRange((this).TagCountView.this.rangeX1, (this).TagCountView.this.rangeX2);
                        CircularBufferDataProvider provider = (CircularBufferDataProvider)(this).TagCountView.this.totalTrace.getDataProvider();
                        provider.clearTrace();
                        int i = 0;
                        while (i < valueList.size()) {
                            double x = stime + (60000L * (long)i + 30000L);
                            float value = ((Float)valueList.get(i)).floatValue();
                            provider.addSample(new Sample(x, value));
                            ++i;
                        }
                        TagCountView.this.adjustYAxisRange((this).TagCountView.this.totalGraph, provider);
                        (this).TagCountView.this.totalGraph.repaint();
                        TagCountView.this.openTotalGraph();
                    }
                });
            }
        });
    }

    private Trace getCountTrace(String tagValue) {
        if (this.cntTraceMap.containsKey(tagValue)) {
            return this.cntTraceMap.get(tagValue);
        }
        CircularBufferDataProvider provider = new CircularBufferDataProvider(true);
        provider.setBufferSize(1440);
        provider.setCurrentXDataArray(new double[0]);
        provider.setCurrentYDataArray(new double[0]);
        Trace trace = new Trace(tagValue, this.cntGraph.primaryXAxis, this.cntGraph.primaryYAxis, provider);
        trace.setPointStyle(Trace.PointStyle.NONE);
        trace.setTraceType(Trace.TraceType.BAR);
        trace.setAreaAlpha(255);
        trace.setLineWidth(this.lastWidth);
        trace.setTraceColor(CounterColorManager.getInstance().assignColor(tagValue));
        this.cntGraph.addTrace(trace);
        this.cntTraceMap.put(tagValue, trace);
        return trace;
    }

    private MapValue makeFilterMv() {
        Object[] objects;
        MapValue filterMv = new MapValue();
        Object[] objectArray = objects = this.treeViewer.getCheckedElements();
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof TagCount) {
                TagCount tc = (TagCount)o;
                if (!StringUtil.isEmpty((String)tc.tagName)) {
                    String tagName = tc.tagName;
                    ListValue lv = filterMv.getList(tagName);
                    if (lv == null) {
                        lv = filterMv.newList(tagName);
                    }
                    lv.add(TagCountUtil.convertTagToValue(tagName, tc.value));
                }
            }
            ++n2;
        }
        return filterMv;
    }

    private void loadInitData(final String tagGroup, final long stime, final long etime, final MapValue filterMv) {
        this.lastIndex = 0;
        this.lastSize = 0;
        this.firstTime = 0L;
        this.lastTime = 0L;
        this.firstTxid = 0L;
        this.lastTxid = 0L;
        this.leftBtn.setEnabled(false);
        this.rightBtn.setEnabled(false);
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                List<Pack> list = TagCountView.this.loadData(tagGroup, stime, etime, false, null, filterMv);
                final ArrayList<Pack> result = new ArrayList<Pack>(list);
                TagCountView.this.lastIndex = TagCountView.this.lastSize = result.size();
                ExUtil.exec((Composite)TagCountView.this.dataTableSash, new Runnable(){

                    @Override
                    public void run() {
                        (this).TagCountView.this.rangeLbl.setText(String.valueOf(DateUtil.format((long)stime, (String)"HH:mm")) + " ~ " + DateUtil.format((long)(stime + 60000L), (String)"HH:mm"));
                        (this).TagCountView.this.dataRangeLbl.setText((this).TagCountView.this.lastSize > 0 ? "1 ~ " + (this).TagCountView.this.lastIndex : "0");
                        if ((this).TagCountView.this.lastIndex == 100) {
                            (this).TagCountView.this.rightBtn.setEnabled(true);
                        }
                        if (TagCountView.DEFAULT_TAG_GROUP.equals(tagGroup)) {
                            if ((this).TagCountView.this.lastSize > 0) {
                                Pack p = (Pack)result.get(0);
                                XLogPack xp = (XLogPack)p;
                                (this).TagCountView.this.firstTime = xp.endTime;
                                (this).TagCountView.this.firstTxid = xp.txid;
                                p = (Pack)result.get(result.size() - 1);
                                xp = (XLogPack)p;
                                (this).TagCountView.this.lastTime = xp.endTime;
                                (this).TagCountView.this.lastTxid = xp.txid;
                            }
                            (this).TagCountView.this.serviceTable.setInput(result, (this).TagCountView.this.serverId, tagGroup);
                        } else if ("alert".equals(tagGroup)) {
                            if ((this).TagCountView.this.lastSize > 0) {
                                Pack p = (Pack)result.get(0);
                                AlertPack xp = (AlertPack)p;
                                (this).TagCountView.this.firstTime = xp.time;
                                p = (Pack)result.get(result.size() - 1);
                                xp = (AlertPack)p;
                                (this).TagCountView.this.lastTime = xp.time;
                            }
                            (this).TagCountView.this.alertTable.setInput(result, (this).TagCountView.this.serverId, tagGroup);
                        }
                    }
                });
            }
        });
    }

    private void loadRightData(final String tagGroup, final MapValue filterMv) {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                long stime = TagCountView.this.lastTime;
                long etime = (stime + 60000L) / 60000L * 60000L - 1L;
                MapPack extra = new MapPack();
                if (TagCountView.DEFAULT_TAG_GROUP.equals(tagGroup)) {
                    extra.put("txid", TagCountView.this.lastTxid);
                }
                List<Pack> list = TagCountView.this.loadData(tagGroup, stime, etime, false, extra, filterMv);
                final ArrayList<Pack> result = new ArrayList<Pack>(list);
                TagCountView.this.lastSize = result.size();
                ExUtil.exec((Composite)TagCountView.this.dataTableSash, new Runnable(){

                    @Override
                    public void run() {
                        (this).TagCountView.this.dataRangeLbl.setText(String.valueOf((this).TagCountView.this.lastIndex + 1) + " ~ " + ((this).TagCountView.this.lastSize > 0 ? Integer.valueOf((this).TagCountView.this.lastIndex + (this).TagCountView.this.lastSize) : ""));
                        (this).TagCountView.this.lastIndex += (this).TagCountView.this.lastSize;
                        if ((this).TagCountView.this.lastSize < 100) {
                            (this).TagCountView.this.rightBtn.setEnabled(false);
                        }
                        (this).TagCountView.this.leftBtn.setEnabled(true);
                        if (TagCountView.DEFAULT_TAG_GROUP.equals(tagGroup)) {
                            if ((this).TagCountView.this.lastSize > 0) {
                                Pack p = (Pack)result.get(0);
                                XLogPack xp = (XLogPack)p;
                                (this).TagCountView.this.firstTime = xp.endTime;
                                (this).TagCountView.this.firstTxid = xp.txid;
                                p = (Pack)result.get(result.size() - 1);
                                xp = (XLogPack)p;
                                (this).TagCountView.this.lastTime = xp.endTime;
                                (this).TagCountView.this.lastTxid = xp.txid;
                            } else {
                                (this).TagCountView.this.firstTime = (this).TagCountView.this.lastTime + 1L;
                                (this).TagCountView.this.lastTxid = 0L;
                                (this).TagCountView.this.firstTxid = 0L;
                            }
                            (this).TagCountView.this.serviceTable.setInput(result, (this).TagCountView.this.serverId, tagGroup);
                        } else if ("alert".equals(tagGroup)) {
                            if ((this).TagCountView.this.lastSize > 0) {
                                Pack p = (Pack)result.get(0);
                                AlertPack xp = (AlertPack)p;
                                (this).TagCountView.this.firstTime = xp.time;
                                p = (Pack)result.get(result.size() - 1);
                                xp = (AlertPack)p;
                                (this).TagCountView.this.lastTime = xp.time;
                            } else {
                                (this).TagCountView.this.firstTime = (this).TagCountView.this.lastTime + 1L;
                                (this).TagCountView.this.lastTxid = 0L;
                                (this).TagCountView.this.firstTxid = 0L;
                            }
                            (this).TagCountView.this.alertTable.setInput(result, (this).TagCountView.this.serverId, tagGroup);
                        }
                    }
                });
            }
        });
    }

    private void loadLeftData(final String tagGroup, final MapValue filterMv) {
        ExUtil.asyncRun(new Runnable(){

            @Override
            public void run() {
                long etime = TagCountView.this.firstTime;
                long stime = etime / 60000L * 60000L;
                MapPack extra = new MapPack();
                if (TagCountView.DEFAULT_TAG_GROUP.equals(tagGroup)) {
                    extra.put("txid", TagCountView.this.firstTxid);
                }
                List<Pack> list = TagCountView.this.loadData(tagGroup, stime, etime, true, extra, filterMv);
                final ArrayList<Pack> revList = new ArrayList<Pack>();
                for (Pack p : list) {
                    revList.add(0, p);
                }
                TagCountView.this.lastIndex -= TagCountView.this.lastSize;
                TagCountView.this.lastSize = revList.size();
                ExUtil.exec((Composite)TagCountView.this.dataTableSash, new Runnable(){

                    @Override
                    public void run() {
                        (this).TagCountView.this.dataRangeLbl.setText(String.valueOf((this).TagCountView.this.lastIndex - (this).TagCountView.this.lastSize + 1) + " ~ " + (this).TagCountView.this.lastIndex);
                        if ((this).TagCountView.this.lastIndex <= 100) {
                            (this).TagCountView.this.leftBtn.setEnabled(false);
                        }
                        (this).TagCountView.this.rightBtn.setEnabled(true);
                        if (TagCountView.DEFAULT_TAG_GROUP.equals(tagGroup)) {
                            Pack p = (Pack)revList.get(0);
                            XLogPack xp = (XLogPack)p;
                            (this).TagCountView.this.firstTime = xp.endTime;
                            (this).TagCountView.this.firstTxid = xp.txid;
                            p = (Pack)revList.get(revList.size() - 1);
                            xp = (XLogPack)p;
                            (this).TagCountView.this.lastTime = xp.endTime;
                            (this).TagCountView.this.lastTxid = xp.txid;
                            (this).TagCountView.this.serviceTable.setInput(revList, (this).TagCountView.this.serverId, tagGroup);
                        } else if ("alert".equals(tagGroup)) {
                            Pack p = (Pack)revList.get(0);
                            AlertPack xp = (AlertPack)p;
                            (this).TagCountView.this.firstTime = xp.time;
                            p = (Pack)revList.get(revList.size() - 1);
                            xp = (AlertPack)p;
                            (this).TagCountView.this.lastTime = xp.time;
                            (this).TagCountView.this.alertTable.setInput(revList, (this).TagCountView.this.serverId, tagGroup);
                        }
                    }
                });
            }
        });
    }

    private List<Pack> loadData(String tagGroup, long stime, long etime, boolean reverse, MapPack extra, MapValue filterMv) {
        List<Pack> list = null;
        TcpProxy tcp = TcpProxy.getTcpProxy(this.serverId);
        try {
            try {
                MapPack param = new MapPack();
                param.put("objType", this.objType);
                param.put("stime", stime);
                param.put("etime", etime);
                param.put("tagGroup", tagGroup);
                param.put("date", this.date);
                param.put("max", 100L);
                param.put("reverse", (Value)new BooleanValue(reverse));
                if (extra != null) {
                    Iterator itr = extra.keys();
                    while (itr.hasNext()) {
                        String key = (String)itr.next();
                        Value v = extra.get(key);
                        param.put(key, v);
                    }
                }
                if (filterMv != null) {
                    param.put("filter", (Value)filterMv);
                }
                list = tcp.process("TAGCNT_TAG_ACTUAL_DATA", (Pack)param);
            }
            catch (Exception e) {
                e.printStackTrace();
                TcpProxy.putTcpProxy(tcp);
            }
        }
        finally {
            TcpProxy.putTcpProxy(tcp);
        }
        return list;
    }

    class TableLabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public Image getColumnImage(Object obj, int columnIndex) {
            return null;
        }

        public String getColumnText(Object obj, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    if (obj instanceof TagCount) {
                        TagCount a = (TagCount)obj;
                        return a.value;
                    }
                }
                case 1: {
                    if (!(obj instanceof TagCount)) break;
                    TagCount a = (TagCount)obj;
                    return FormatUtil.print((Object)Float.valueOf(a.count), (String)"#,##0");
                }
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    static class TagData {
        String tagName;
        List<Value> valueList = new ArrayList<Value>();
        List<Float> cntList = new ArrayList<Float>();
        List<String> strValueList;
        int totalSize;
        float totalCnt;

        TagData() {
        }

        void addValue(Value v, float cnt) {
            this.valueList.add(v);
            this.cntList.add(Float.valueOf(cnt));
        }
    }

    class ViewContentProvider
    implements ITreeContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof Map) {
                return ((Map)parent).values().toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof TagCount) {
                return ((TagCount)parentElement).getChildArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof TagCount) {
                return TagCountView.this.nameTree.get(((TagCount)element).tagName);
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof TagCount) {
                return ((TagCount)element).getChildSize() > 0;
            }
            return false;
        }

        public boolean equals(Object obj) {
            return true;
        }
    }
}

