/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.tags.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import scouter.client.Images;
import scouter.client.popup.CalendarObjTypeDialog;
import scouter.client.tags.TagCountView;
import scouter.client.util.ImageUtil;

public class OpenTagCountViewAction
extends Action
implements CalendarObjTypeDialog.ICalendarCallback {
    IWorkbenchWindow window;
    int serverId;
    String objType;

    public OpenTagCountViewAction(IWorkbenchWindow window, int serverId) {
        this.window = window;
        this.serverId = serverId;
        this.setText("&TagCount");
        this.setImageDescriptor(ImageUtil.getImageDescriptor(Images.bar));
    }

    public OpenTagCountViewAction(IWorkbenchWindow window, int serverId, String objType) {
        this.window = window;
        this.serverId = serverId;
        this.objType = objType;
        this.setText("&TagCount");
        this.setImageDescriptor(ImageUtil.getImageDescriptor(Images.bar));
    }

    public void run() {
        try {
            CalendarObjTypeDialog dialog = new CalendarObjTypeDialog(this.window.getShell().getDisplay(), this, this.serverId, this.objType);
            dialog.show();
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)("Error opening view:" + e.getMessage()));
        }
    }

    @Override
    public void onPressedOk(String date, String objType) {
        try {
            TagCountView v = (TagCountView)this.window.getActivePage().showView(TagCountView.ID, String.valueOf(this.serverId) + "-" + objType + "-" + date, 1);
            v.setInput(date, objType, this.serverId);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)("Error opening view:" + e.getMessage()));
        }
    }
}

