/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.threads;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.server.ServerManager;
import scouter.client.util.ConsoleProxy;
import scouter.io.DataInputX;
import scouter.lang.pack.AlertPack;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.BooleanValue;
import scouter.lang.value.Value;
import scouter.util.ThreadUtil;

public class AlertProxyThread
extends Thread {
    private static AlertProxyThread thread;
    ArrayList<IAlertListener> listeners = new ArrayList();
    Map<Integer, MapPack> paramMap = new HashMap<Integer, MapPack>();
    boolean running = true;

    public static synchronized AlertProxyThread getInstance() {
        if (thread == null) {
            thread = new AlertProxyThread();
            thread.setDaemon(true);
            thread.setName(ThreadUtil.getName((Thread)thread));
            thread.start();
        }
        return thread;
    }

    public void addAlertListener(IAlertListener listener) {
        this.listeners.add(listener);
    }

    public void removeAlertListener(IAlertListener listener) {
        this.listeners.remove(listener);
    }

    public void reset() {
        this.paramMap.clear();
    }

    @Override
    public void run() {
        while (this.running) {
            Set<Integer> serverSet = ServerManager.getInstance().getOpenServerList();
            for (final int serverId : serverSet) {
                TcpProxy tcp = TcpProxy.getTcpProxy(serverId);
                try {
                    try {
                        MapPack param = this.paramMap.get(serverId);
                        if (param == null) {
                            param = new MapPack();
                            this.paramMap.put(serverId, param);
                            param.put("first", (Value)new BooleanValue(true));
                        }
                        tcp.process("ALERT_REAL_TIME", param, new INetReader(){

                            @Override
                            public void process(DataInputX in) throws IOException {
                                Pack packet = in.readPack();
                                if (packet instanceof MapPack) {
                                    MapPack param = (MapPack)packet;
                                    AlertProxyThread.this.paramMap.put(serverId, param);
                                } else {
                                    AlertPack alert = (AlertPack)packet;
                                    for (IAlertListener listener : AlertProxyThread.this.listeners) {
                                        listener.ariseAlert(serverId, alert);
                                    }
                                }
                            }
                        });
                    }
                    catch (Throwable th) {
                        ConsoleProxy.errorSafe("AlertProxyThread : " + th.toString());
                        TcpProxy.putTcpProxy(tcp);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    TcpProxy.putTcpProxy(tcp);
                    throw throwable;
                }
                TcpProxy.putTcpProxy(tcp);
            }
            ThreadUtil.sleep((long)2000L);
        }
    }

    public static interface IAlertListener {
        public void ariseAlert(int var1, AlertPack var2);
    }
}

