/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.threads;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ObjectSelectManager {
    private static ObjectSelectManager instance;
    private Set<Integer> unSelectedObjSet = new HashSet<Integer>();
    List<IObjectCheckListener> objectCheckStateListeners = new ArrayList<IObjectCheckListener>();

    public static synchronized ObjectSelectManager getInstance() {
        if (instance == null) {
            instance = new ObjectSelectManager();
        }
        return instance;
    }

    public boolean isUnselectedObject(int objHash) {
        return this.unSelectedObjSet.contains(objHash);
    }

    public void clear() {
        this.unSelectedObjSet.clear();
        this.notifyChangeCheckedState();
    }

    public int unselectedSize() {
        return this.unSelectedObjSet.size();
    }

    public void addAll(Set<Integer> unSelectedSet) {
        this.unSelectedObjSet.clear();
        this.unSelectedObjSet.addAll(unSelectedSet);
        this.notifyChangeCheckedState();
    }

    public void selectObj(int objHash) {
        if (this.unselectedSize() > 0) {
            if (this.isUnselectedObject(objHash)) {
                this.unSelectedObjSet.remove(objHash);
            } else {
                this.unSelectedObjSet.add(objHash);
            }
            this.notifyChangeCheckedState();
        }
    }

    public void addObjectCheckStateListener(IObjectCheckListener listener) {
        this.objectCheckStateListeners.add(listener);
    }

    public void removeObjectCheckStateListener(IObjectCheckListener listener) {
        this.objectCheckStateListeners.remove(listener);
    }

    private void notifyChangeCheckedState() {
        for (IObjectCheckListener listener : this.objectCheckStateListeners) {
            listener.notifyChangeState();
        }
    }

    public static void main(String[] args) {
        HashSet<Integer> objSet = new HashSet<Integer>();
        HashSet<Integer> aaaSet = new HashSet<Integer>();
        objSet.add(1);
        objSet.add(2);
        objSet.add(3);
        aaaSet.add(3);
        aaaSet.add(4);
        aaaSet.add(5);
        aaaSet.add(6);
        objSet.retainAll(aaaSet);
        System.out.println(objSet);
    }

    public static interface IObjectCheckListener {
        public void notifyChangeState();
    }
}

