/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.threads;

import java.util.Set;
import scouter.client.net.LoginMgr;
import scouter.client.net.LoginResult;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.util.ConsoleProxy;
import scouter.util.ThreadUtil;

public class SessionObserver
extends Thread {
    private static SessionObserver observer;
    private static final long CHECK_INTERVAL = 5000L;

    public static synchronized void load() {
        if (observer == null) {
            observer = new SessionObserver();
            observer.setDaemon(true);
            observer.setName("SessionObserverThread");
            observer.start();
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                Set<Integer> idSet = ServerManager.getInstance().getOpenServerList();
                for (int serverId : idSet) {
                    Server server = ServerManager.getInstance().getServer(serverId);
                    if (server == null) continue;
                    if (!server.isConnected() && server.getConnectionPool().size() < 1) {
                        server.setSession(0L);
                    }
                    if (server.getSession() != 0L) continue;
                    LoginResult result = LoginMgr.silentLogin(server, server.getUserId(), server.getPassword());
                    if (result.success) {
                        ConsoleProxy.infoSafe("Success re-login to " + server.getName());
                        continue;
                    }
                    ConsoleProxy.errorSafe("Failed re-login to " + server.getName() + " : " + result.getErrorMessage());
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            ThreadUtil.sleep((long)5000L);
        }
    }
}

