/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.util;

import java.util.Iterator;
import java.util.List;
import org.csstudio.swt.xygraph.dataprovider.IDataProvider;
import org.csstudio.swt.xygraph.dataprovider.ISample;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridLayout;
import scouter.client.preferences.PManager;

public class ChartUtil {
    public static GridLayout gridlayout(int n) {
        GridLayout layout = new GridLayout();
        layout.numColumns = n;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        return layout;
    }

    public static String getTimeFormat(long unit) {
        if (unit <= 3600000L) {
            return "HH:mm:ss";
        }
        if (unit <= 86400000L) {
            return "HH:mm";
        }
        return "yyyy-MM-dd";
    }

    public static double getSplitTimeUnit(double val, int width) {
        int units = width / 15;
        if (units < 1) {
            units = 1;
        }
        if ((val /= (double)units) <= 0.005) {
            return 0.005;
        }
        return ChartUtil.rounding(val * 1000.0) / 1000.0;
    }

    public static double getSplitUnit(double val, int height) {
        int units = height / 15;
        if (units < 1) {
            units = 1;
        }
        if ((val /= (double)units) <= 0.005) {
            return 0.005;
        }
        return ChartUtil.rounding(val * 1000.0) / 1000.0;
    }

    public static double getMaxValue(double val) {
        if (val < 3.0) {
            return 5.0;
        }
        if (val < 8.0) {
            return 10.0;
        }
        if (val < 15.0) {
            return 20.0;
        }
        return ChartUtil.rounding((val + val / 100.0) * 1000.0) / 1000.0;
    }

    public static double getGroupMaxValue(double val) {
        if (val < 2.0) {
            return 3.0;
        }
        if (val < 3.0) {
            return 5.0;
        }
        if (val < 8.0) {
            return 10.0;
        }
        if (val < 15.0) {
            return 20.0;
        }
        return ChartUtil.rounding(val * 1000.0) / 1000.0;
    }

    public static double getEqMaxValue(double val) {
        if (val < 7.0) {
            return 10.0;
        }
        if (val < 20.0) {
            return 30.0;
        }
        if (val < 40.0) {
            return 60.0;
        }
        if (val < 70.0) {
            return 100.0;
        }
        if (val < 300.0) {
            return 500.0;
        }
        return ChartUtil.rounding(val * 100.0) / 100.0;
    }

    public static double getYaxisUnit(double val, int height) {
        int units = height / 15;
        if (units < 1) {
            units = 1;
        }
        return ChartUtil.getElapsedMaxValue((val /= (double)units) * 1000.0) / 1000.0;
    }

    public static double getElapsedMaxValue(double val) {
        if (val <= 0.005) {
            return 0.005;
        }
        long value = (long)(val * 1000.0);
        long decVal = 1L;
        long x = value;
        while (x > 10L) {
            decVal *= 10L;
            x /= 10L;
        }
        if (value == decVal) {
            return value / 1000L;
        }
        return (value / decVal + (long)(value - value / decVal * decVal == 0L ? 0 : 1)) * decVal / 1000L;
    }

    public static double addElapsedUnit(double val) {
        if (val <= 0.005) {
            return 0.005;
        }
        long value = (long)val;
        if (value == 10L) {
            return 10.0;
        }
        long decVal = 1L;
        long x = value;
        while (x >= 10L) {
            decVal *= 10L;
            x /= 10L;
        }
        return decVal;
    }

    private static double rounding(double val) {
        long value = (long)val;
        long decVal = 1L;
        long x = value;
        while (x >= 10L) {
            decVal *= 10L;
            x /= 10L;
        }
        if (value > decVal * 5L) {
            return decVal * 10L;
        }
        if (value > decVal * 2L) {
            return decVal * 5L;
        }
        return decVal * 2L;
    }

    public static long getTimeUnit(long interval) {
        if (interval <= 1000L) {
            return 1000L;
        }
        if (interval <= 2000L) {
            return 2000L;
        }
        if (interval <= 5000L) {
            return 5000L;
        }
        if (interval <= 10000L) {
            return 10000L;
        }
        if (interval <= 15000L) {
            return 15000L;
        }
        if (interval <= 30000L) {
            return 30000L;
        }
        if (interval <= 60000L) {
            return 60000L;
        }
        if (interval <= 120000L) {
            return 120000L;
        }
        if (interval <= 300000L) {
            return 300000L;
        }
        if (interval <= 600000L) {
            return 600000L;
        }
        if (interval <= 900000L) {
            return 900000L;
        }
        if (interval <= 1800000L) {
            return 900000L;
        }
        if (interval <= 3600000L) {
            return 3600000L;
        }
        if (interval <= 0x6DDD00L) {
            return 0x6DDD00L;
        }
        if (interval <= 10800000L) {
            return 10800000L;
        }
        if (interval <= 14400000L) {
            return 14400000L;
        }
        if (interval <= 21600000L) {
            return 21600000L;
        }
        if (interval <= 43200000L) {
            return 43200000L;
        }
        return interval;
    }

    public static double getMax(Iterator<ISample> iterator) {
        double max = 0.0;
        while (iterator.hasNext()) {
            ISample s = iterator.next();
            if (!(s.getYValue() > max)) continue;
            max = s.getYValue();
        }
        return ChartUtil.getMaxValue(max);
    }

    public static double getMax(List<Double> values) {
        double max = 0.0;
        for (Double value : values) {
            double v = value;
            if (!(v > max)) continue;
            max = v;
        }
        return ChartUtil.getMaxValue(max);
    }

    public static Trace addSolidLine(XYGraph xyGraph, IDataProvider dataProvider, Color color) {
        Trace lineTrace = new Trace("SOLID_LINE", xyGraph.primaryXAxis, xyGraph.primaryYAxis, dataProvider);
        lineTrace.setPointStyle(Trace.PointStyle.NONE);
        lineTrace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
        lineTrace.setTraceType(Trace.TraceType.SOLID_LINE);
        lineTrace.setTraceColor(color);
        xyGraph.addTrace(lineTrace);
        return lineTrace;
    }

    public static boolean isShowLegendAllowSize(int width, int height) {
        boolean result = false;
        if (width >= 400 && height >= 400) {
            result = true;
        }
        return result;
    }

    public static boolean isShowDescriptionAllowSize(int height) {
        boolean result = false;
        if (height >= 200) {
            result = true;
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println(ChartUtil.getMaxValue(20.0));
    }
}

