/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.util;

import java.io.OutputStream;
import java.io.PrintStream;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import scouter.client.util.ColorUtil;

public class ConsoleProxy {
    private static ConsoleProxy fDefault = new ConsoleProxy();
    private String fTitle = "Scouter";
    private MessageConsole fMessageConsole = null;
    public static final int MSG_INFORMATION = 1;
    public static final int MSG_ERROR = 2;
    public static final int MSG_WARNING = 3;
    public static final int MSG_CATCH = 4;
    public static final int MSG_DEBUG = 5;

    public static void warning(String msg) {
        fDefault.write(msg, 3);
    }

    public static void error(String msg) {
        fDefault.write(msg, 2);
    }

    public static void info(String msg) {
        fDefault.write(msg, 1);
    }

    public static void println(String msg, int msgKind) {
        fDefault.write(msg, msgKind);
    }

    public static void printlnSafe(final String msg, final int msgKind) {
        try {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ConsoleProxy.println(msg, msgKind);
                }
            });
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void warningSafe(String message) {
        ConsoleProxy.printlnSafe(message, 3);
    }

    public static void infoSafe(String message) {
        ConsoleProxy.printlnSafe(message, 1);
    }

    public static void errorSafe(String message) {
        ConsoleProxy.printlnSafe(message, 2);
    }

    public static void catchSafe(String message) {
        ConsoleProxy.printlnSafe(message, 4);
    }

    public static void debugSafe(String message) {
        ConsoleProxy.printlnSafe(message, 5);
    }

    private void write(String msg, int msgKind) {
        if (msg == null) {
            return;
        }
        try {
            this.getNewMessageConsoleStream(msgKind).println(msg);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void clear() {
        IDocument document = this.getMessageConsole().getDocument();
        if (document != null) {
            document.set("");
        }
    }

    public boolean displayConsoleView() {
        try {
            IWorkbenchPage activePage;
            IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (activeWorkbenchWindow != null && (activePage = activeWorkbenchWindow.getActivePage()) != null) {
                activePage.showView("org.eclipse.ui.console.ConsoleView", null, 2);
            }
        }
        catch (Throwable partEx) {
            return false;
        }
        return true;
    }

    private MessageConsoleStream getNewMessageConsoleStream(int msgKind) {
        String swtColorId = "back";
        switch (msgKind) {
            case 1: {
                swtColorId = "dark green";
                break;
            }
            case 2: {
                swtColorId = "dark magenta";
                break;
            }
            case 3: {
                swtColorId = "dark blue";
                break;
            }
            case 4: {
                swtColorId = "red";
                break;
            }
            case 5: {
                swtColorId = "blue gray";
            }
        }
        MessageConsoleStream msgConsoleStream = this.getMessageConsole().newMessageStream();
        PrintStream myS = new PrintStream((OutputStream)msgConsoleStream);
        System.setOut(myS);
        System.setErr(myS);
        try {
            Color c = ColorUtil.getInstance().getColor(swtColorId);
            msgConsoleStream.setColor(c);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return msgConsoleStream;
    }

    private MessageConsole getMessageConsole() {
        if (this.fMessageConsole == null) {
            this.fMessageConsole = new MessageConsole(this.fTitle, null);
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.fMessageConsole});
        }
        return this.fMessageConsole;
    }
}

