/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.util;

import java.util.HashSet;
import java.util.Set;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.util.StringUtil;

public class CounterUtil {
    private static Set<String> counterAvgSet = new HashSet<String>();

    static {
        counterAvgSet.add("ErrorRate");
        counterAvgSet.add("ElapsedTime");
        counterAvgSet.add("Elapsed90%");
    }

    public static boolean isPercentValue(String objType, String counter) {
        Server server = ServerManager.getInstance().getDefaultServer();
        if (server == null) {
            return false;
        }
        String unit = server.getCounterEngine().getCounterUnit(objType, counter);
        if (StringUtil.isNotEmpty((String)unit)) {
            return unit.trim().equals("%");
        }
        return false;
    }

    public static String getTotalMode(String objType, String counter) {
        if (counterAvgSet.contains(counter) || CounterUtil.isPercentValue(objType, counter)) {
            return "avg";
        }
        return "sum";
    }
}

