/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.util;

import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import scouter.client.configuration.views.ConfigureView;
import scouter.client.util.ColoringWord;

public class CustomLineStyleListener
implements LineStyleListener {
    String searchString;
    boolean isConfig;
    Display display;
    ArrayList<ColoringWord> keywordArray;
    ArrayList<ColoringWord> taggedKeywordArray;
    boolean keywordBold;
    boolean searchBold;
    Color highlightingColor;

    public CustomLineStyleListener(boolean isConfig, ArrayList<ColoringWord> keywordArray, boolean keywordBold) {
        this.isConfig = isConfig;
        this.keywordArray = keywordArray;
        this.keywordBold = keywordBold;
    }

    public CustomLineStyleListener(boolean isConfig, ArrayList<ColoringWord> keywordArray, ArrayList<ColoringWord> taggedKeywordArray, boolean keywordBold) {
        this.isConfig = isConfig;
        this.keywordArray = keywordArray;
        this.taggedKeywordArray = taggedKeywordArray;
        this.keywordBold = keywordBold;
    }

    public CustomLineStyleListener(Display display, boolean isConfig, ArrayList<ColoringWord> keywordArray, boolean keywordBold) {
        this.display = display;
        this.isConfig = isConfig;
        this.keywordArray = keywordArray;
        this.keywordBold = keywordBold;
    }

    public CustomLineStyleListener(boolean isConfig, ArrayList<ColoringWord> keywordMap, boolean keywordBold, boolean searchBold, int searchedTextColor) {
        this.isConfig = isConfig;
        this.keywordArray = keywordMap;
        this.keywordBold = keywordBold;
        this.searchBold = searchBold;
        this.highlightingColor = Display.getCurrent().getSystemColor(searchedTextColor);
    }

    public void setKeywordArray(ArrayList<ColoringWord> keywordArray) {
        this.keywordArray = keywordArray;
    }

    public void setTaggedKeywordArray(ArrayList<ColoringWord> taggedKeywordArray) {
        this.taggedKeywordArray = taggedKeywordArray;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    public void lineGetStyle(LineStyleEvent event) {
        if (this.keywordArray == null) {
            return;
        }
        String line = event.lineText;
        LinkedList<StyleRange> list = new LinkedList<StyleRange>();
        int inx = 0;
        while (inx < this.keywordArray.size()) {
            ColoringWord word = this.keywordArray.get(inx);
            int cursor = -1;
            while ((cursor = line.toLowerCase().indexOf(word.getWord().toLowerCase(), cursor + 1)) >= 0) {
                list.add(this.getDefaultHighlightStyle(event.lineOffset + cursor, word.getWord().length(), Display.getCurrent().getSystemColor(word.getColor()), word.isBold()));
            }
            ++inx;
        }
        if (!this.isConfig && this.searchString != null && this.searchString.length() > 0) {
            int cursor = -1;
            while ((cursor = line.toLowerCase().indexOf(this.searchString.toLowerCase(), cursor + 1)) >= 0) {
                list.add(this.getHighlightStyle(event.lineOffset + cursor, this.searchString.length(), this.highlightingColor));
            }
        }
        if (this.isConfig) {
            if (this.taggedKeywordArray != null) {
                for (ColoringWord word : this.taggedKeywordArray) {
                    String[] keywords = line.split("=");
                    String normalizedKeyword = ConfigureView.removeVariableString(keywords[0]);
                    int pos = normalizedKeyword.indexOf(word.getWord());
                    if (pos < 0) continue;
                    int len = keywords[0].length();
                    list.add(this.getDefaultHighlightStyle(event.lineOffset + pos, len, Display.getCurrent().getSystemColor(word.getColor()), word.isBold()));
                }
            }
            if (line.startsWith("#")) {
                list.add(this.getDefaultHighlightStyle(event.lineOffset, line.length(), Display.getCurrent().getSystemColor(6), false));
            }
        }
        if (line.startsWith("<?")) {
            list.add(this.getDefaultHighlightStyle(event.lineOffset, line.length(), Display.getCurrent().getSystemColor(4), false));
        }
        event.styles = list.toArray(new StyleRange[list.size()]);
    }

    private StyleRange getHighlightStyle(int startOffset, int length, Color color) {
        StyleRange styleRange = new StyleRange();
        styleRange.start = startOffset;
        styleRange.length = length;
        styleRange.background = color;
        if (this.searchBold) {
            styleRange.fontStyle = 1;
        }
        return styleRange;
    }

    private StyleRange getDefaultHighlightStyle(int startOffset, int length, Color color, boolean isBold) {
        StyleRange styleRange = new StyleRange();
        styleRange.start = startOffset;
        styleRange.length = length;
        styleRange.foreground = color;
        if (this.keywordBold || isBold) {
            styleRange.fontStyle = 1;
        }
        return styleRange;
    }
}

