/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.util;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class ExUtil {
    public static void exec(Runnable r) {
        ExUtil.exec(Display.getCurrent(), r);
    }

    public static void exec(Display display, final Runnable r) {
        if (display == null || r == null) {
            return;
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    r.run();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        });
    }

    public static void exec(Composite c, Runnable r) {
        if (c == null) {
            return;
        }
        try {
            ExUtil.exec(c.getDisplay(), r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void syncExec(Runnable r) {
        ExUtil.syncExec(Display.getCurrent(), r);
    }

    public static void syncExec(Display display, final Runnable r) {
        if (display == null || r == null) {
            return;
        }
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    r.run();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    public static void syncExec(Composite c, Runnable r) {
        if (c == null) {
            return;
        }
        try {
            ExUtil.syncExec(c.getDisplay(), r);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void asyncRun(Runnable r) {
        ExUtil.asyncRun(null, r);
    }

    public static void asyncRun(String name, Runnable r) {
        try {
            Thread thread = new Thread(r);
            if (name != null) {
                thread.setName(name);
            }
            thread.setDaemon(true);
            thread.start();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

