/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import scouter.client.util.ImageUtil;
import scouter.client.util.LocationUtil;

public class ImageRegistryUtil {
    public static ImageDescriptor registImageFile(AbstractUIPlugin plugin, File file) throws IOException {
        ImageRegistry registry = plugin.getImageRegistry();
        String rootpath = LocationUtil.getAbsoluteFile(plugin, "").getAbsolutePath();
        if (!file.getAbsolutePath().startsWith(rootpath)) {
            return null;
        }
        String rpath = file.getAbsolutePath().substring(rootpath.length() + 1).replaceAll("\\\\", "/");
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)LocationUtil.getURL(plugin, rpath));
        registry.put(rpath, descriptor);
        return descriptor;
    }

    public static ImageDescriptor registImage(AbstractUIPlugin plugin, String path) throws FileNotFoundException {
        ImageRegistry registry = plugin.getImageRegistry();
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)LocationUtil.getURL(plugin, path));
        registry.put(path, descriptor);
        return descriptor;
    }

    public static Image registImage(AbstractUIPlugin plugin, String id, Image image) {
        ImageRegistry registry = plugin.getImageRegistry();
        registry.put(id, image);
        return image;
    }

    public static ImageDescriptor registImageDescriptor(AbstractUIPlugin plugin, String id, ImageDescriptor descriptor) {
        ImageRegistry registry = plugin.getImageRegistry();
        registry.put(id, descriptor);
        return descriptor;
    }

    public static Image getImage(AbstractUIPlugin plugin, String id) {
        ImageRegistry imageRegistry = plugin.getImageRegistry();
        Image image = imageRegistry.get(id);
        if (image == null) {
            try {
                ImageRegistryUtil.registImage(plugin, id);
                image = imageRegistry.get(id);
            }
            catch (FileNotFoundException e) {
                image = ImageUtil.UNKNOWN;
            }
        }
        return image;
    }
}

