/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;

public class LocationUtil {
    public static URL getURL(AbstractUIPlugin plugin, String path) throws FileNotFoundException {
        URL url = FileLocator.find((Bundle)plugin.getBundle(), (IPath)new Path(path), null);
        if (url == null) {
            throw new FileNotFoundException(String.valueOf(path) + " Not found");
        }
        return url;
    }

    public static File getAbsoluteFile(AbstractUIPlugin plugin, String path) throws IOException {
        URL url = FileLocator.resolve((URL)LocationUtil.getURL(plugin, path));
        return new File(url.getFile());
    }

    public static File getBundleLocation(AbstractUIPlugin plugin) {
        return new File(plugin.getBundle().getLocation());
    }

    public static File getConfigurationLocation() {
        Location loc = Platform.getConfigurationLocation();
        return new File(loc.getURL().getFile());
    }

    public static File getInstallLocation() {
        Location loc = Platform.getInstallLocation();
        return new File(loc.getURL().getFile());
    }

    public static File getInstanceLocation() {
        Location loc = Platform.getInstanceLocation();
        Platform.getUserLocation();
        return new File(loc.getURL().getFile());
    }

    public static File getStateLocation(AbstractUIPlugin plugin) {
        IPath path = Platform.getStateLocation((Bundle)plugin.getBundle());
        return path.toFile();
    }
}

