/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.util;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import scouter.client.Images;
import scouter.client.actions.OpenActiveServiceListAction;
import scouter.client.actions.OpenActiveSpeedAction;
import scouter.client.actions.OpenEQViewAction;
import scouter.client.actions.OpenServiceGroupElapsedAction;
import scouter.client.actions.OpenServiceGroupTPSAction;
import scouter.client.actions.OpenVerticalEQViewAction;
import scouter.client.actions.SetColorAction;
import scouter.client.batch.actions.OpenCxtmenuBatchActiveListAction;
import scouter.client.batch.actions.OpenCxtmenuBatchHistoryAction;
import scouter.client.configuration.actions.DefineObjectTypeAction;
import scouter.client.configuration.actions.OpenAgentConfigureAction;
import scouter.client.context.actions.OpenCxtmenuActiveServiceListAction;
import scouter.client.context.actions.OpenCxtmenuDumpActiveServiceListAction;
import scouter.client.context.actions.OpenCxtmenuDumpFileListAction;
import scouter.client.context.actions.OpenCxtmenuDumpHeapHistoAction;
import scouter.client.context.actions.OpenCxtmenuDumpThreadDumpAction;
import scouter.client.context.actions.OpenCxtmenuDumpThreadListAction;
import scouter.client.context.actions.OpenCxtmenuEnvAction;
import scouter.client.context.actions.OpenCxtmenuFileSocketAction;
import scouter.client.context.actions.OpenCxtmenuHeapHistoViewAction;
import scouter.client.context.actions.OpenCxtmenuObjectClassListAction;
import scouter.client.context.actions.OpenCxtmenuObjectThreadDumpAction;
import scouter.client.context.actions.OpenCxtmenuProfileBlockAction;
import scouter.client.context.actions.OpenCxtmenuProfileMutexAction;
import scouter.client.context.actions.OpenCxtmenuPropertiesAction;
import scouter.client.context.actions.OpenCxtmenuResetCacheAction;
import scouter.client.context.actions.OpenCxtmenuSystemGcAction;
import scouter.client.context.actions.OpenCxtmenuThreadListAction;
import scouter.client.counter.actions.OpenDailyServiceCountAction;
import scouter.client.counter.actions.OpenPastDateViewAction;
import scouter.client.counter.actions.OpenPastLongDateAllAction;
import scouter.client.counter.actions.OpenPastLongDateTotalAction;
import scouter.client.counter.actions.OpenPastTimeAllAction;
import scouter.client.counter.actions.OpenPastTimeTotalAction;
import scouter.client.counter.actions.OpenPastTimeViewAction;
import scouter.client.counter.actions.OpenRTPairAllAction;
import scouter.client.counter.actions.OpenRTPairAllAction2;
import scouter.client.counter.actions.OpenRealTimeAllAction;
import scouter.client.counter.actions.OpenRealTimeMultiAction;
import scouter.client.counter.actions.OpenRealTimeStackAction;
import scouter.client.counter.actions.OpenRealTimeTotalAction;
import scouter.client.counter.actions.OpenRealTimeViewAction;
import scouter.client.counter.actions.OpenSummaryAction;
import scouter.client.counter.actions.OpenTodayAllAction;
import scouter.client.counter.actions.OpenTodayServiceCountAction;
import scouter.client.counter.actions.OpenTodayTotalAction;
import scouter.client.counter.actions.OpenTodayViewAction;
import scouter.client.counter.actions.OpenTypeSummaryAction;
import scouter.client.counter.actions.OpenUniqueTotalVisitorAction;
import scouter.client.counter.actions.OpenUniqueVisitorAction;
import scouter.client.counter.views.CounterLoadDateView;
import scouter.client.counter.views.CounterLoadTimeView;
import scouter.client.counter.views.CounterPastLongDateAllView;
import scouter.client.counter.views.CounterPastLongDateTotalView;
import scouter.client.counter.views.CounterPastTimeAllView;
import scouter.client.counter.views.CounterPastTimeTotalView;
import scouter.client.counter.views.CounterRealDateView;
import scouter.client.counter.views.CounterRealTimeAllView;
import scouter.client.counter.views.CounterRealTimeTotalView;
import scouter.client.counter.views.CounterRealTimeView;
import scouter.client.counter.views.CounterTodayAllView;
import scouter.client.counter.views.CounterTodayTotalView;
import scouter.client.cubrid.CubridSingleItem;
import scouter.client.cubrid.actions.OpenMultiViewAction;
import scouter.client.cubrid.actions.OpenOtherViewAction;
import scouter.client.heapdump.actions.BlockProfileAction;
import scouter.client.heapdump.actions.CpuProfileAction;
import scouter.client.heapdump.actions.HeapDumpAction;
import scouter.client.heapdump.actions.HeapDumpListAction;
import scouter.client.heapdump.actions.MutexProfileAction;
import scouter.client.host.actions.OpenDiskUsageAction;
import scouter.client.host.actions.OpenTopAction;
import scouter.client.maria.actions.OpenDbRealtimeWaitCountAction;
import scouter.client.model.AgentModelThread;
import scouter.client.model.AgentObject;
import scouter.client.model.TextProxy;
import scouter.client.server.Server;
import scouter.client.server.ServerManager;
import scouter.client.stack.actions.OpenStackDialogAction;
import scouter.client.stack.actions.TurnOffStackAction;
import scouter.client.stack.actions.TurnOnStackAction;
import scouter.client.util.ImageUtil;
import scouter.client.util.TimeUtil;
import scouter.client.xlog.actions.OpenXLogLoadTimeAction;
import scouter.client.xlog.actions.OpenXLogRealTimeAction;
import scouter.lang.Counter;
import scouter.lang.ObjectType;
import scouter.lang.counters.CounterEngine;
import scouter.util.DateUtil;
import scouter.util.StringUtil;

public class MenuUtil
implements IMenuCreator {
    private Menu menu;
    private ArrayList<Action> menuActions = null;
    private int disableInx = -1;
    int[] separator;

    public MenuUtil() {
    }

    public MenuUtil(ArrayList<Action> menuActions, int disableInx) {
        this.menuActions = menuActions;
        this.disableInx = disableInx;
    }

    public MenuUtil(ArrayList<Action> menuActions, int disableInx, int[] separator) {
        this.menuActions = menuActions;
        this.disableInx = disableInx;
        this.separator = separator;
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
        this.menu = new Menu(parent);
        int inx = 0;
        while (inx < this.menuActions.size()) {
            final Action act = this.menuActions.get(inx);
            if (act.getText() == null || "".equals(act.getText())) {
                new MenuItem(this.menu, 2);
            } else {
                MenuItem submenu = new MenuItem(this.menu, 64);
                submenu.setText(act.getText());
                submenu.setImage(act.getImageDescriptor().createImage());
                if (inx == this.disableInx) {
                    submenu.setEnabled(false);
                }
                submenu.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        act.run();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }
            ++inx;
        }
        return this.menu;
    }

    public static void createMenu(IWorkbenchWindow window, IToolBarManager man, ArrayList<Action> menuArray, Image image) {
        MenuUtil.createMenu(window, man, menuArray, image, -1);
    }

    public static void createMenu(IWorkbenchWindow window, IToolBarManager man, ArrayList<Action> menuArray, Image image, int disableInx) {
        if (man.isEmpty()) {
            if (menuArray.size() == 1) {
                man.add((IAction)menuArray.get(0));
            } else {
                Action act = new Action("Show related Views", 4){};
                act.setImageDescriptor(ImageUtil.getImageDescriptor(image));
                act.setMenuCreator((IMenuCreator)new MenuUtil(menuArray, disableInx));
                man.add((IAction)act);
            }
        }
    }

    public static HashMap<String, Action> getCounterActionList(IWorkbenchWindow window, CounterEngine counterEngine, int serverId) {
        HashMap<String, Action> actions = new HashMap<String, Action>();
        ArrayList objTypeAndCounter = counterEngine.getAllCounterList();
        if (objTypeAndCounter == null || objTypeAndCounter.isEmpty()) {
            return actions;
        }
        int inx = 0;
        while (inx < objTypeAndCounter.size()) {
            String[] splitedKey = ((String)objTypeAndCounter.get(inx)).split(":");
            String objType = splitedKey[0];
            String label = splitedKey[1];
            String counterName = splitedKey[2];
            actions.put(String.valueOf(objType) + ":" + counterName, new OpenRealTimeAllAction(window, label, objType, counterName, Images.getCounterImage(objType, counterName, serverId), serverId));
            ++inx;
        }
        return actions;
    }

    public static HashMap<String, Action> getPastCounterActionList(IWorkbenchWindow window, CounterEngine counterEngine, String curdate, int serverId) {
        String counterName;
        String label;
        String objType;
        String[] splitedKey;
        HashMap<String, Action> actions = new HashMap<String, Action>();
        long st = DateUtil.yyyymmdd((String)curdate);
        long et = st + 300000L;
        ArrayList objTypeAndCounter = counterEngine.getAllCounterList();
        int inx = 0;
        while (inx < objTypeAndCounter.size()) {
            splitedKey = ((String)objTypeAndCounter.get(inx)).split(":");
            objType = splitedKey[0];
            label = splitedKey[1];
            counterName = splitedKey[2];
            actions.put(String.valueOf(objType) + ":" + counterName + ":" + "pt-all", new OpenPastTimeAllAction(window, label, objType, counterName, Images.getCounterImage(objType, counterName, serverId), st, et, serverId));
            ++inx;
        }
        objTypeAndCounter = counterEngine.getAllCounterList();
        inx = 0;
        while (inx < objTypeAndCounter.size()) {
            splitedKey = ((String)objTypeAndCounter.get(inx)).split(":");
            objType = splitedKey[0];
            label = splitedKey[1];
            counterName = splitedKey[2];
            actions.put(String.valueOf(objType) + ":" + counterName + ":" + "pd-all", new OpenPastLongDateAllAction(window, label, objType, counterName, Images.getCounterImage(objType, counterName, serverId), curdate, curdate, serverId));
            ++inx;
        }
        objTypeAndCounter = counterEngine.getTotalCounterList();
        inx = 0;
        while (inx < objTypeAndCounter.size()) {
            splitedKey = ((String)objTypeAndCounter.get(inx)).split(":");
            objType = splitedKey[0];
            label = splitedKey[1];
            counterName = splitedKey[2];
            actions.put(String.valueOf(objType) + ":" + counterName + ":" + "pt-tot", new OpenPastTimeTotalAction(window, label, objType, counterName, Images.getCounterImage(objType, counterName, serverId), st, et, serverId));
            ++inx;
        }
        objTypeAndCounter = counterEngine.getTotalCounterList();
        inx = 0;
        while (inx < objTypeAndCounter.size()) {
            splitedKey = ((String)objTypeAndCounter.get(inx)).split(":");
            objType = splitedKey[0];
            label = splitedKey[1];
            counterName = splitedKey[2];
            actions.put(String.valueOf(objType) + ":" + counterName + ":" + "pd-tot", new OpenPastLongDateTotalAction(window, label, objType, counterName, Images.getCounterImage(objType, counterName, serverId), curdate, curdate, serverId));
            ++inx;
        }
        return actions;
    }

    public static void addObjectContextMenu(IMenuManager mgr, IWorkbenchWindow win, AgentObject object) {
        int serverId = object.getServerId();
        String objType = object.getObjType();
        int objHash = object.getObjHash();
        String objName = object.getObjName();
        Server server = ServerManager.getInstance().getServer(serverId);
        CounterEngine counterEngine = server.getCounterEngine();
        String[] counterNames = counterEngine.getSortedCounterName(objType);
        MenuManager performanceCounter = new MenuManager("Performance Counter", ImageUtil.getImageDescriptor(Images.CTXMENU_RTC), "scouter.client.contextmenu.agentobject.performanceCounter");
        mgr.add((IContributionItem)performanceCounter);
        if (object.isAlive() && counterNames != null) {
            int inx = 0;
            while (inx < counterNames.length) {
                String counter = counterNames[inx];
                String counterDisplay = counterEngine.getCounterDisplayName(objType, counter);
                performanceCounter.add((IAction)new OpenRealTimeViewAction(win, counterDisplay, counter, Images.getCounterImage(objType, counter, serverId), objHash, objName, objType, serverId));
                ++inx;
            }
        }
        if (counterEngine.isChildOf(objType, "javaee")) {
            performanceCounter.add((IContributionItem)new Separator());
            performanceCounter.add((IAction)new OpenUniqueVisitorAction(win, serverId, objHash));
            performanceCounter.add((IAction)new OpenSummaryAction(win, serverId, objHash));
        } else if (counterEngine.isChildOf(objType, "host")) {
            performanceCounter.add((IContributionItem)new Separator());
            performanceCounter.add((IAction)new OpenRealTimeStackAction(win, "Sys/User CPU", serverId, objHash, new String[]{"SysCpu", "UserCpu"}));
        } else if (counterEngine.isChildOf(objType, "maria")) {
            performanceCounter.add((IContributionItem)new Separator());
            performanceCounter.add((IAction)new OpenRealTimeMultiAction(win, "Opened Tables", serverId, objHash, objType, new String[]{"OT_DEF", "OT_COUNT"}));
            performanceCounter.add((IAction)new OpenRealTimeMultiAction(win, "Temporary Tables", serverId, objHash, objType, new String[]{"DTEMP_TBL", "MTEMP_TBL"}));
            performanceCounter.add((IAction)new OpenRealTimeMultiAction(win, "Table Locks", serverId, objHash, objType, new String[]{"TBL_LOCK", "TBL_LOCK_W"}));
            performanceCounter.add((IAction)new OpenDbRealtimeWaitCountAction(serverId, objHash));
        } else if (counterEngine.isChildOf(objType, "cubrid")) {
            performanceCounter.add((IContributionItem)new Separator());
            int ordinal = 0;
            while (ordinal < CubridSingleItem.values().length) {
                performanceCounter.add((IAction)new OpenMultiViewAction(serverId, objHash, ordinal));
                ++ordinal;
            }
            performanceCounter.add((IAction)new OpenOtherViewAction(serverId, objHash, OpenOtherViewAction.OtherViewType.DML_REALTIME));
            MenuManager cubridDbListView = new MenuManager("DB List View", Images.CAPTURE, "scouter.client.contextmenu.agentobject.cubriddblistview");
            mgr.add((IContributionItem)cubridDbListView);
            cubridDbListView.add((IAction)new OpenOtherViewAction(serverId, objHash, OpenOtherViewAction.OtherViewType.CUBRID_SERVERINFO));
            cubridDbListView.add((IAction)new OpenOtherViewAction(serverId, objHash, OpenOtherViewAction.OtherViewType.DB_SPACE_INFO));
            cubridDbListView.add((IAction)new OpenOtherViewAction(serverId, objHash, OpenOtherViewAction.OtherViewType.LONG_TRANSACTION));
        }
        if (object.isAlive()) {
            MenuManager stackMgr;
            MenuManager dumpMgr;
            MenuManager heapDump;
            MenuManager performanceSnapshot = new MenuManager("Object Request", Images.CAPTURE, "scouter.client.contextmenu.agentobject.request");
            mgr.add((IContributionItem)performanceSnapshot);
            if (counterEngine.isChildOf(objType, "javaee")) {
                performanceSnapshot.add((IAction)new OpenCxtmenuThreadListAction(win, "Thread List", objHash, serverId));
                performanceSnapshot.add((IAction)new OpenCxtmenuActiveServiceListAction(win, "Active Service List", objHash, objType, serverId));
                performanceSnapshot.add((IAction)new OpenCxtmenuObjectClassListAction(win, "Loaded Class List", objHash, serverId));
                if (server.isAllowAction("AllowHeapHistogram")) {
                    performanceSnapshot.add((IAction)new OpenCxtmenuHeapHistoViewAction(win, "Heap Histogram", objHash, serverId));
                }
                if (server.isAllowAction("AllowThreadDump")) {
                    performanceSnapshot.add((IAction)new OpenCxtmenuObjectThreadDumpAction(win, "Thread Dump", objHash, serverId));
                }
                performanceSnapshot.add((IAction)new OpenCxtmenuEnvAction(win, "Env", objHash, serverId));
                performanceSnapshot.add((IAction)new OpenCxtmenuFileSocketAction(win, "Socket", objHash, serverId));
                if (server.isAllowAction("AllowSystemGC")) {
                    performanceSnapshot.add((IAction)new OpenCxtmenuSystemGcAction("System.GC", objHash, serverId));
                }
                performanceSnapshot.add((IAction)new OpenCxtmenuResetCacheAction("Reset Text Cache", objHash, serverId));
                performanceSnapshot.add((IContributionItem)new Separator());
                if (server.isAllowAction("AllowHeapDump")) {
                    heapDump = new MenuManager("Heap Dump", "scouter.client.contextmenu.agentobject.heapdump");
                    performanceSnapshot.add((IContributionItem)heapDump);
                    heapDump.add((IAction)new HeapDumpAction(win, "Run Heap Dump", "" + objHash, objHash, objName, TimeUtil.getCurrentTime(serverId), Images.heap, serverId));
                    heapDump.add((IAction)new HeapDumpListAction(win, "List Heap Dump", objName, objHash, Images.heap, serverId));
                }
                if (server.isAllowAction("AllowFileDump")) {
                    dumpMgr = new MenuManager("File Dump", "scouter.client.contextmenu.agentobject.filedump");
                    performanceSnapshot.add((IContributionItem)dumpMgr);
                    dumpMgr.add((IAction)new OpenCxtmenuDumpFileListAction(win, "List Dump Files", objHash, serverId));
                    dumpMgr.add((IContributionItem)new Separator());
                    dumpMgr.add((IAction)new OpenCxtmenuDumpActiveServiceListAction("Dump Active Service List", objHash, serverId));
                    dumpMgr.add((IAction)new OpenCxtmenuDumpThreadDumpAction("Dump Thread Dump", objHash, serverId));
                    dumpMgr.add((IAction)new OpenCxtmenuDumpThreadListAction("Dump Thread List", objHash, serverId));
                    dumpMgr.add((IAction)new OpenCxtmenuDumpHeapHistoAction("Dump Heaphisto", objHash, serverId));
                }
                mgr.add((IContributionItem)new Separator());
                stackMgr = new MenuManager("Stack Frequency Analyzer", ImageUtil.getImageDescriptor(Images.page_white_stack), "scouter.client.contextmenu.agentobject.stack");
                mgr.add((IContributionItem)stackMgr);
                stackMgr.add((IAction)new TurnOnStackAction(serverId, objHash));
                stackMgr.add((IAction)new TurnOffStackAction(serverId, objHash));
                stackMgr.add((IContributionItem)new Separator());
                stackMgr.add((IAction)new OpenStackDialogAction(serverId, objHash));
                if (server.isAllowAction("AllowConfigure")) {
                    mgr.add((IContributionItem)new Separator());
                    mgr.add((IAction)new OpenAgentConfigureAction(win, "Configure", objHash, serverId));
                }
            } else if (counterEngine.isChildOf(objType, "golang")) {
                performanceSnapshot.add((IAction)new OpenCxtmenuThreadListAction(win, "Thread List", objHash, serverId));
                performanceSnapshot.add((IAction)new OpenCxtmenuActiveServiceListAction(win, "Active Service List", objHash, objType, serverId));
                performanceSnapshot.add((IAction)new OpenCxtmenuResetCacheAction("Reset Text Cache", objHash, serverId));
                if (server.isAllowAction("AllowHeapDump")) {
                    heapDump = new MenuManager("Binary File Dump", "scouter.client.contextmenu.agentobject.heapdump");
                    performanceSnapshot.add((IContributionItem)heapDump);
                    heapDump.add((IAction)new HeapDumpListAction(win, "List Binary Dump", objName, objHash, Images.heap, serverId));
                    heapDump.add((IContributionItem)new Separator());
                    heapDump.add((IAction)new CpuProfileAction(win, "Run CPU Profile Dump(Pending 30s)", "" + objHash, objHash, objName, TimeUtil.getCurrentTime(serverId), Images.heap, serverId));
                    heapDump.add((IAction)new BlockProfileAction(win, "Run Block Profile Dump(Pending 30s)", "" + objHash, objHash, objName, TimeUtil.getCurrentTime(serverId), Images.heap, serverId));
                    heapDump.add((IAction)new MutexProfileAction(win, "Run Mutex Profile Dump(Pending 30s)", "" + objHash, objHash, objName, TimeUtil.getCurrentTime(serverId), Images.heap, serverId));
                }
                if (server.isAllowAction("AllowFileDump")) {
                    dumpMgr = new MenuManager("File Dump", "scouter.client.contextmenu.agentobject.filedump");
                    performanceSnapshot.add((IContributionItem)dumpMgr);
                    dumpMgr.add((IAction)new OpenCxtmenuDumpFileListAction(win, "List Dump Files", objHash, serverId));
                    dumpMgr.add((IContributionItem)new Separator());
                    dumpMgr.add((IAction)new OpenCxtmenuDumpThreadDumpAction("Dump Goroutine Dump", objHash, serverId));
                    dumpMgr.add((IAction)new OpenCxtmenuProfileBlockAction("Dump Block Profile", objHash, serverId));
                    dumpMgr.add((IAction)new OpenCxtmenuProfileMutexAction("Dump Mutex Profile", objHash, serverId));
                }
                mgr.add((IContributionItem)new Separator());
                stackMgr = new MenuManager("Stack Frequency Analyzer", ImageUtil.getImageDescriptor(Images.page_white_stack), "scouter.client.contextmenu.agentobject.stack");
                mgr.add((IContributionItem)stackMgr);
                stackMgr.add((IAction)new TurnOnStackAction(serverId, objHash));
                stackMgr.add((IAction)new TurnOffStackAction(serverId, objHash));
                stackMgr.add((IContributionItem)new Separator());
                stackMgr.add((IAction)new OpenStackDialogAction(serverId, objHash));
                if (server.isAllowAction("AllowConfigure")) {
                    mgr.add((IContributionItem)new Separator());
                    mgr.add((IAction)new OpenAgentConfigureAction(win, "Configure", objHash, serverId));
                }
            } else if (counterEngine.isChildOf(objType, "host")) {
                performanceSnapshot.add((IAction)new OpenCxtmenuEnvAction(win, "Env", objHash, serverId));
                performanceSnapshot.add((IAction)new OpenTopAction(win, "Top", objHash, serverId));
                performanceSnapshot.add((IAction)new OpenDiskUsageAction(win, "Disk Usage", objHash, serverId));
                mgr.add((IContributionItem)new Separator());
                if (server.isAllowAction("AllowConfigure")) {
                    mgr.add((IAction)new OpenAgentConfigureAction(win, "Configure", objHash, serverId));
                }
            } else if (counterEngine.isChildOf(objType, "batch")) {
                performanceCounter.add((IAction)new OpenCxtmenuBatchHistoryAction(win, "Batch History", objHash, serverId));
                mgr.add((IContributionItem)new Separator());
                if (server.isAllowAction("AllowConfigure")) {
                    mgr.add((IAction)new OpenAgentConfigureAction(win, "Configure", objHash, serverId));
                }
                performanceSnapshot.add((IAction)new OpenCxtmenuBatchActiveListAction(win, "Batch Active List", objHash, objType, serverId));
            } else if (objType.equals("cubridagent")) {
                mgr.add((IContributionItem)new Separator());
                mgr.add((IAction)new OpenAgentConfigureAction(win, "Configure", objHash, serverId));
            }
        }
        if (server.isAllowAction("AllowDefineObjectType")) {
            if (counterEngine.isUnknownObjectType(objType)) {
                mgr.add((IAction)new DefineObjectTypeAction(win, serverId, objType, 0));
            } else {
                mgr.add((IAction)new DefineObjectTypeAction(win, serverId, objType, 1));
            }
        }
        mgr.add((IAction)new SetColorAction(win, objHash));
        mgr.add((IAction)new OpenCxtmenuPropertiesAction(win, "Properties", objHash, serverId));
    }

    public static void createCounterContextMenu(final String id, Control control, final int serverId, final String objType, final String counter, final long from, final long to) {
        MenuManager mgr = new MenuManager();
        mgr.setRemoveAllWhenShown(true);
        CounterEngine counterEngine = ServerManager.getInstance().getServer(serverId).getCounterEngine();
        ObjectType objectType = counterEngine.getObjectType(objType);
        if (objectType == null) {
            return;
        }
        final Counter counterObj = objectType.getCounter(counter);
        mgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                Action act;
                if (mgr == null) {
                    return;
                }
                IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (counterObj.isAll()) {
                    act = new OpenRealTimeAllAction(win, "Current All", objType, counter, Images.all, serverId);
                    if (CounterRealTimeAllView.ID.equals(id)) {
                        act.setEnabled(false);
                    }
                    mgr.add((IAction)act);
                }
                if (counterObj.isTotal()) {
                    act = new OpenRealTimeTotalAction(win, "Current Total", objType, counter, Images.total, serverId);
                    if (CounterRealTimeTotalView.ID.equals(id)) {
                        act.setEnabled(false);
                    }
                    mgr.add((IAction)act);
                }
                if (counterObj.isAll()) {
                    act = new OpenTodayAllAction(win, "Today All", objType, counter, Images.all, serverId);
                    if (CounterTodayAllView.ID.equals(id)) {
                        act.setEnabled(false);
                    }
                    mgr.add((IAction)act);
                }
                if (counterObj.isTotal()) {
                    act = new OpenTodayTotalAction(win, "Today Total", objType, counter, Images.total, serverId);
                    if (CounterTodayTotalView.ID.equals(id)) {
                        act.setEnabled(false);
                    }
                    mgr.add((IAction)act);
                }
                mgr.add((IContributionItem)new Separator());
                if (counterObj.isAll()) {
                    act = new OpenPastTimeAllAction(win, "Past All", objType, counter, Images.all, -1L, -1L, serverId);
                    if (CounterPastTimeAllView.ID.equals(id)) {
                        act.setEnabled(false);
                    }
                    mgr.add((IAction)act);
                }
                if (counterObj.isTotal()) {
                    act = new OpenPastTimeTotalAction(win, "Past Total", objType, counter, Images.total, -1L, -1L, serverId);
                    if (CounterPastTimeTotalView.ID.equals(id)) {
                        act.setEnabled(false);
                    }
                    mgr.add((IAction)act);
                }
                if (counterObj.isAll()) {
                    act = new OpenPastLongDateAllAction(win, "Daily All", objType, counter, Images.all, null, null, serverId);
                    if (CounterPastLongDateAllView.ID.equals(id)) {
                        act.setEnabled(false);
                    }
                    mgr.add((IAction)act);
                }
                if (counterObj.isTotal()) {
                    act = new OpenPastLongDateTotalAction(win, "Daily Total", objType, counter, Images.total, null, null, serverId);
                    if (CounterPastLongDateTotalView.ID.equals(id)) {
                        act.setEnabled(false);
                    }
                    mgr.add((IAction)act);
                }
                mgr.add((IContributionItem)new Separator());
                Action actOutgoing = new Action("Open in 3rd-party UI"){

                    public void run() {
                        long _from = from != 0L ? from : System.currentTimeMillis() - 300000L;
                        long _to = from != 0L ? to : System.currentTimeMillis();
                        Program.launch((String)MenuUtil.makeExternalUrl(serverId, objType, _from, _to));
                    }
                };
                mgr.add((IAction)actOutgoing);
                Action actOutgoingClip = new Action("clipboard a link for 3rd-party UI"){

                    public void run() {
                        long _from = from != 0L ? from : System.currentTimeMillis() - 300000L;
                        long _to = from != 0L ? to : System.currentTimeMillis();
                        Display display = Display.getCurrent();
                        if (display == null) {
                            display = Display.getDefault();
                        }
                        Clipboard clipboard = new Clipboard(display);
                        String linkUrl = MenuUtil.makeExternalUrl(serverId, objType, _from, _to);
                        clipboard.setContents((Object[])new String[]{linkUrl}, new Transfer[]{TextTransfer.getInstance()});
                        clipboard.dispose();
                    }
                };
                mgr.add((IAction)actOutgoingClip);
            }
        });
        Menu menu = mgr.createContextMenu(control);
        control.setMenu(menu);
    }

    private static String makeExternalUrl(int serverId, String objType, long from, long to) {
        Server server = ServerManager.getInstance().getServer(serverId);
        String linkName = server.getExtLinkName();
        String linkUrl = server.getExtLinkUrlPattern();
        String objHashes = AgentModelThread.getInstance().getLiveObjectHashStringWithParent(serverId, objType);
        if (StringUtil.isEmpty((String)objHashes)) {
            return "";
        }
        linkUrl = linkUrl.replace("$[objHashes]", objHashes);
        linkUrl = linkUrl.replace("$[from]", String.valueOf(from));
        linkUrl = linkUrl.replace("$[to]", String.valueOf(to));
        linkUrl = linkUrl.replace("$[objType]", objType);
        return linkUrl;
    }

    public static void createCounterContextMenu(final String id, Control control, final int serverId, final int objHash, final String objType, final String counter) {
        MenuManager mgr = new MenuManager();
        mgr.setRemoveAllWhenShown(true);
        final String objName = TextProxy.object.getText(objHash);
        mgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                Action act = new OpenRealTimeViewAction(win, "Current", counter, Images.CTXMENU_RTC, objHash, objName, objType, serverId);
                if (CounterRealTimeView.ID.equals(id)) {
                    act.setEnabled(false);
                }
                mgr.add((IAction)act);
                act = new OpenTodayViewAction(win, "Today", counter, Images.CTXMENU_RDC, objHash, objName, objType, serverId);
                if (CounterRealDateView.ID.equals(id)) {
                    act.setEnabled(false);
                }
                mgr.add((IAction)act);
                mgr.add((IContributionItem)new Separator());
                act = new OpenPastTimeViewAction(win, "Past", Images.CTXMENU_RTC, objHash, objType, null, objName, counter, serverId);
                if (CounterLoadTimeView.ID.equals(id)) {
                    act.setEnabled(false);
                }
                mgr.add((IAction)act);
                act = new OpenPastDateViewAction(win, "Daily", Images.CTXMENU_RDC, objHash, objType, null, objName, counter, serverId);
                if (CounterLoadDateView.ID.equals(id)) {
                    act.setEnabled(false);
                }
                mgr.add((IAction)act);
            }
        });
        Menu menu = mgr.createContextMenu(control);
        control.setMenu(menu);
    }

    public static void addObjTypeSpecialMenu(IWorkbenchWindow win, IMenuManager mgr, int serverId, String objType, CounterEngine counterEngine) {
        if (counterEngine.isChildOf(objType, "javaee")) {
            mgr.add((IContributionItem)new Separator());
            mgr.add((IAction)new OpenRTPairAllAction(win, "Heap Memory", serverId, objType, "HeapTotUsage"));
            mgr.add((IAction)new OpenEQViewAction(win, serverId, objType));
            mgr.add((IAction)new OpenVerticalEQViewAction(win, serverId, objType));
            mgr.add((IAction)new OpenActiveServiceListAction(win, objType, Images.thread, serverId));
            mgr.add((IAction)new OpenActiveSpeedAction(win, objType, Images.TYPE_ACTSPEED, serverId));
            mgr.add((IAction)new OpenXLogRealTimeAction(win, "XLog", objType, Images.star, serverId));
            mgr.add((IAction)new OpenTodayServiceCountAction(win, "24H Service Count", objType, "ServiceCount", Images.bar, serverId));
            MenuManager serviceGroupMgr = new MenuManager("Serivce Group", ImageUtil.getImageDescriptor(Images.sum), "scouter.menu.id.javee.servicegroup");
            mgr.add((IContributionItem)serviceGroupMgr);
            serviceGroupMgr.add((IAction)new OpenServiceGroupTPSAction(win, serverId, objType));
            serviceGroupMgr.add((IAction)new OpenServiceGroupElapsedAction(win, serverId, objType));
            mgr.add((IAction)new OpenUniqueTotalVisitorAction(win, serverId, objType));
            mgr.add((IAction)new OpenTypeSummaryAction(win, serverId, objType));
            mgr.add((IAction)new OpenRTPairAllAction(win, "File Descriptor", serverId, objType, "FdUsage"));
        } else if (counterEngine.isChildOf(objType, "golang")) {
            mgr.add((IContributionItem)new Separator());
            mgr.add((IAction)new OpenEQViewAction(win, serverId, objType));
            mgr.add((IAction)new OpenVerticalEQViewAction(win, serverId, objType));
            mgr.add((IAction)new OpenActiveServiceListAction(win, objType, Images.thread, serverId));
            mgr.add((IAction)new OpenXLogRealTimeAction(win, "XLog", objType, Images.star, serverId));
        } else if (counterEngine.isChildOf(objType, "datasource")) {
            mgr.add((IContributionItem)new Separator());
            mgr.add((IAction)new OpenRTPairAllAction2(win, "Pool Chart", serverId, objType, "ConnMax", "ConnActive"));
        } else if (counterEngine.isChildOf(objType, "tracing")) {
            mgr.add((IContributionItem)new Separator());
            mgr.add((IAction)new OpenXLogRealTimeAction(win, "XLog", objType, Images.star, serverId));
        }
    }

    public static void addPastObjTypeSpecialMenu(IWorkbenchWindow win, IMenuManager mgr, int serverId, String objType, CounterEngine counterEngine, String date) {
        long st = DateUtil.yyyymmdd((String)date);
        long et = st + 300000L;
        if (counterEngine.isChildOf(objType, "javaee")) {
            mgr.add((IContributionItem)new Separator());
            mgr.add((IAction)new OpenXLogLoadTimeAction(win, objType, Images.transrealtime, serverId, st, et));
            mgr.add((IAction)new OpenDailyServiceCountAction(win, objType, "ServiceCount", Images.TYPE_SERVICE_COUNT, serverId, date));
        } else if (counterEngine.isChildOf(objType, "golang")) {
            mgr.add((IContributionItem)new Separator());
            mgr.add((IAction)new OpenXLogLoadTimeAction(win, objType, Images.transrealtime, serverId, st, et));
        }
    }
}

