/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.util;

import java.io.BufferedWriter;
import java.io.FileWriter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import scouter.client.util.ConsoleProxy;

public class MyKeyAdapter
extends KeyAdapter {
    private String fileName = "";
    private Shell superShell = null;

    public MyKeyAdapter(Shell shell, String fname) {
        this.fileName = fname;
        this.superShell = shell;
    }

    public void save(String file, String value) throws Exception {
        BufferedWriter bw = new BufferedWriter(new FileWriter(file, true));
        bw.write(value);
        bw.close();
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void keyPressed(KeyEvent ev) {
        if (ev.stateMask == 262144) {
            if (ev.keyCode == 97) {
                if (ev.widget instanceof Text) {
                    ((Text)ev.widget).selectAll();
                } else if (ev.widget instanceof StyledText) {
                    ((StyledText)ev.widget).selectAll();
                }
            } else if (ev.keyCode == 115) {
                FileDialog dialog = new FileDialog(this.superShell, 8192);
                dialog.setFileName(this.fileName);
                String file = dialog.open();
                if (file == null) {
                    return;
                }
                try {
                    if (ev.widget instanceof Text) {
                        this.save(file, ((Text)ev.widget).getText());
                    } else if (ev.widget instanceof StyledText) {
                        this.save(file, ((StyledText)ev.widget).getText());
                    }
                }
                catch (Exception ex) {
                    ConsoleProxy.errorSafe(ex.toString());
                }
            }
        }
        super.keyPressed(ev);
    }
}

