/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class RCPUtil {
    public static boolean isEclipseIdeRunning() {
        IProduct product = Platform.getProduct();
        if (product == null) {
            return false;
        }
        return "org.eclipse.sdk.ide".equals(product.getId()) && "org.eclipse.ui.ide.workbench".equals(product.getApplication());
    }

    public static void preLoadingPerspective(String[] ids) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page != null) {
            IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
            IPerspectiveDescriptor active = page.getPerspective();
            int idx = ids.length - 1;
            while (idx >= 0) {
                if (active == null || !active.getId().equals(ids[idx])) {
                    IPerspectiveDescriptor perspective = registry.findPerspectiveWithId(ids[idx]);
                    page.setPerspective(perspective);
                }
                --idx;
            }
            page.setPerspective(active);
        }
    }

    public static void hideActions(String[] ids) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        int idx = 0;
        while (idx < ids.length) {
            page.hideActionSet(ids[idx]);
            ++idx;
        }
    }

    public static void resetPerspective() {
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            if (pages != null && pages.length >= 1) {
                int j = 0;
                while (j < pages.length) {
                    pages[j].resetPerspective();
                    ++j;
                }
            }
            ++i;
        }
    }

    public static void hidePreference(String[] ids) {
        PreferenceManager preferenceManager = PlatformUI.getWorkbench().getPreferenceManager();
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            preferenceManager.remove(id);
            ++n2;
        }
    }

    public static void hidePerspectives(String[] ids) {
        IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor[] descriptors = registry.getPerspectives();
        List<String> ignoredPerspectives = Arrays.asList(ids);
        ArrayList<IPerspectiveDescriptor> removePerspectiveDesc = new ArrayList<IPerspectiveDescriptor>();
        IPerspectiveDescriptor[] iPerspectiveDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IPerspectiveDescriptor desc = iPerspectiveDescriptorArray[n2];
            if (ignoredPerspectives.contains(desc.getId())) {
                removePerspectiveDesc.add(desc);
            }
            ++n2;
        }
        if (registry instanceof IExtensionChangeHandler && !removePerspectiveDesc.isEmpty()) {
            IExtensionChangeHandler extChgHandler = (IExtensionChangeHandler)registry;
            extChgHandler.removeExtension(null, removePerspectiveDesc.toArray());
        }
    }

    public static void printPreferencePages() {
        System.out.println("=== PreferencePages ===");
        PreferenceManager preferenceManager = PlatformUI.getWorkbench().getPreferenceManager();
        List preferenceNodes = preferenceManager.getElements(0);
        for (IPreferenceNode preferenceNode : preferenceNodes) {
            System.out.println(preferenceNode.getId());
        }
    }

    public static void printPerspectives() {
        System.out.println("=== Perspectives ===");
        IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor[] descriptors = registry.getPerspectives();
        int idx = 0;
        while (idx < descriptors.length) {
            System.out.println(descriptors[idx].getId());
            ++idx;
        }
    }

    public static void printViews() {
        System.out.println("=== Views ===");
        IViewRegistry registry = PlatformUI.getWorkbench().getViewRegistry();
        IViewDescriptor[] descriptors = registry.getViews();
        int idx = 0;
        while (idx < descriptors.length) {
            System.out.println(descriptors[idx].getId());
            ++idx;
        }
    }

    public static void exit() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && !workbench.isClosing()) {
            workbench.close();
        }
    }

    public static void restart() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && !workbench.isClosing()) {
            workbench.restart();
        }
    }

    public static File getWorkingDirectory() {
        IPath workingPath = Platform.getLocation();
        File workingDir = workingPath.toFile();
        return workingDir;
    }

    public static void openPerspective(String perspectiveID) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            PlatformUI.getWorkbench().showPerspective(perspectiveID, window, null);
        }
        catch (WorkbenchException e) {
            e.printStackTrace();
        }
    }
}

