/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.util;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.DoubleFunction;
import java.util.function.ToDoubleFunction;
import org.csstudio.swt.xygraph.dataprovider.IDataProvider;
import org.csstudio.swt.xygraph.dataprovider.ISample;
import org.csstudio.swt.xygraph.figures.PlotArea;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.csstudio.swt.xygraph.undo.ZoomType;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import scouter.client.Images;
import scouter.client.group.GroupManager;
import scouter.client.model.AgentModelThread;
import scouter.client.model.AgentObject;
import scouter.client.net.INetReader;
import scouter.client.net.TcpProxy;
import scouter.client.util.ImageUtil;
import scouter.client.util.TimeUtil;
import scouter.client.util.TimedSeries;
import scouter.io.DataInputX;
import scouter.lang.TimeTypeEnum;
import scouter.lang.pack.MapPack;
import scouter.lang.pack.Pack;
import scouter.lang.value.ListValue;
import scouter.lang.value.Value;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.FormatUtil;
import scouter.util.LinkedMap;

public class ScouterUtil {
    static Set<String> liveMenuSet = new HashSet<String>();
    public static DoubleFunction<Comparator<Trace>> comparatorByTime;

    static {
        liveMenuSet.add("rt");
        liveMenuSet.add("td");
        liveMenuSet.add("rt-all");
        liveMenuSet.add("rt-tot");
        liveMenuSet.add("td-all");
        liveMenuSet.add("td-tot");
        comparatorByTime = time -> (t1, t2) -> {
            ISample sample1 = ScouterUtil.getNearestPoint(t1.getDataProvider(), time);
            ISample sample2 = ScouterUtil.getNearestPoint(t2.getDataProvider(), time);
            return Double.compare(sample2.getYValue(), sample1.getYValue());
        };
    }

    public static String listToComma(List list) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < list.size()) {
            sb.append(String.valueOf(list.get(i)));
            if (i < list.size() - 1) {
                sb.append(",");
            }
            ++i;
        }
        return sb.toString();
    }

    public static double getRealTotalValue(String counter, List<Pack> result, String mode) {
        int count = 0;
        double value = 0.0;
        for (Pack p : result) {
            MapPack m = (MapPack)p;
            ListValue valueLv = m.getList("value");
            int i = 0;
            while (i < valueLv.size()) {
                value += CastUtil.cdouble((Object)valueLv.get(i));
                ++count;
                ++i;
            }
        }
        if (count > 0 && "avg".equals(mode)) {
            value /= (double)count;
        }
        return value;
    }

    private static double getRealElapsedAvgValue(List<Pack> result) {
        double totalValue = 0.0;
        double tpsSum = 0.0;
        for (Pack p : result) {
            MapPack m = (MapPack)p;
            ListValue objHashLv = m.getList("objHash");
            ListValue valueLv = m.getList("value");
            int i = 0;
            while (i < objHashLv.size()) {
                int objHash = (int)objHashLv.getLong(i);
                double elapsed = CastUtil.cdouble((Object)valueLv.get(i));
                AgentObject agent = AgentModelThread.getInstance().getAgentObject(objHash);
                if (agent != null) {
                    ArrayList tpsValue;
                    block9: {
                        tpsValue = new ArrayList(1);
                        TcpProxy tcp = TcpProxy.getTcpProxy(agent.getServerId());
                        try {
                            try {
                                MapPack param = new MapPack();
                                param.put("objHash", (long)objHash);
                                param.put("counter", "TPS");
                                param.put("timetype", 1L);
                                tcp.process("COUNTER_REAL_TIME", param, new INetReader(){

                                    @Override
                                    public void process(DataInputX in) throws IOException {
                                        Value v = in.readValue();
                                        if (v != null && v.getValueType() != 0) {
                                            tpsValue.add(CastUtil.cdouble((Object)v));
                                        }
                                    }
                                });
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                TcpProxy.putTcpProxy(tcp);
                                break block9;
                            }
                        }
                        catch (Throwable throwable) {
                            TcpProxy.putTcpProxy(tcp);
                            throw throwable;
                        }
                        TcpProxy.putTcpProxy(tcp);
                    }
                    double tps = (Double)tpsValue.get(0);
                    totalValue += elapsed * tps;
                    tpsSum += tps;
                }
                ++i;
            }
        }
        if (totalValue == 0.0 || tpsSum == 0.0) {
            return 0.0;
        }
        return totalValue / tpsSum;
    }

    public static Map<Long, Double> getLoadTotalMap(String counter, List<Pack> result, String mode, byte timeTypeCode) {
        long now = TimeUtil.getCurrentTime();
        TimedSeries<Integer, Double> sereis = new TimedSeries<Integer, Double>();
        block0: for (Pack p : result) {
            MapPack m = (MapPack)p;
            int objHash = m.getInt("objHash");
            ListValue timeLv = m.getList("time");
            ListValue valueLv = m.getList("value");
            int i = 0;
            while (i < timeLv.size()) {
                long time = CastUtil.clong((Object)timeLv.get(i));
                double value = CastUtil.cdouble((Object)valueLv.get(i));
                if (time > now) continue block0;
                sereis.add(objHash, time, value);
                ++i;
            }
        }
        HashMap<Long, Double> tempMap = new HashMap<Long, Double>();
        if (sereis.getSeriesCount() > 0) {
            long stime = sereis.getMinTime();
            long etime = sereis.getMaxTime();
            boolean isAvg = "avg".equals(mode);
            while (stime <= etime) {
                double sum = 0.0;
                List list = sereis.getInTimeList(stime, ScouterUtil.getKeepTime(timeTypeCode));
                int i = 0;
                while (i < list.size()) {
                    sum += ((Double)list.get(i)).doubleValue();
                    ++i;
                }
                if (isAvg) {
                    if (list.size() > 0) {
                        tempMap.put(stime, sum / (double)list.size());
                    }
                } else {
                    tempMap.put(stime, sum);
                }
                stime += (long)TimeTypeEnum.getTime((byte)timeTypeCode);
            }
        }
        return new TreeMap<Long, Double>(tempMap);
    }

    public static Map<Long, Double> getLoadMinOrMaxMap(List<Pack> result, String mode, byte timeTypeCode) {
        long now = TimeUtil.getCurrentTime();
        TimedSeries<Integer, Double> sereis = new TimedSeries<Integer, Double>();
        block0: for (Pack p : result) {
            MapPack m = (MapPack)p;
            int objHash = m.getInt("objHash");
            ListValue timeLv = m.getList("time");
            ListValue valueLv = m.getList("value");
            int i = 0;
            while (i < timeLv.size()) {
                long time = CastUtil.clong((Object)timeLv.get(i));
                double value = CastUtil.cdouble((Object)valueLv.get(i));
                if (time > now) continue block0;
                sereis.add(objHash, time, value);
                ++i;
            }
        }
        HashMap<Long, Double> tempMap = new HashMap<Long, Double>();
        if (sereis.getSeriesCount() > 0) {
            long stime = sereis.getMinTime();
            long etime = sereis.getMaxTime();
            boolean isMinMode = "min".equalsIgnoreCase(mode);
            while (stime <= etime) {
                double pivot = isMinMode ? Double.MAX_VALUE : Double.MIN_VALUE;
                List list = sereis.getInTimeList(stime, ScouterUtil.getKeepTime(timeTypeCode));
                int i = 0;
                while (i < list.size()) {
                    double v = (Double)list.get(i);
                    if (isMinMode && pivot > v) {
                        pivot = v;
                    } else if (!isMinMode && v > pivot) {
                        pivot = v;
                    }
                    ++i;
                }
                if (list.size() > 0) {
                    tempMap.put(stime, pivot);
                }
                stime += (long)TimeTypeEnum.getTime((byte)timeTypeCode);
            }
        }
        return new TreeMap<Long, Double>(tempMap);
    }

    private static long getKeepTime(byte timeType) {
        switch (timeType) {
            case 1: {
                return 10000L;
            }
            case 2: {
                return 63000L;
            }
            case 3: {
                return 303000L;
            }
            case 4: {
                return 603000L;
            }
            case 5: {
                return 3603000L;
            }
        }
        return 300000L;
    }

    public static void addShowTotalValueListener(FigureCanvas canvas, final XYGraph xyGraph) {
        final DefaultToolTip toolTip = new DefaultToolTip((Control)canvas, 1, true);
        toolTip.setFont(new Font(null, "Arial", 10, 1));
        toolTip.setBackgroundColor(Display.getCurrent().getSystemColor(29));
        canvas.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                toolTip.hide();
            }

            public void mouseDown(MouseEvent e) {
                int y2;
                int x2;
                double distance;
                double x = xyGraph.primaryXAxis.getPositionValue(e.x, false);
                double y = xyGraph.primaryYAxis.getPositionValue(e.y, false);
                if (x < 0.0 || y < 0.0) {
                    return;
                }
                double minDistance = 30.0;
                long time = 0L;
                double value = 0.0;
                Trace t = xyGraph.getPlotArea().getTraceList().get(0);
                if (t == null) {
                    return;
                }
                ISample s = ScouterUtil.getNearestPoint(t.getDataProvider(), x);
                if (s != null && minDistance > (distance = ScouterUtil.getPointDistance(e.x, e.y, x2 = xyGraph.primaryXAxis.getValuePosition(s.getXValue(), false), y2 = xyGraph.primaryYAxis.getValuePosition(s.getYValue(), false)))) {
                    minDistance = distance;
                    time = (long)s.getXValue();
                    value = s.getYValue();
                }
                if (t != null) {
                    toolTip.setText("Time : " + DateUtil.format((long)time, (String)"HH:mm:ss") + "\nValue : " + FormatUtil.print((Object)value, (String)"#,###.##"));
                    toolTip.show(new Point(e.x, e.y));
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    public static void collectGroupObjcts(String grpName, Map<Integer, ListValue> serverObjMap) {
        serverObjMap.clear();
        Set<Integer> objHashs = GroupManager.getInstance().getObjectsByGroup(grpName);
        for (int objHash : objHashs) {
            AgentObject agentObj = AgentModelThread.getInstance().getAgentObject(objHash);
            if (agentObj == null) continue;
            int serverId = agentObj.getServerId();
            ListValue lv = serverObjMap.get(serverId);
            if (lv == null) {
                lv = new ListValue();
                serverObjMap.put(serverId, lv);
            }
            lv.add((long)objHash);
        }
    }

    public static String getFullObjName(int objHash) {
        try {
            AgentObject agent = AgentModelThread.getInstance().getAgentObject(objHash);
            String objName = agent.getObjName();
            return objName;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getShortObjName(int objHash) {
        try {
            AgentObject agent = AgentModelThread.getInstance().getAgentObject(objHash);
            String objName = agent.getObjName();
            if (objName.lastIndexOf("/") > -1) {
                objName = objName.substring(objName.lastIndexOf("/") + 1, objName.length());
            }
            return objName;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static boolean isLiveMenu(String menu) {
        boolean result = false;
        if (liveMenuSet.contains(menu)) {
            result = true;
        }
        return result;
    }

    public static String getActionName(String key) {
        if ("rt-all".equals(key) || "pt-all".equals(key)) {
            return "Time All";
        }
        if ("rt-tot".equals(key) || "pt-tot".equals(key)) {
            return "Time Total";
        }
        if ("td-all".equals(key) || "pd-all".equals(key)) {
            return "Daily All";
        }
        if ("td-tot".equals(key) || "pd-tot".equals(key)) {
            return "Daily Total";
        }
        return "";
    }

    public static ImageDescriptor getActionIconName(String key) {
        if ("rt-all".equals(key) || "td-all".equals(key)) {
            return ImageUtil.getImageDescriptor(Images.all);
        }
        if ("rt-tot".equals(key) || "td-tot".equals(key)) {
            return ImageUtil.getImageDescriptor(Images.sum);
        }
        if ("pt-all".equals(key) || "pd-all".equals(key)) {
            return ImageUtil.getImageDescriptor(Images.all);
        }
        if ("pt-tot".equals(key) || "pd-tot".equals(key)) {
            return ImageUtil.getImageDescriptor(Images.sum);
        }
        return null;
    }

    public static String mapPackToTableString(MapPack m) {
        if (m == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<String> keyList = new ArrayList<String>();
        HashMap<Integer, Integer> maxLenMap = new HashMap<Integer, Integer>();
        LinkedMap valueMap = new LinkedMap();
        int width = 1;
        Iterator itr = m.keys();
        int index = 0;
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Value v = m.get(key);
            int maxLen = key.length();
            if (!(v instanceof ListValue)) continue;
            ListValue lv = (ListValue)v;
            int i = 0;
            while (i < lv.size()) {
                ArrayList<String> list;
                String s = lv.get(i).toString();
                if (s.length() > maxLen) {
                    maxLen = s.length();
                }
                if ((list = (ArrayList<String>)valueMap.get((Object)i)) == null) {
                    list = new ArrayList<String>();
                    valueMap.put((Object)i, list);
                }
                list.add(s);
                ++i;
            }
            width += maxLen + 3;
            maxLenMap.put(index, maxLen);
            keyList.add(key);
            ++index;
        }
        if (keyList.size() > 0) {
            sb.append("\n+");
            int i = 0;
            while (i < width - 2) {
                sb.append("-");
                ++i;
            }
            sb.append("+\n");
            sb.append("|");
            i = 0;
            while (i < keyList.size()) {
                int maxLen = (Integer)maxLenMap.get(i);
                String key = (String)keyList.get(i);
                sb.append(" " + key);
                int gap = maxLen - key.length();
                while (gap > 0) {
                    sb.append(" ");
                    --gap;
                }
                sb.append(" |");
                ++i;
            }
            sb.append("\n");
            i = 0;
            while (i < width) {
                sb.append("-");
                ++i;
            }
            sb.append("\n");
            while (valueMap.size() > 0) {
                ArrayList list = (ArrayList)valueMap.removeFirst();
                sb.append("|");
                int i2 = 0;
                while (i2 < list.size()) {
                    int maxLen = (Integer)maxLenMap.get(i2);
                    String s = (String)list.get(i2);
                    sb.append(" " + s);
                    int gap = maxLen - s.length();
                    while (gap > 0) {
                        sb.append(" ");
                        --gap;
                    }
                    sb.append(" |");
                    ++i2;
                }
                sb.append("\n");
                if (valueMap.size() == 0) {
                    sb.append("+");
                    i2 = 0;
                    while (i2 < width - 2) {
                        sb.append("-");
                        ++i2;
                    }
                    sb.append("+\n");
                    continue;
                }
                i2 = 0;
                while (i2 < width) {
                    sb.append("-");
                    ++i2;
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public static double getNearestValue(IDataProvider provider, double time) {
        double lowGqp;
        int high = provider.getSize() - 1;
        int low = 0;
        do {
            int mid;
            ISample s;
            double x;
            if ((x = (s = provider.getSample(mid = (high + low) / 2)).getXValue()) == time) {
                return s.getYValue();
            }
            if (x > time) {
                high = mid;
                continue;
            }
            low = mid;
        } while (high - low > 1);
        ISample highSample = provider.getSample(high);
        ISample lowSample = provider.getSample(low);
        if (highSample == null && lowSample == null) {
            return 0.0;
        }
        if (highSample == null) {
            return lowSample.getYValue();
        }
        if (lowSample == null) {
            return highSample.getYValue();
        }
        double highGap = highSample.getXValue() - time;
        if (highGap < (lowGqp = time - lowSample.getXValue())) {
            return highSample.getYValue();
        }
        return lowSample.getYValue();
    }

    public static ISample getNearestPoint(IDataProvider provider, double time) {
        int high = provider.getSize() - 1;
        int low = 0;
        while (high >= low) {
            double lowGqp;
            int mid = (high + low) / 2;
            ISample s = provider.getSample(mid);
            double x = s.getXValue();
            if (x == time) {
                return s;
            }
            if (x > time) {
                high = mid;
            } else {
                low = mid;
            }
            if (high - low > 1) continue;
            ISample highSample = provider.getSample(high);
            ISample lowSample = provider.getSample(low);
            if (highSample == null && lowSample == null) {
                return null;
            }
            if (highSample == null) {
                return lowSample;
            }
            if (lowSample == null) {
                return highSample;
            }
            double highGap = highSample.getXValue() - time;
            if (highGap < (lowGqp = time - lowSample.getXValue())) {
                return highSample;
            }
            return lowSample;
        }
        return null;
    }

    public static String humanReadableByteCount(long bytes, boolean si) {
        int unit = 1024;
        if (bytes < (long)unit) {
            return String.valueOf(bytes) + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = String.valueOf("KMGTPE".charAt(exp - 1)) + (si ? "" : "i");
        return String.format("%.1f %s", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static String humanReadableByteCount(double bytes, boolean si) {
        int unit = 1024;
        if (bytes < (double)unit) {
            return String.valueOf(bytes) + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = String.valueOf("KMGTPE".charAt(exp - 1)) + (si ? "" : "i");
        return String.format("%.1f %s", bytes / Math.pow(unit, exp), pre);
    }

    public static void addHorizontalRangeListener(PlotArea plotArea, PropertyChangeListener listener, boolean withZoom) {
        plotArea.setZoomType(ZoomType.HORIZONTAL_ZOOM);
        plotArea.enableZoom(withZoom);
        plotArea.addPropertyChangeListener("horizontal_range", listener);
    }

    public static double getPointDistance(double x1, double y1, double x2, double y2) {
        return Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0));
    }

    public static ToDoubleFunction<Trace> nearestPointYValueFunc(double time) {
        return t -> ScouterUtil.getNearestValue(t.getDataProvider(), time);
    }
}

