/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.util;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import scouter.client.util.ExUtil;
import scouter.util.ThreadUtil;

public class SpinnerThread
extends Thread {
    static ImageLoader imageLoader = new ImageLoader();
    static final ImageData[] imageDatas = imageLoader.load(SpinnerThread.class.getResourceAsStream("/icons/spinner64.gif"));
    int frameIndex = 0;
    private Composite parent;
    private Canvas canvas;
    private GC gc;

    public SpinnerThread(Composite parent, Object layoutData) {
        this.parent = parent;
        this.setName(ThreadUtil.getName((Thread)this));
        final Image image = new Image((Device)parent.getDisplay(), SpinnerThread.imageDatas[0].width, SpinnerThread.imageDatas[0].height);
        this.canvas = new Canvas(parent, 0);
        if (layoutData != null) {
            this.canvas.setLayoutData(layoutData);
        }
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.drawImage(image, 0, 0);
            }
        });
        this.gc = new GC((Drawable)image);
    }

    @Override
    public void run() {
        while (!this.parent.isDisposed() && !this.isInterrupted()) {
            this.frameIndex %= imageDatas.length;
            final ImageData imageData = imageDatas[this.frameIndex];
            ExUtil.exec(this.parent, new Runnable(){

                @Override
                public void run() {
                    Image frame = new Image((Device)SpinnerThread.this.parent.getDisplay(), imageData);
                    SpinnerThread.this.gc.drawImage(frame, imageData.x, imageData.y);
                    frame.dispose();
                    SpinnerThread.this.canvas.redraw();
                }
            });
            try {
                Thread.sleep(SpinnerThread.imageDatas[this.frameIndex].delayTime * 10);
            }
            catch (InterruptedException e) {
                return;
            }
            ++this.frameIndex;
        }
    }
}

