/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.util;

import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Display;
import scouter.util.StringUtil;

public class SqlFormatUtil {
    public static String[] key = new String[]{"select", "update", "insert", "delete", "from", "where", "between", "commit", "set", "join", "having", "group", "by", "create", "default", "use", "desc", "alter", "fetch", "order", "and", "or", "as", "round", "decode", "nvl", "instr", "sysdate", "sum", "rownum", "in", "left", "outer", "close", "continue", "into", "values", "now()"};

    public static void applyStyledFormat(StyledText text, String sql) {
        if (StringUtil.isEmpty((String)sql)) {
            return;
        }
        text.setText(sql);
        text.addLineStyleListener(new LineStyleListener(){

            public void lineGetStyle(LineStyleEvent event) {
                String line = event.lineText;
                LinkedList<StyleRange> list = new LinkedList<StyleRange>();
                String[] tokens = StringUtil.tokenizer((String)(line = line.toLowerCase()), (String)" \n\r\f\t()+*/-=<>'`\"[],");
                if (tokens == null) {
                    return;
                }
                HashSet<String> set = new HashSet<String>();
                int i = 0;
                while (i < tokens.length) {
                    set.add(tokens[i]);
                    ++i;
                }
                i = 0;
                while (i < key.length) {
                    if (set.contains(key[i])) {
                        int cursor = -1;
                        while ((cursor = line.indexOf(key[i], cursor + 1)) > -1) {
                            StyleRange sr = new StyleRange();
                            sr.start = event.lineOffset + cursor;
                            sr.length = key[i].length();
                            sr.foreground = Display.getCurrent().getSystemColor(9);
                            list.add(sr);
                        }
                    }
                    ++i;
                }
                event.styles = list.toArray(new StyleRange[list.size()]);
            }
        });
    }
}

