/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.util;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scouter.util.StringUtil;

public class SqlMakerUtil {
    public static String SQLDIVIDE = "\r\n\r\n[Bind Variables]\r\n";
    static Pattern pattern = Pattern.compile("\\@\\{\\d+\\}");

    public static String bindSQL(String sqlText, String params) {
        if (params == null || "".equals(params)) {
            return sqlText;
        }
        ArrayList<String> binds = SqlMakerUtil.divideParams(params);
        if (binds == null || binds.size() == 0) {
            return sqlText;
        }
        int bindLength = binds.size();
        if (sqlText == null || sqlText.length() == 0) {
            return "No SQL Text";
        }
        String newSqlText = SqlMakerUtil.convertBindVariable(sqlText);
        StringBuilder sqlBuilder = new StringBuilder();
        int index = 0;
        int pos = 0;
        Matcher m = pattern.matcher(newSqlText);
        while (m.find()) {
            sqlBuilder.append(newSqlText.substring(pos, m.start())).append(StringUtil.stripSideChar((String)binds.get(index), (char)'\''));
            pos = m.end();
            ++index;
        }
        sqlBuilder.append(newSqlText.substring(pos));
        if (index < bindLength) {
            sqlBuilder.append(SQLDIVIDE);
            int inx = 1;
            int i = index;
            while (i < bindLength) {
                sqlBuilder.append(':').append(inx).append(" - ").append(binds.get(i)).append("\r\n");
                ++inx;
                ++i;
            }
        }
        return sqlBuilder.toString();
    }

    private static String convertBindVariable(String sqlText) {
        StringBuilder sb = new StringBuilder(sqlText.length() + 40);
        int sqlLength = sqlText.length();
        int index = 1;
        int pos = 0;
        while (pos < sqlLength) {
            int search = sqlText.indexOf(63, pos);
            if (search < 0) {
                sb.append(sqlText.substring(pos));
                break;
            }
            sb.append(sqlText.substring(pos, search)).append(':').append(index);
            ++index;
            pos = search + 1;
        }
        return sb.toString();
    }

    private static String errorMessage(StringBuilder sb, String sqlText, String param, String error, int pos, int search, boolean isChar) {
        sb.append(sqlText.substring(pos, search));
        sb.append('[').append(error).append('-').append(param).append(']').append(sqlText.substring(search));
        return "Fail to convert =>\r\n" + sb.toString();
    }

    private static ArrayList<String> divideParams(String params) {
        if (params == null || "".equals(params.trim())) {
            return null;
        }
        ArrayList<String> binds = new ArrayList<String>();
        int start = 0;
        boolean isQ = false;
        boolean isDQ = false;
        int size = params.length();
        int i = 0;
        while (i < size) {
            char ch = params.charAt(i);
            if (ch == ',' && !isQ && !isDQ) {
                binds.add(params.substring(start, i));
                start = i + 1;
            } else if (ch == '\'' || ch == '\"') {
                if (ch == '\'') {
                    isQ = !isQ;
                } else if (ch == '\"') {
                    isDQ = !isDQ;
                }
            }
            ++i;
        }
        binds.add(params.substring(start));
        return binds;
    }

    public static UnescapedSQL unescapeLiteralSQL(String sql, String params) {
        if (StringUtil.isEmpty((String)sql) || StringUtil.isEmpty((String)params)) {
            return new UnescapedSQL(sql, params);
        }
        ArrayList<String> paramList = SqlMakerUtil.divideParams(params);
        StringBuilder sqlBuilder = new StringBuilder();
        int index = 0;
        int pos = 0;
        Matcher m = pattern.matcher(sql);
        while (m.find()) {
            sqlBuilder.append(sql.substring(pos, m.start())).append(StringUtil.stripSideChar((String)paramList.get(index), (char)'\''));
            pos = m.end();
            ++index;
        }
        sqlBuilder.append(sql.substring(pos));
        String sqlParam = null;
        if (index < paramList.size()) {
            StringBuffer sb = new StringBuffer();
            while (index < paramList.size()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(paramList.get(index));
                ++index;
            }
            sqlParam = sb.toString();
        }
        return new UnescapedSQL(sqlBuilder.toString(), sqlParam);
    }

    public static String replaceSQLParameter(String sql, String params) {
        UnescapedSQL unescapedSql = SqlMakerUtil.unescapeLiteralSQL(sql, params);
        sql = unescapedSql.sql;
        params = unescapedSql.param;
        if (StringUtil.isEmpty((String)sql) || StringUtil.isEmpty((String)params)) {
            return sql;
        }
        ArrayList<String> paramList = SqlMakerUtil.divideParams(params);
        StringBuilder sqlBuilder = new StringBuilder();
        int sqlLength = sql.length();
        int index = 0;
        int pos = 0;
        try {
            while (pos < sqlLength) {
                int search = sql.indexOf(63, pos);
                if (search < 0) {
                    sqlBuilder.append(sql.substring(pos));
                    break;
                }
                sqlBuilder.append(sql.substring(pos, search)).append(paramList.get(index));
                ++index;
                pos = search + 1;
            }
        }
        catch (Exception e) {
            return ">>>> Failed bind parameter : " + e.getMessage();
        }
        return sqlBuilder.toString();
    }

    public static void main(String[] args) {
        try {
            System.out.println(SqlMakerUtil.convertBindVariable("?sel?ect =? test???-?-?"));
            String sql = "select @,@,@ from emp where emp_id=? and sex=?";
            String param = "age,weight,score,1234,'M'";
            System.out.println(SqlMakerUtil.replaceSQLParameter(sql, param));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static class UnescapedSQL {
        public String sql;
        public String param;

        public UnescapedSQL(String sql, String param) {
            this.sql = sql;
            this.param = param;
        }

        public String toString() {
            return "UnescapedSQL [sql=" + this.sql + ", param=" + this.param + "]";
        }
    }
}

