/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.util;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableControlAdapter
extends ControlAdapter {
    Table table;
    TableColumn[] cols;
    int[] colWidthRatio;

    public TableControlAdapter(Table table, TableColumn[] cols, int[] colWidthRatio) {
        this.table = table;
        this.cols = cols;
        this.colWidthRatio = colWidthRatio;
    }

    public void controlResized(ControlEvent e) {
        Rectangle area;
        if (e.widget instanceof Composite) {
            area = ((Composite)e.widget).getClientArea();
        } else if (e.widget instanceof Table) {
            area = ((Table)e.widget).getClientArea();
        } else {
            return;
        }
        Point preferredSize = this.table.computeSize(-1, -1);
        int width = area.width - 2 * this.table.getBorderWidth();
        if (preferredSize.y > area.height + this.table.getHeaderHeight()) {
            Point vBarSize = this.table.getVerticalBar().getSize();
            width -= vBarSize.x;
        }
        Point oldSize = this.table.getSize();
        if (oldSize.x > area.width) {
            this.adjustColumnSize(width - 20);
            this.table.setSize(area.width, area.height);
        } else {
            this.table.setSize(area.width, area.height);
            this.adjustColumnSize(width - 20);
        }
        super.controlResized(e);
    }

    private void adjustColumnSize(int width) {
        int fullWidthColIndex = -1;
        int extraWidthSum = -1;
        int i = 0;
        while (i < this.colWidthRatio.length) {
            int ratio = this.colWidthRatio[i];
            if (ratio != -1) {
                this.cols[i].setWidth(width / ratio);
                extraWidthSum += this.cols[i].getWidth();
            } else {
                fullWidthColIndex = i;
            }
            ++i;
        }
        if (fullWidthColIndex != -1) {
            this.cols[fullWidthColIndex].setWidth(width - extraWidthSum);
        }
    }
}

