/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class TimedSeries<K, V> {
    private Hashtable<Object, TreeMap<Long, TimeValue>> table = new Hashtable();
    private long minTime = Long.MAX_VALUE;
    private long maxTime = Long.MIN_VALUE;

    public void add(K key, long time, V value) {
        TreeMap tree = this.table.get(key);
        if (tree == null) {
            tree = new TreeMap();
            this.table.put(key, tree);
        }
        tree.put(time, new TimeValue<V>(time, value));
        if (time > this.maxTime) {
            this.maxTime = time;
        }
        if (time < this.minTime) {
            this.minTime = time;
        }
    }

    public List<V> getInTimeList(long time) {
        return this.getInTimeList(time, Long.MAX_VALUE - time);
    }

    public List<V> getInTimeList(long time, long valid) {
        ArrayList out = new ArrayList();
        Enumeration<TreeMap<Long, TimeValue>> en = this.table.elements();
        while (en.hasMoreElements()) {
            TreeMap<Long, TimeValue> bt = en.nextElement();
            Map.Entry<Long, TimeValue> ent = bt.ceilingEntry(time);
            if (ent == null || time + valid < ent.getKey()) continue;
            out.add(ent.getValue().value);
        }
        return out;
    }

    public V get(K key, long time) {
        return this.getInTime(key, time, Long.MAX_VALUE - time);
    }

    public V getInTime(K key, long time, long valid) {
        Map.Entry<Long, TimeValue> ent;
        V out = null;
        TreeMap<Long, TimeValue> bt = this.table.get(key);
        if (bt != null && (ent = bt.ceilingEntry(time)) != null && time + valid >= ent.getKey()) {
            out = ent.getValue().value;
        }
        return out;
    }

    public int getSeriesCount() {
        return this.table.size();
    }

    public long getMinTime() {
        return this.minTime;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public static class TimeValue<V> {
        long time;
        V value;

        public TimeValue(long time, V value) {
            this.time = time;
            this.value = value;
        }
    }
}

