/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.util;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import scouter.client.util.SortUtil;
import scouter.util.CastUtil;

public class UIUtil {
    public static Point getMousePosition() {
        PointerInfo a = MouseInfo.getPointerInfo();
        Point b = a.getLocation();
        return b;
    }

    public static void setDialogDefaultFunctions(final Shell shell) {
        shell.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 2: {
                        shell.close();
                        event.detail = 0;
                        event.doit = false;
                    }
                }
            }
        });
    }

    public static TableColumn create(final Table table, int swt, String name, final int col_tot, final int col_idx, final boolean isNum, int width) {
        final TableColumn c = new TableColumn(table, swt);
        c.setText(name);
        c.setWidth(width);
        c.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TableItem[] items = table.getItems();
                boolean asc = CastUtil.cboolean((Object)c.getData("sort"));
                c.setData("sort", (Object)new Boolean(!asc));
                if (isNum) {
                    new SortUtil(asc).sort_num(items, col_idx, col_tot);
                } else {
                    new SortUtil(asc).sort_str(items, col_idx, col_tot);
                }
            }
        });
        return c;
    }

    public static TableColumn create(final Table table, int swt, String name, final int col_tot, final int col_idx, final boolean isNum, int width, final ViewWithTable viewWithTable) {
        final TableColumn c = new TableColumn(table, swt);
        c.setText(name);
        c.setWidth(width);
        c.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TableItem[] items = table.getItems();
                boolean asc = CastUtil.cboolean((Object)c.getData("sort"));
                c.setData("sort", (Object)new Boolean(!asc));
                viewWithTable.setSortCriteria(asc, col_idx, isNum);
                if (isNum) {
                    new SortUtil(asc).sort_num(items, col_idx, col_tot);
                } else {
                    new SortUtil(asc).sort_str(items, col_idx, col_tot);
                }
                int i = 0;
                while (i < items.length) {
                    viewWithTable.setTableItem(items[i]);
                    ++i;
                }
            }
        });
        return c;
    }

    public static TableColumn create(final Table table, int swt, String name, final int col_tot, final int col_idx, final boolean isNum, int width, final XLogViewWithTable xLogViewWithTable) {
        final TableColumn c = new TableColumn(table, swt);
        c.setText(name);
        c.setWidth(width);
        c.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TableItem[] items = table.getItems();
                boolean asc = CastUtil.cboolean((Object)c.getData("sort"));
                c.setData("sort", (Object)new Boolean(!asc));
                if (isNum) {
                    new SortUtil(asc).sort_num(items, col_idx, col_tot);
                } else {
                    new SortUtil(asc).sort_str(items, col_idx, col_tot);
                }
                int i = 0;
                while (i < items.length) {
                    xLogViewWithTable.setTableItem(items[i]);
                    ++i;
                }
                xLogViewWithTable.setChanges();
            }
        });
        return c;
    }

    public static FormData labelFormData(Control control) {
        FormData data = new FormData();
        data.right = control == null ? new FormAttachment(0, 5) : new FormAttachment(control, -5);
        data.top = new FormAttachment(0, 7);
        return data;
    }

    public static FormLayout formLayout(int marginHeight, int marginWidth) {
        FormLayout innerlayout = new FormLayout();
        innerlayout.marginHeight = marginHeight;
        innerlayout.marginWidth = marginWidth;
        return innerlayout;
    }

    public static FormData propertyFormData(Control control) {
        if (control == null) {
            return UIUtil.formData(0, 0, 0, 0, 100, 0, null, -1);
        }
        return UIUtil.formData(0, 0, control, 5, 100, 0, null, -1);
    }

    public static FormData propertyKeyData(Control control) {
        if (control == null) {
            return UIUtil.formData(0, 3, 0, 8, null, -1, null, -1, 200);
        }
        return UIUtil.formData(0, 3, control, 11, null, -1, null, -1, 200);
    }

    public static FormData propertyValueData(Control top, Control left) {
        if (top == null) {
            return UIUtil.formData(left, 3, 0, 6, 100, -3, null, -1);
        }
        return UIUtil.formData(left, 3, top, 10, 100, -3, null, -1);
    }

    public static FormData propertyYNValueData(Control top, Control left) {
        if (top == null) {
            return UIUtil.formData(left, 3, 0, 5, null, -1, null, -1);
        }
        return UIUtil.formData(left, 3, top, 9, null, -1, null, -1);
    }

    public static FormData formData(Object lobj, int loff, Object tobj, int toff, Object robj, int roff, Object bobj, int boff) {
        return UIUtil.formData(lobj, loff, tobj, toff, robj, roff, bobj, boff, -1);
    }

    public static FormData formData(Object lobj, int loff, Object tobj, int toff, Object robj, int roff, Object bobj, int boff, int width) {
        return UIUtil.formData(lobj, loff, tobj, toff, robj, roff, bobj, boff, width, -1);
    }

    public static FormData formData(Object lobj, int loff, Object tobj, int toff, Object robj, int roff, Object bobj, int boff, int width, int height) {
        FormData data = new FormData();
        if (lobj instanceof Control) {
            data.left = new FormAttachment((Control)lobj, loff);
        } else if (lobj instanceof Integer) {
            data.left = new FormAttachment(Integer.parseInt(lobj.toString()), loff);
        }
        if (tobj instanceof Control) {
            data.top = new FormAttachment((Control)tobj, toff);
        } else if (tobj instanceof Integer) {
            data.top = new FormAttachment(Integer.parseInt(tobj.toString()), toff);
        }
        if (robj instanceof Control) {
            data.right = new FormAttachment((Control)robj, roff);
        } else if (robj instanceof Integer) {
            data.right = new FormAttachment(Integer.parseInt(robj.toString()), roff);
        }
        if (bobj instanceof Control) {
            data.bottom = new FormAttachment((Control)bobj, boff);
        } else if (bobj instanceof Integer) {
            data.bottom = new FormAttachment(Integer.parseInt(bobj.toString()), boff);
        }
        if (width > 0) {
            data.width = width;
        }
        if (height > 0) {
            data.height = height;
        }
        return data;
    }

    public static GridData gridData(int horAlign) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = horAlign;
        return gridData;
    }

    public static int[] getScreenSize() {
        int[] size = new int[2];
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        size[0] = gd.getDisplayMode().getWidth();
        size[1] = gd.getDisplayMode().getHeight();
        return size;
    }

    public static interface ViewWithTable {
        public void setSortCriteria(boolean var1, int var2, boolean var3);

        public void setTableItem(TableItem var1);
    }

    public static interface XLogViewWithTable {
        public void setTableItem(TableItem var1);

        public void setChanges();
    }
}

