/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.util;

import java.util.Stack;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;

public class UndoRedoImpl
implements KeyListener,
ExtendedModifyListener {
    private StyledText editor;
    private UndoRedoStack<ExtendedModifyEvent> stack;
    private boolean isUndo;
    private boolean isRedo;

    public UndoRedoImpl(StyledText editor) {
        editor.addExtendedModifyListener((ExtendedModifyListener)this);
        editor.addKeyListener((KeyListener)this);
        this.editor = editor;
        this.stack = new UndoRedoStack();
    }

    public void clear() {
        this.stack.clear();
    }

    public void keyPressed(KeyEvent e) {
        boolean isAlt;
        boolean isCtrl = (e.stateMask & 0x40000) > 0 || (e.stateMask & 0x400000) > 0;
        boolean bl = isAlt = (e.stateMask & 0x10000) > 0;
        if (isCtrl && !isAlt) {
            boolean isShift;
            boolean bl2 = isShift = (e.stateMask & 0x20000) > 0;
            if (!isShift && e.keyCode == 122) {
                this.undo();
            } else if (!isShift && e.keyCode == 121 || isShift && e.keyCode == 122) {
                this.redo();
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void modifyText(ExtendedModifyEvent event) {
        if (this.isUndo) {
            this.stack.pushRedo(event);
        } else {
            this.stack.pushUndo(event);
            if (!this.isRedo) {
                this.stack.clearRedo();
            }
        }
    }

    private void undo() {
        if (this.stack.hasUndo()) {
            this.isUndo = true;
            this.revertEvent(this.stack.popUndo());
            this.isUndo = false;
        }
    }

    private void redo() {
        if (this.stack.hasRedo()) {
            this.isRedo = true;
            this.revertEvent(this.stack.popRedo());
            this.isRedo = false;
        }
    }

    private void revertEvent(ExtendedModifyEvent event) {
        this.editor.replaceTextRange(event.start, event.length, event.replacedText);
        this.editor.setSelectionRange(event.start, event.replacedText.length());
    }

    private static class UndoRedoStack<T> {
        private Stack<T> undo = new Stack();
        private Stack<T> redo = new Stack();

        public void pushUndo(T delta) {
            this.undo.add(delta);
        }

        public void pushRedo(T delta) {
            this.redo.add(delta);
        }

        public T popUndo() {
            T res = this.undo.pop();
            return res;
        }

        public T popRedo() {
            T res = this.redo.pop();
            return res;
        }

        public void clear() {
            this.undo.clear();
            this.redo.clear();
        }

        public void clearRedo() {
            this.redo.clear();
        }

        public boolean hasUndo() {
            return !this.undo.isEmpty();
        }

        public boolean hasRedo() {
            return !this.redo.isEmpty();
        }
    }
}

