/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    public static void compress(String path, String outputFileName) throws Throwable {
        File file = new File(path);
        int pos = outputFileName.lastIndexOf(".");
        if (!outputFileName.substring(pos).equalsIgnoreCase(".zip")) {
            outputFileName = String.valueOf(outputFileName) + ".zip";
        }
        if (!file.exists()) {
            throw new Exception("Not File!");
        }
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        try {
            fos = new FileOutputStream(new File(outputFileName));
            zos = new ZipOutputStream(fos);
            ZipUtil.searchDirectory(file, zos);
        }
        finally {
            if (zos != null) {
                zos.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    private static void searchDirectory(File file, ZipOutputStream zos) throws Throwable {
        ZipUtil.searchDirectory(file, file.getPath(), zos);
    }

    private static void searchDirectory(File file, String root, ZipOutputStream zos) throws Exception {
        if (file.isDirectory()) {
            File[] files;
            File[] fileArray = files = file.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                ZipUtil.searchDirectory(f, root, zos);
                ++n2;
            }
        } else {
            ZipUtil.compressZip(file, root, zos);
        }
    }

    private static void compressZip(File file, String root, ZipOutputStream zos) throws Exception {
        try (FileInputStream fis = null;){
            String zipName = file.getPath().replace(String.valueOf(root) + "\\", "");
            zipName = zipName.replace(String.valueOf(root) + "/", "");
            System.out.println("zipname:" + zipName);
            fis = new FileInputStream(file);
            ZipEntry zipentry = new ZipEntry(zipName);
            zos.putNextEntry(zipentry);
            int length = (int)file.length();
            byte[] buffer = new byte[length];
            fis.read(buffer, 0, length);
            zos.write(buffer, 0, length);
            zos.closeEntry();
        }
    }

    public static void decompress(String zipFileName, String directory) throws Throwable {
        File zipFile = new File(zipFileName);
        FileInputStream fis = null;
        ZipInputStream zis = null;
        ZipEntry zipentry = null;
        try {
            fis = new FileInputStream(zipFile);
            zis = new ZipInputStream(fis);
            while ((zipentry = zis.getNextEntry()) != null) {
                String filename = zipentry.getName();
                File file = new File(directory, filename);
                if (zipentry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                ZipUtil.createFile(file, zis);
            }
        }
        finally {
            if (zis != null) {
                zis.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
    }

    private static void createFile(File file, ZipInputStream zis) throws Throwable {
        File parentDir = new File(file.getParent());
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        Throwable throwable = null;
        Object var4_6 = null;
        try (FileOutputStream fos = new FileOutputStream(file);){
            byte[] buffer = new byte[256];
            int size = 0;
            while ((size = zis.read(buffer)) > 0) {
                fos.write(buffer, 0, size);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

