/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.ISample;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.csstudio.swt.xygraph.linearscale.Range;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.listeners.RangeMouseListener;
import scouter.client.model.RefreshThread;
import scouter.client.model.ServiceGroupColorManager;
import scouter.client.preferences.PManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.ExUtil;
import scouter.client.util.ScouterUtil;
import scouter.client.util.TimeUtil;
import scouter.client.util.UIUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.value.ListValue;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.FormatUtil;

public abstract class AbstractServiceGroupElapsedView
extends ViewPart
implements RefreshThread.Refreshable {
    public static final String ID = AbstractServiceGroupElapsedView.class.getName();
    private static final int BUFFER_SIZE = 200;
    protected RefreshThread thread;
    protected XYGraph xyGraph;
    protected FigureCanvas canvas;
    protected Map<String, Trace> traces = new HashMap<String, Trace>();
    Trace nearestTrace = null;
    private int manualRangeCount;
    private double manualY;
    boolean stopRefresh = false;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)UIUtil.formLayout(0, 0));
        this.canvas = new FigureCanvas(parent);
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.setLayoutData((Object)UIUtil.formData(0, 0, 0, 0, 100, 0, 100, 0));
        this.canvas.setBackground(ColorUtil.getInstance().getColor(1));
        this.canvas.addControlListener(new ControlListener(){
            boolean lock = false;

            public void controlResized(ControlEvent e) {
                Rectangle r = AbstractServiceGroupElapsedView.this.canvas.getClientArea();
                if (!this.lock) {
                    this.lock = true;
                    AbstractServiceGroupElapsedView.this.xyGraph.setSize(r.width, r.height);
                    this.lock = false;
                }
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        final DefaultToolTip toolTip = new DefaultToolTip((Control)this.canvas, 1, true);
        toolTip.setFont(new Font(null, "Arial", 10, 1));
        toolTip.setBackgroundColor(Display.getCurrent().getSystemColor(29));
        this.canvas.addMouseListener(new org.eclipse.swt.events.MouseListener(){

            public void mouseUp(MouseEvent e) {
                if (AbstractServiceGroupElapsedView.this.nearestTrace != null) {
                    AbstractServiceGroupElapsedView.this.nearestTrace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
                    AbstractServiceGroupElapsedView.this.nearestTrace = null;
                }
                toolTip.hide();
            }

            public void mouseDown(MouseEvent e) {
                double x = AbstractServiceGroupElapsedView.this.xyGraph.primaryXAxis.getPositionValue(e.x, false);
                double y = AbstractServiceGroupElapsedView.this.xyGraph.primaryYAxis.getPositionValue(e.y, false);
                if (x < 0.0 || y < 0.0) {
                    return;
                }
                double minDistance = 30.0;
                long time = 0L;
                double value = 0.0;
                for (Trace t : AbstractServiceGroupElapsedView.this.traces.values()) {
                    int y2;
                    int x2;
                    double distance;
                    ISample s = ScouterUtil.getNearestPoint(t.getDataProvider(), x);
                    if (s == null || !(minDistance > (distance = ScouterUtil.getPointDistance(e.x, e.y, x2 = AbstractServiceGroupElapsedView.this.xyGraph.primaryXAxis.getValuePosition(s.getXValue(), false), y2 = AbstractServiceGroupElapsedView.this.xyGraph.primaryYAxis.getValuePosition(s.getYValue(), false))))) continue;
                    minDistance = distance;
                    AbstractServiceGroupElapsedView.this.nearestTrace = t;
                    time = (long)s.getXValue();
                    value = s.getYValue();
                }
                if (AbstractServiceGroupElapsedView.this.nearestTrace != null) {
                    int width = PManager.getInstance().getInt("lineWidth");
                    AbstractServiceGroupElapsedView.this.nearestTrace.setLineWidth(width + 2);
                    toolTip.setText(String.valueOf(AbstractServiceGroupElapsedView.this.nearestTrace.getName()) + "\nTime : " + DateUtil.format((long)time, (String)"HH:mm:ss") + "\nValue : " + FormatUtil.print((Object)value, (String)"#,###.##"));
                    toolTip.show(new Point(e.x, e.y));
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.canvas.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                switch (e.keyCode) {
                    case 0x1000001: {
                        double max = AbstractServiceGroupElapsedView.this.xyGraph.primaryYAxis.getRange().getUpper();
                        AbstractServiceGroupElapsedView.this.manualY = max > 10000.0 ? max + 1000.0 : (max > 1000.0 ? max + 100.0 : (max > 100.0 ? max + 10.0 : (max == 3.0 ? 5.0 : max + 5.0)));
                        AbstractServiceGroupElapsedView.this.manualRangeCount = 5;
                        AbstractServiceGroupElapsedView.this.xyGraph.primaryYAxis.setRange(0.0, AbstractServiceGroupElapsedView.this.manualY);
                        break;
                    }
                    case 0x1000002: {
                        double max = AbstractServiceGroupElapsedView.this.xyGraph.primaryYAxis.getRange().getUpper();
                        AbstractServiceGroupElapsedView.this.manualY = max > 10000.0 ? max - 1000.0 : (max > 1000.0 ? max - 100.0 : (max > 100.0 ? max - 10.0 : (max - 5.0 > 3.0 ? max - 5.0 : 3.0)));
                        AbstractServiceGroupElapsedView.this.manualRangeCount = 5;
                        AbstractServiceGroupElapsedView.this.xyGraph.primaryYAxis.setRange(0.0, AbstractServiceGroupElapsedView.this.manualY);
                    }
                }
            }
        });
        this.xyGraph = new XYGraph();
        this.xyGraph.setShowLegend(true);
        this.xyGraph.setShowTitle(false);
        this.canvas.setContents((IFigure)this.xyGraph);
        this.xyGraph.primaryXAxis.setDateEnabled(true);
        this.xyGraph.primaryXAxis.setShowMajorGrid(true);
        this.xyGraph.primaryYAxis.setAutoScale(true);
        this.xyGraph.primaryYAxis.setShowMajorGrid(true);
        this.xyGraph.primaryXAxis.setTitle("");
        this.xyGraph.primaryYAxis.setTitle("");
        this.xyGraph.primaryYAxis.addMouseListener((MouseListener)new RangeMouseListener(this.getViewSite().getShell(), this.xyGraph.primaryYAxis));
        this.thread = new RefreshThread(this, 2000);
        this.thread.start();
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
        if (this.thread != null) {
            this.thread.shutdown();
        }
    }

    @Override
    public void refresh() {
        if (this.stopRefresh) {
            return;
        }
        MapPack m = this.fetch();
        if (m == null) {
            ExUtil.exec((Composite)this.canvas, new Runnable(){

                @Override
                public void run() {
                    AbstractServiceGroupElapsedView.this.setTitleImage(Images.inactive);
                    long now = TimeUtil.getCurrentTime();
                    AbstractServiceGroupElapsedView.this.xyGraph.primaryXAxis.setRange(now - 300000L, now + 1L);
                }
            });
            return;
        }
        this.removeDeadGroup(m);
        this.processElapsedData(m);
    }

    public abstract MapPack fetch();

    private void removeDeadGroup(MapPack m) {
        ListValue nameLv = m.getList("name");
        ArrayList<String> grpSet = new ArrayList<String>();
        Iterator<String> enu = this.traces.keySet().iterator();
        while (enu.hasNext()) {
            grpSet.add(enu.next());
        }
        int i = 0;
        while (i < nameLv.size()) {
            String name = nameLv.getString(i);
            grpSet.remove(name);
            ++i;
        }
        for (String dead : grpSet) {
            final Trace t = this.traces.get(dead);
            if (t == null) continue;
            ExUtil.exec((Composite)this.canvas, new Runnable(){

                @Override
                public void run() {
                    AbstractServiceGroupElapsedView.this.xyGraph.removeTrace(t);
                }
            });
            this.traces.remove(dead);
        }
    }

    private void processElapsedData(final MapPack m) {
        final ListValue nameLv = m.getList("name");
        final ListValue elapsedLv = m.getList("elapsed");
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                AbstractServiceGroupElapsedView.this.setTitleImage(Images.active);
                long now = m.getLong("time");
                long stime = now - 300000L;
                AbstractServiceGroupElapsedView.this.xyGraph.primaryXAxis.setRange(stime, now + 1L);
                int i = 0;
                while (i < nameLv.size()) {
                    String name = nameLv.getString(i);
                    double value = CastUtil.cdouble((Object)elapsedLv.get(i));
                    CircularBufferDataProvider provider = (CircularBufferDataProvider)AbstractServiceGroupElapsedView.this.getTrace(name).getDataProvider();
                    provider.addSample(new Sample(now, value));
                    ++i;
                }
                AbstractServiceGroupElapsedView.this.xyGraph.primaryYAxis.setRange(0.0, AbstractServiceGroupElapsedView.this.getMaxValue());
            }
        });
    }

    private Trace getTrace(String name) {
        Trace trace = this.traces.get(name);
        if (trace == null) {
            CircularBufferDataProvider provider = new CircularBufferDataProvider(true);
            provider.setBufferSize(200);
            trace = new Trace(name, this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, provider);
            trace.setPointStyle(Trace.PointStyle.NONE);
            trace.getXAxis().setFormatPattern("HH:mm:ss");
            trace.getYAxis().setFormatPattern("#,##0");
            trace.setLineWidth(PManager.getInstance().getInt("lineWidth"));
            trace.setTraceType(Trace.TraceType.SOLID_LINE);
            trace.setTraceColor(ServiceGroupColorManager.getInstance().assignColor(name));
            this.xyGraph.addTrace(trace);
            this.traces.put(name, trace);
        }
        return trace;
    }

    private double getMaxValue() {
        Range xRange = this.xyGraph.primaryXAxis.getRange();
        double lower = xRange.getLower();
        double upper = xRange.getUpper();
        if (this.manualRangeCount > 0 && this.manualY > 0.0) {
            --this.manualRangeCount;
            return this.manualY;
        }
        double max = 0.0;
        for (String name : this.traces.keySet()) {
            CircularBufferDataProvider data = (CircularBufferDataProvider)this.traces.get(name).getDataProvider();
            if (data == null) continue;
            int inx = 0;
            while (inx < data.getSize()) {
                double y;
                Sample sample = (Sample)data.getSample(inx);
                double x = sample.getXValue();
                if (!(x < lower) && !(x > upper) && (y = sample.getYValue()) > max) {
                    max = y;
                }
                ++inx;
            }
        }
        return ChartUtil.getGroupMaxValue(max);
    }
}

