/*
 * Decompiled with CFR 0.152.
 */
package scouter.client.views;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.csstudio.swt.xygraph.dataprovider.CircularBufferDataProvider;
import org.csstudio.swt.xygraph.dataprovider.ISample;
import org.csstudio.swt.xygraph.dataprovider.Sample;
import org.csstudio.swt.xygraph.figures.Trace;
import org.csstudio.swt.xygraph.figures.XYGraph;
import org.csstudio.swt.xygraph.linearscale.Range;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;
import scouter.client.Images;
import scouter.client.listeners.RangeMouseListener;
import scouter.client.model.RefreshThread;
import scouter.client.model.ServiceGroupColorManager;
import scouter.client.util.ChartUtil;
import scouter.client.util.ColorUtil;
import scouter.client.util.ExUtil;
import scouter.client.util.ScouterUtil;
import scouter.client.util.TimeUtil;
import scouter.client.util.UIUtil;
import scouter.lang.pack.MapPack;
import scouter.lang.value.ListValue;
import scouter.util.CastUtil;
import scouter.util.DateUtil;
import scouter.util.FormatUtil;
import scouter.util.LinkedMap;

public abstract class AbstractServiceGroupTPSView
extends ViewPart
implements RefreshThread.Refreshable {
    public static final String ID = AbstractServiceGroupTPSView.class.getName();
    private static final int BUFFER_SIZE = 200;
    protected RefreshThread thread;
    protected XYGraph xyGraph;
    protected FigureCanvas canvas;
    protected Map<String, Trace> traces = new HashMap<String, Trace>();
    private LinkedMap<String, StackValue> stackValueMap = new LinkedMap();
    private int manualRangeCount;
    private double manualY;
    boolean stopRefresh = false;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)UIUtil.formLayout(0, 0));
        this.canvas = new FigureCanvas(parent);
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.setLayoutData((Object)UIUtil.formData(0, 0, 0, 0, 100, 0, 100, 0));
        this.canvas.setBackground(ColorUtil.getInstance().getColor(1));
        this.canvas.addControlListener(new ControlListener(){
            boolean lock = false;

            public void controlResized(ControlEvent e) {
                Rectangle r = AbstractServiceGroupTPSView.this.canvas.getClientArea();
                if (!this.lock) {
                    this.lock = true;
                    AbstractServiceGroupTPSView.this.xyGraph.setSize(r.width, r.height);
                    this.lock = false;
                }
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        final DefaultToolTip toolTip = new DefaultToolTip((Control)this.canvas, 1, true);
        toolTip.setFont(new Font(null, "Arial", 10, 1));
        toolTip.setBackgroundColor(Display.getCurrent().getSystemColor(29));
        this.canvas.addMouseListener(new org.eclipse.swt.events.MouseListener(){
            String selectedName;

            public void mouseUp(MouseEvent e) {
                if (this.selectedName == null) {
                    return;
                }
                Trace trace = AbstractServiceGroupTPSView.this.traces.get(this.selectedName);
                trace.setTraceColor(ServiceGroupColorManager.getInstance().assignColor(this.selectedName));
                toolTip.hide();
                this.selectedName = null;
            }

            public void mouseDown(MouseEvent e) {
                double xValue = AbstractServiceGroupTPSView.this.xyGraph.primaryXAxis.getPositionValue(e.x, false);
                double yValue = AbstractServiceGroupTPSView.this.xyGraph.primaryYAxis.getPositionValue(e.y, false);
                if (AbstractServiceGroupTPSView.this.xyGraph.primaryXAxis.getRange().getLower() > xValue || AbstractServiceGroupTPSView.this.xyGraph.primaryXAxis.getRange().getUpper() < xValue) {
                    return;
                }
                if (AbstractServiceGroupTPSView.this.xyGraph.primaryYAxis.getRange().getLower() > yValue || AbstractServiceGroupTPSView.this.xyGraph.primaryYAxis.getRange().getUpper() < yValue) {
                    return;
                }
                List sortedTraces = AbstractServiceGroupTPSView.this.traces.values().stream().sorted(Comparator.comparingDouble(ScouterUtil.nearestPointYValueFunc(xValue)).reversed()).collect(Collectors.toList());
                ISample topSample = ScouterUtil.getNearestPoint(((Trace)sortedTraces.get(0)).getDataProvider(), xValue);
                double valueTime = topSample.getXValue();
                double total = topSample.getYValue();
                if (yValue > total) {
                    return;
                }
                int i = 0;
                Trace selectedTrace = null;
                while (i < sortedTraces.size()) {
                    Trace t = (Trace)sortedTraces.get(i);
                    double stackValue = ScouterUtil.getNearestValue(t.getDataProvider(), valueTime);
                    if (stackValue < yValue) {
                        selectedTrace = (Trace)sortedTraces.get(--i);
                        break;
                    }
                    ++i;
                }
                if (selectedTrace == null) {
                    selectedTrace = (Trace)sortedTraces.get(i - 1);
                }
                this.selectedName = selectedTrace.getName();
                double value = ScouterUtil.getNearestValue(selectedTrace.getDataProvider(), valueTime);
                if (i < sortedTraces.size() - 1) {
                    int j = i + 1;
                    double nextStackValue = value;
                    while (nextStackValue == value && j < sortedTraces.size()) {
                        nextStackValue = ScouterUtil.getNearestValue(((Trace)sortedTraces.get(j)).getDataProvider(), valueTime);
                        ++j;
                    }
                    if (nextStackValue < value) {
                        value -= nextStackValue;
                    }
                }
                double percent = value * 100.0 / total;
                selectedTrace.setTraceColor(ColorUtil.getInstance().getColor("dark magenta"));
                toolTip.setText(String.valueOf(DateUtil.format((long)CastUtil.clong((Object)valueTime), (String)"HH:mm:ss")) + "\n" + this.selectedName + "\n" + FormatUtil.print((Object)value, (String)"#,###0.#") + "(" + FormatUtil.print((Object)percent, (String)"##0.0") + " %)");
                toolTip.show(new Point(e.x, e.y));
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.canvas.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                switch (e.keyCode) {
                    case 0x1000001: {
                        double max = AbstractServiceGroupTPSView.this.xyGraph.primaryYAxis.getRange().getUpper();
                        AbstractServiceGroupTPSView.this.manualY = max > 10000.0 ? max + 1000.0 : (max > 1000.0 ? max + 100.0 : (max > 100.0 ? max + 10.0 : (max == 3.0 ? 5.0 : max + 5.0)));
                        AbstractServiceGroupTPSView.this.manualRangeCount = 5;
                        AbstractServiceGroupTPSView.this.xyGraph.primaryYAxis.setRange(0.0, AbstractServiceGroupTPSView.this.manualY);
                        break;
                    }
                    case 0x1000002: {
                        double max = AbstractServiceGroupTPSView.this.xyGraph.primaryYAxis.getRange().getUpper();
                        AbstractServiceGroupTPSView.this.manualY = max > 10000.0 ? max - 1000.0 : (max > 1000.0 ? max - 100.0 : (max > 100.0 ? max - 10.0 : (max - 5.0 > 3.0 ? max - 5.0 : 3.0)));
                        AbstractServiceGroupTPSView.this.manualRangeCount = 5;
                        AbstractServiceGroupTPSView.this.xyGraph.primaryYAxis.setRange(0.0, AbstractServiceGroupTPSView.this.manualY);
                    }
                }
            }
        });
        this.xyGraph = new XYGraph();
        this.xyGraph.setShowLegend(true);
        this.xyGraph.setShowTitle(false);
        this.canvas.setContents((IFigure)this.xyGraph);
        this.xyGraph.primaryXAxis.setDateEnabled(true);
        this.xyGraph.primaryXAxis.setShowMajorGrid(true);
        this.xyGraph.primaryYAxis.setAutoScale(true);
        this.xyGraph.primaryYAxis.setShowMajorGrid(true);
        this.xyGraph.primaryXAxis.setTitle("");
        this.xyGraph.primaryYAxis.setTitle("");
        this.xyGraph.primaryYAxis.addMouseListener((MouseListener)new RangeMouseListener(this.getViewSite().getShell(), this.xyGraph.primaryYAxis));
        this.thread = new RefreshThread(this, 2000);
        this.thread.start();
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
        if (this.thread != null) {
            this.thread.shutdown();
        }
    }

    @Override
    public void refresh() {
        if (this.stopRefresh) {
            return;
        }
        MapPack m = this.fetch();
        if (m == null) {
            ExUtil.exec((Composite)this.canvas, new Runnable(){

                @Override
                public void run() {
                    AbstractServiceGroupTPSView.this.setTitleImage(Images.inactive);
                    long now = TimeUtil.getCurrentTime();
                    AbstractServiceGroupTPSView.this.xyGraph.primaryXAxis.setRange(now - 300000L, now + 1L);
                }
            });
            return;
        }
        this.removeDeadGroup(m);
        this.processThroughputData(m);
    }

    public abstract MapPack fetch();

    private void removeDeadGroup(MapPack m) {
        ListValue nameLv = m.getList("name");
        ArrayList<String> grpSet = new ArrayList<String>();
        Enumeration enu = this.stackValueMap.keys();
        while (enu.hasMoreElements()) {
            grpSet.add((String)enu.nextElement());
        }
        int i = 0;
        while (i < nameLv.size()) {
            String name = nameLv.getString(i);
            grpSet.remove(name);
            ++i;
        }
        for (String dead : grpSet) {
            this.stackValueMap.remove((Object)dead);
            final Trace t = this.traces.get(dead);
            if (t == null) continue;
            ExUtil.exec((Composite)this.canvas, new Runnable(){

                @Override
                public void run() {
                    AbstractServiceGroupTPSView.this.xyGraph.removeTrace(t);
                }
            });
            this.traces.remove(dead);
        }
    }

    private void processThroughputData(MapPack m) {
        ListValue nameLv = m.getList("name");
        ListValue countLv = m.getList("count");
        final long now = m.getLong("time");
        final long stime = now - 300000L;
        int i = 0;
        while (i < nameLv.size()) {
            StackValue sv;
            String name = nameLv.getString(i);
            double value = CastUtil.cdouble((Object)countLv.get(i)) / 30.0;
            if (this.stackValueMap.containsKey((Object)name)) {
                sv = (StackValue)this.stackValueMap.get((Object)name);
                sv.actualValue = value;
                sv.lastUpdateTime = now;
            } else {
                sv = new StackValue();
                sv.actualValue = value;
                sv.lastUpdateTime = now;
                this.stackValueMap.putFirst((Object)name, (Object)sv);
            }
            ++i;
        }
        Enumeration itr = this.stackValueMap.keys();
        final LinkedMap tempMap = new LinkedMap();
        double stackValue = 0.0;
        while (itr.hasMoreElements()) {
            String name = (String)itr.nextElement();
            StackValue sv = (StackValue)this.stackValueMap.get((Object)name);
            if (sv.lastUpdateTime != now) continue;
            sv.stackedValue = stackValue += sv.actualValue;
            tempMap.putFirst((Object)name, (Object)sv);
        }
        ExUtil.exec((Composite)this.canvas, new Runnable(){

            @Override
            public void run() {
                AbstractServiceGroupTPSView.this.setTitleImage(Images.active);
                AbstractServiceGroupTPSView.this.xyGraph.primaryXAxis.setRange(stime, now + 1L);
                Enumeration itr = tempMap.keys();
                while (itr.hasMoreElements()) {
                    String name = (String)itr.nextElement();
                    StackValue sv = (StackValue)tempMap.get((Object)name);
                    CircularBufferDataProvider provider = (CircularBufferDataProvider)AbstractServiceGroupTPSView.this.getTrace(name).getDataProvider();
                    provider.addSample(new Sample(now, sv.stackedValue));
                }
                AbstractServiceGroupTPSView.this.xyGraph.primaryYAxis.setRange(0.0, AbstractServiceGroupTPSView.this.getMaxValue());
            }
        });
    }

    private Trace getTrace(String name) {
        Trace trace = this.traces.get(name);
        if (trace == null) {
            CircularBufferDataProvider provider = new CircularBufferDataProvider(true);
            provider.setBufferSize(200);
            trace = new Trace(name, this.xyGraph.primaryXAxis, this.xyGraph.primaryYAxis, provider);
            trace.setPointStyle(Trace.PointStyle.NONE);
            trace.getXAxis().setFormatPattern("HH:mm:ss");
            trace.getYAxis().setFormatPattern("#,##0");
            trace.setTraceType(Trace.TraceType.AREA);
            trace.setAreaAlpha(255);
            trace.setTraceColor(ServiceGroupColorManager.getInstance().assignColor(name));
            this.xyGraph.addTrace(trace);
            this.traces.put(name, trace);
        }
        return trace;
    }

    private double getMaxValue() {
        Range xRange = this.xyGraph.primaryXAxis.getRange();
        double lower = xRange.getLower();
        double upper = xRange.getUpper();
        if (this.manualRangeCount > 0 && this.manualY > 0.0) {
            --this.manualRangeCount;
            return this.manualY;
        }
        double max = 0.0;
        for (String name : this.traces.keySet()) {
            CircularBufferDataProvider data = (CircularBufferDataProvider)this.traces.get(name).getDataProvider();
            if (data == null) continue;
            int inx = 0;
            while (inx < data.getSize()) {
                double y;
                Sample sample = (Sample)data.getSample(inx);
                double x = sample.getXValue();
                if (!(x < lower) && !(x > upper) && (y = sample.getYValue()) > max) {
                    max = y;
                }
                ++inx;
            }
        }
        return ChartUtil.getGroupMaxValue(max);
    }

    static class StackValue {
        double actualValue;
        double stackedValue;
        long lastUpdateTime;

        StackValue() {
        }
    }
}

